/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.channel;

import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.Timer;
import io.micrometer.observation.Observation;
import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelInboundHandler;
import io.micrometer.shaded.io.netty.channel.ChannelOutboundHandler;
import io.micrometer.shaded.io.netty.channel.ChannelPromise;
import io.micrometer.shaded.io.netty.handler.ssl.SslHandler;
import io.micrometer.shaded.io.netty.util.concurrent.Future;
import io.micrometer.shaded.io.netty.util.concurrent.GenericFutureListener;
import io.micrometer.shaded.reactor.netty.Metrics;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.channel.AbstractChannelMetricsHandler;
import io.micrometer.shaded.reactor.netty.channel.ConnectObservations;
import io.micrometer.shaded.reactor.netty.channel.MicrometerChannelMetricsRecorder;
import io.micrometer.shaded.reactor.netty.observability.ReactorNettyHandlerContext;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.context.ContextView;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.Supplier;

public final class MicrometerChannelMetricsHandler
extends AbstractChannelMetricsHandler {
    final MicrometerChannelMetricsRecorder recorder;

    MicrometerChannelMetricsHandler(MicrometerChannelMetricsRecorder recorder, @Nullable SocketAddress remoteAddress, boolean onServer) {
        super(remoteAddress, onServer);
        this.recorder = recorder;
    }

    @Override
    public ChannelHandler connectMetricsHandler() {
        return new ConnectMetricsHandler(this.recorder);
    }

    @Override
    public ChannelHandler tlsMetricsHandler() {
        return new TlsMetricsHandler(this.recorder, this.onServer);
    }

    @Override
    public MicrometerChannelMetricsRecorder recorder() {
        return this.recorder;
    }

    static final class TlsMetricsHandler
    extends Observation.Context
    implements ReactorNettyHandlerContext,
    ChannelInboundHandler,
    Supplier<Observation.Context> {
        static final String CONTEXTUAL_NAME = "tls handshake";
        static final String TYPE_CLIENT = "client";
        static final String TYPE_SERVER = "server";
        final MicrometerChannelMetricsRecorder recorder;
        final String type;
        Observation observation;
        String netPeerName;
        String netPeerPort;
        String status = "UNKNOWN";
        ContextView parentContextView;

        TlsMetricsHandler(MicrometerChannelMetricsRecorder recorder, boolean onServer) {
            this.recorder = recorder;
            this.type = onServer ? TYPE_SERVER : TYPE_CLIENT;
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            SocketAddress remoteAddress = ctx.channel().remoteAddress();
            if (remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)remoteAddress;
                this.netPeerName = address.getHostString();
                this.netPeerPort = address.getPort() + "";
            } else {
                this.netPeerName = remoteAddress.toString();
                this.netPeerPort = "";
            }
            this.observation = Observation.createNotStarted(this.recorder.name() + ".tls.handshake.time", this, Metrics.OBSERVATION_REGISTRY);
            this.parentContextView = Metrics.updateChannelContext(ctx.channel(), this.observation);
            this.observation.start();
            ctx.pipeline().get(SslHandler.class).handshakeFuture().addListener(f -> {
                ctx.pipeline().remove(this);
                this.status = f.isSuccess() ? "SUCCESS" : "ERROR";
                this.observation.stop();
                ReactorNetty.setChannelContext(ctx.channel(), this.parentContextView);
                this.parentContextView = null;
            });
            ctx.fireChannelActive();
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
            ctx.fireChannelInactive();
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            ctx.fireChannelRead(msg);
        }

        @Override
        public void channelReadComplete(ChannelHandlerContext ctx) {
            ctx.fireChannelReadComplete();
        }

        @Override
        public void channelRegistered(ChannelHandlerContext ctx) {
            ctx.fireChannelRegistered();
        }

        @Override
        public void channelUnregistered(ChannelHandlerContext ctx) {
            ctx.fireChannelUnregistered();
        }

        @Override
        public void channelWritabilityChanged(ChannelHandlerContext ctx) {
            ctx.fireChannelWritabilityChanged();
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.fireExceptionCaught(cause);
        }

        @Override
        public Observation.Context get() {
            return this;
        }

        @Override
        public String getContextualName() {
            return CONTEXTUAL_NAME;
        }

        @Override
        public KeyValues getHighCardinalityKeyValues() {
            return KeyValues.of(ConnectObservations.ConnectTimeHighCardinalityTags.NET_PEER_NAME.asString(), this.netPeerName, ConnectObservations.ConnectTimeHighCardinalityTags.NET_PEER_PORT.asString(), this.netPeerPort, ConnectObservations.ConnectTimeHighCardinalityTags.REACTOR_NETTY_PROTOCOL.asString(), this.recorder.protocol(), ConnectObservations.ConnectTimeHighCardinalityTags.REACTOR_NETTY_STATUS.asString(), this.status, ConnectObservations.ConnectTimeHighCardinalityTags.REACTOR_NETTY_TYPE.asString(), this.type);
        }

        @Override
        public KeyValues getLowCardinalityKeyValues() {
            return KeyValues.of(ConnectObservations.ConnectTimeLowCardinalityTags.REMOTE_ADDRESS.asString(), this.netPeerName + ':' + this.netPeerPort, ConnectObservations.ConnectTimeLowCardinalityTags.STATUS.asString(), this.status);
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx) {
        }

        @Override
        public void handlerRemoved(ChannelHandlerContext ctx) {
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            ctx.fireUserEventTriggered(evt);
        }

        @Override
        public Timer getTimer() {
            return this.recorder.getTlsHandshakeTimer(this.getName(), this.netPeerName + ':' + this.netPeerPort, this.status);
        }
    }

    static final class ConnectMetricsHandler
    extends Observation.Context
    implements ReactorNettyHandlerContext,
    ChannelOutboundHandler,
    Supplier<Observation.Context> {
        static final String CONTEXTUAL_NAME = "connect";
        static final String TYPE = "client";
        final MicrometerChannelMetricsRecorder recorder;
        String netPeerName;
        String netPeerPort;
        String status = "UNKNOWN";
        ContextView parentContextView;

        ConnectMetricsHandler(MicrometerChannelMetricsRecorder recorder) {
            this.recorder = recorder;
        }

        @Override
        public Observation.Context get() {
            return this;
        }

        @Override
        public Timer getTimer() {
            return this.recorder.getConnectTimer(this.getName(), this.netPeerName + ":" + this.netPeerPort, this.status);
        }

        @Override
        public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
            ctx.bind(localAddress, promise);
        }

        @Override
        public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
            ctx.close(promise);
        }

        @Override
        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            if (remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress address = (InetSocketAddress)remoteAddress;
                this.netPeerName = address.getHostString();
                this.netPeerPort = address.getPort() + "";
            } else {
                this.netPeerName = remoteAddress.toString();
                this.netPeerPort = "";
            }
            Observation observation = Observation.createNotStarted(this.recorder.name() + ".connect.time", this, Metrics.OBSERVATION_REGISTRY);
            this.parentContextView = Metrics.updateChannelContext(ctx.channel(), observation);
            observation.start();
            ctx.connect(remoteAddress, localAddress, promise).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                ctx.pipeline().remove(this);
                this.status = future.isSuccess() ? "SUCCESS" : "ERROR";
                observation.stop();
                ReactorNetty.setChannelContext(ctx.channel(), this.parentContextView);
                this.parentContextView = null;
            }));
        }

        @Override
        public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
            ctx.deregister(promise);
        }

        @Override
        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
            ctx.disconnect(promise);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.fireExceptionCaught(cause);
        }

        @Override
        public void flush(ChannelHandlerContext ctx) {
            ctx.flush();
        }

        @Override
        public String getContextualName() {
            return CONTEXTUAL_NAME;
        }

        @Override
        public KeyValues getHighCardinalityKeyValues() {
            return KeyValues.of(ConnectObservations.ConnectTimeHighCardinalityTags.NET_PEER_NAME.asString(), this.netPeerName, ConnectObservations.ConnectTimeHighCardinalityTags.NET_PEER_PORT.asString(), this.netPeerPort, ConnectObservations.ConnectTimeHighCardinalityTags.REACTOR_NETTY_PROTOCOL.asString(), this.recorder.protocol(), ConnectObservations.ConnectTimeHighCardinalityTags.REACTOR_NETTY_STATUS.asString(), this.status, ConnectObservations.ConnectTimeHighCardinalityTags.REACTOR_NETTY_TYPE.asString(), TYPE);
        }

        @Override
        public KeyValues getLowCardinalityKeyValues() {
            return KeyValues.of(ConnectObservations.ConnectTimeLowCardinalityTags.REMOTE_ADDRESS.asString(), this.netPeerName + ":" + this.netPeerPort, ConnectObservations.ConnectTimeLowCardinalityTags.STATUS.asString(), this.status);
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx) {
        }

        @Override
        public void handlerRemoved(ChannelHandlerContext ctx) {
        }

        @Override
        public void read(ChannelHandlerContext ctx) {
            ctx.read();
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            ctx.write(msg, promise);
        }
    }
}

