/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.gridfs;

import com.mongodb.assertions.Assertions;
import com.mongodb.lang.NonNull;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

class ResizingByteBufferFlux
extends Flux<ByteBuffer> {
    private final Publisher<ByteBuffer> source;
    private final int outputByteBufferSize;

    ResizingByteBufferFlux(Publisher<ByteBuffer> source2, int outputByteBufferSize) {
        Assertions.notNull("source must not be null", source2);
        Assertions.isTrue("'outputByteBufferSize' must be a positive number", outputByteBufferSize >= 0);
        this.source = source2;
        this.outputByteBufferSize = outputByteBufferSize;
    }

    @Override
    public void subscribe(CoreSubscriber<? super ByteBuffer> actual) {
        Flux.push(sink2 -> {
            BaseSubscriber<ByteBuffer> subscriber = new BaseSubscriber<ByteBuffer>(){
                private volatile ByteBuffer remainder;
                private final AtomicLong requested = new AtomicLong();
                private volatile boolean startedProcessing = false;
                private volatile boolean finished = false;

                @Override
                protected void hookOnSubscribe(Subscription subscription) {
                    sink2.onCancel(() -> this.upstream().cancel());
                    sink2.onRequest(l -> {
                        1 var3_2 = this;
                        synchronized (var3_2) {
                            this.requested.addAndGet(l);
                            if (!this.startedProcessing) {
                                this.startedProcessing = true;
                                this.upstream().request(1L);
                            }
                        }
                    });
                }

                @Override
                protected void hookOnNext(@NonNull ByteBuffer value) {
                    if (this.remainder == null || this.remainder.remaining() == 0) {
                        this.remainder = value;
                    } else {
                        byte[] byteArray = new byte[this.remainder.remaining() + value.remaining()];
                        ByteBuffer newBuffer = ByteBuffer.wrap(byteArray);
                        this.copyByteBuffer(this.remainder, newBuffer);
                        this.copyByteBuffer(value, newBuffer);
                        ((Buffer)newBuffer).flip();
                        this.remainder = newBuffer;
                    }
                    while (this.remainder != null && this.remainder.remaining() >= ResizingByteBufferFlux.this.outputByteBufferSize) {
                        int newLimit = this.remainder.position() + ResizingByteBufferFlux.this.outputByteBufferSize;
                        ByteBuffer next = this.remainder.duplicate();
                        ((Buffer)next).limit(newLimit);
                        this.requested.decrementAndGet();
                        sink2.next(next);
                        ((Buffer)this.remainder).position(newLimit);
                    }
                    if (this.requested.get() > 0L) {
                        this.upstream().request(1L);
                    }
                }

                @Override
                protected void hookOnComplete() {
                    if (!this.finished) {
                        this.finished = true;
                        if (this.remainder != null && this.remainder.remaining() > 0) {
                            sink2.next(this.remainder);
                        }
                        sink2.complete();
                    }
                }

                @Override
                protected void hookOnError(@NonNull Throwable throwable) {
                    sink2.error(throwable);
                }

                private void copyByteBuffer(ByteBuffer original, ByteBuffer destination) {
                    if (original.hasArray() && destination.hasArray()) {
                        System.arraycopy(original.array(), original.position(), destination.array(), destination.position(), original.remaining());
                        ((Buffer)destination).position(destination.position() + original.remaining());
                    } else {
                        destination.put(original);
                    }
                }
            };
            this.source.subscribe((Subscriber<ByteBuffer>)subscriber);
        }, FluxSink.OverflowStrategy.BUFFER).subscribe(actual);
    }
}

