/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropCollectionOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.client.model.FindOptions;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.ExplainableReadOperation;
import com.mongodb.internal.operation.MapReduceBatchCursor;
import com.mongodb.internal.operation.MapReduceStatistics;
import com.mongodb.internal.operation.Operations;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.WriteOperation;
import java.util.List;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class SyncOperations<TDocument> {
    private final Operations<TDocument> operations;

    public SyncOperations(Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry, boolean retryReads) {
        this(null, documentClass, readPreference, codecRegistry, ReadConcern.DEFAULT, WriteConcern.ACKNOWLEDGED, true, retryReads);
    }

    public SyncOperations(MongoNamespace namespace, Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry, boolean retryReads) {
        this(namespace, documentClass, readPreference, codecRegistry, ReadConcern.DEFAULT, WriteConcern.ACKNOWLEDGED, true, retryReads);
    }

    public SyncOperations(MongoNamespace namespace, Class<TDocument> documentClass, ReadPreference readPreference, CodecRegistry codecRegistry, ReadConcern readConcern, WriteConcern writeConcern, boolean retryWrites, boolean retryReads) {
        this.operations = new Operations<TDocument>(namespace, documentClass, readPreference, codecRegistry, readConcern, writeConcern, retryWrites, retryReads);
    }

    public ReadOperation<Long> countDocuments(Bson filter2, CountOptions options) {
        return this.operations.countDocuments(filter2, options);
    }

    public ReadOperation<Long> estimatedDocumentCount(EstimatedDocumentCountOptions options) {
        return this.operations.estimatedDocumentCount(options);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> findFirst(Bson filter2, Class<TResult> resultClass, FindOptions options) {
        return this.operations.findFirst(filter2, resultClass, options);
    }

    public <TResult> ExplainableReadOperation<BatchCursor<TResult>> find(Bson filter2, Class<TResult> resultClass, FindOptions options) {
        return this.operations.find(filter2, resultClass, options);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> find(MongoNamespace findNamespace, Bson filter2, Class<TResult> resultClass, FindOptions options) {
        return this.operations.find(findNamespace, filter2, resultClass, options);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> distinct(String fieldName, Bson filter2, Class<TResult> resultClass, long maxTimeMS, Collation collation, BsonValue comment) {
        return this.operations.distinct(fieldName, filter2, resultClass, maxTimeMS, collation, comment);
    }

    public <TResult> ExplainableReadOperation<BatchCursor<TResult>> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass, long maxTimeMS, long maxAwaitTimeMS, Integer batchSize, Collation collation, Bson hint, String hintString, BsonValue comment, Bson variables, Boolean allowDiskUse, AggregationLevel aggregationLevel) {
        return this.operations.aggregate(pipeline, resultClass, maxTimeMS, maxAwaitTimeMS, batchSize, collation, hint, hintString, comment, variables, allowDiskUse, aggregationLevel);
    }

    public ReadOperation<Void> aggregateToCollection(List<? extends Bson> pipeline, long maxTimeMS, Boolean allowDiskUse, Boolean bypassDocumentValidation, Collation collation, Bson hint, String hintString, BsonValue comment, Bson variables, AggregationLevel aggregationLevel) {
        return this.operations.aggregateToCollection(pipeline, maxTimeMS, allowDiskUse, bypassDocumentValidation, collation, hint, hintString, comment, variables, aggregationLevel);
    }

    public WriteOperation<MapReduceStatistics> mapReduceToCollection(String databaseName, String collectionName, String mapFunction, String reduceFunction, String finalizeFunction, Bson filter2, int limit, long maxTimeMS, boolean jsMode, Bson scope, Bson sort, boolean verbose, MapReduceAction action, boolean nonAtomic, boolean sharded, Boolean bypassDocumentValidation, Collation collation) {
        return this.operations.mapReduceToCollection(databaseName, collectionName, mapFunction, reduceFunction, finalizeFunction, filter2, limit, maxTimeMS, jsMode, scope, sort, verbose, action, nonAtomic, sharded, bypassDocumentValidation, collation);
    }

    public <TResult> ReadOperation<MapReduceBatchCursor<TResult>> mapReduce(String mapFunction, String reduceFunction, String finalizeFunction, Class<TResult> resultClass, Bson filter2, int limit, long maxTimeMS, boolean jsMode, Bson scope, Bson sort, boolean verbose, Collation collation) {
        return this.operations.mapReduce(mapFunction, reduceFunction, finalizeFunction, resultClass, filter2, limit, maxTimeMS, jsMode, scope, sort, verbose, collation);
    }

    public WriteOperation<TDocument> findOneAndDelete(Bson filter2, FindOneAndDeleteOptions options) {
        return this.operations.findOneAndDelete(filter2, options);
    }

    public WriteOperation<TDocument> findOneAndReplace(Bson filter2, TDocument replacement, FindOneAndReplaceOptions options) {
        return this.operations.findOneAndReplace(filter2, replacement, options);
    }

    public WriteOperation<TDocument> findOneAndUpdate(Bson filter2, Bson update, FindOneAndUpdateOptions options) {
        return this.operations.findOneAndUpdate(filter2, update, options);
    }

    public WriteOperation<TDocument> findOneAndUpdate(Bson filter2, List<? extends Bson> update, FindOneAndUpdateOptions options) {
        return this.operations.findOneAndUpdate(filter2, update, options);
    }

    public WriteOperation<BulkWriteResult> insertOne(TDocument document, InsertOneOptions options) {
        return this.operations.insertOne(document, options);
    }

    public WriteOperation<BulkWriteResult> replaceOne(Bson filter2, TDocument replacement, ReplaceOptions options) {
        return this.operations.replaceOne(filter2, replacement, options);
    }

    public WriteOperation<BulkWriteResult> deleteOne(Bson filter2, DeleteOptions options) {
        return this.operations.deleteOne(filter2, options);
    }

    public WriteOperation<BulkWriteResult> deleteMany(Bson filter2, DeleteOptions options) {
        return this.operations.deleteMany(filter2, options);
    }

    public WriteOperation<BulkWriteResult> updateOne(Bson filter2, Bson update, UpdateOptions updateOptions) {
        return this.operations.updateOne(filter2, update, updateOptions);
    }

    public WriteOperation<BulkWriteResult> updateOne(Bson filter2, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.operations.updateOne(filter2, update, updateOptions);
    }

    public WriteOperation<BulkWriteResult> updateMany(Bson filter2, Bson update, UpdateOptions updateOptions) {
        return this.operations.updateMany(filter2, update, updateOptions);
    }

    public WriteOperation<BulkWriteResult> updateMany(Bson filter2, List<? extends Bson> update, UpdateOptions updateOptions) {
        return this.operations.updateMany(filter2, update, updateOptions);
    }

    public WriteOperation<BulkWriteResult> insertMany(List<? extends TDocument> documents, InsertManyOptions options) {
        return this.operations.insertMany(documents, options);
    }

    public WriteOperation<BulkWriteResult> bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options) {
        return this.operations.bulkWrite(requests, options);
    }

    public WriteOperation<Void> dropCollection(DropCollectionOptions dropCollectionOptions, AutoEncryptionSettings autoEncryptionSettings) {
        return this.operations.dropCollection(dropCollectionOptions, autoEncryptionSettings);
    }

    public WriteOperation<Void> renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions options) {
        return this.operations.renameCollection(newCollectionNamespace, options);
    }

    public WriteOperation<Void> createIndexes(List<IndexModel> indexes, CreateIndexOptions options) {
        return this.operations.createIndexes(indexes, options);
    }

    public WriteOperation<Void> dropIndex(String indexName, DropIndexOptions options) {
        return this.operations.dropIndex(indexName, options);
    }

    public WriteOperation<Void> dropIndex(Bson keys2, DropIndexOptions options) {
        return this.operations.dropIndex(keys2, options);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> listCollections(String databaseName, Class<TResult> resultClass, Bson filter2, boolean collectionNamesOnly, Integer batchSize, long maxTimeMS, BsonValue comment) {
        return this.operations.listCollections(databaseName, resultClass, filter2, collectionNamesOnly, batchSize, maxTimeMS, comment);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> listDatabases(Class<TResult> resultClass, Bson filter2, Boolean nameOnly, long maxTimeMS, Boolean authorizedDatabases, BsonValue comment) {
        return this.operations.listDatabases(resultClass, filter2, nameOnly, maxTimeMS, authorizedDatabases, comment);
    }

    public <TResult> ReadOperation<BatchCursor<TResult>> listIndexes(Class<TResult> resultClass, Integer batchSize, long maxTimeMS, BsonValue comment) {
        return this.operations.listIndexes(resultClass, batchSize, maxTimeMS, comment);
    }
}

