/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.sdp.format;

import org.restcomm.media.sdp.format.RTPFormat;
import org.restcomm.media.sdp.format.RTPFormats;
import org.restcomm.media.spi.format.AudioFormat;
import org.restcomm.media.spi.format.FormatFactory;
import org.restcomm.media.spi.utils.Text;

public class AVProfile {
    public static final Text AUDIO = new Text("audio");
    public static final Text VIDEO = new Text("video");
    public static final int DYNAMIC_PT_MIN = 96;
    public static final int DYNAMIC_PT_MAX = 127;
    public static final int telephoneEventsID = 101;
    public static final AudioFormat telephoneEvent = FormatFactory.createAudioFormat("telephone-event", 8000);
    public static final RTPFormats audio;
    public static final RTPFormats video;
    public static final RTPFormats application;
    private static final RTPFormat pcmu;
    private static final RTPFormat pcma;
    private static final RTPFormat gsm;
    private static final RTPFormat g729;
    private static final RTPFormat l16;
    private static final RTPFormat dtmf;
    private static final RTPFormat ilbc;
    private static final RTPFormat opus;
    private static final RTPFormat linear;
    private static final RTPFormat H261;
    private static final RTPFormat H263;
    private static final RTPFormat MP4V_ES;

    public static RTPFormat getFormat(int p) {
        RTPFormat res = audio.find(p);
        return res == null ? video.find(p) : res;
    }

    public static RTPFormat getFormat(String name) {
        RTPFormat res = audio.getRTPFormat(name);
        return res == null ? video.getRTPFormat(name) : res;
    }

    public static RTPFormat getFormat(int p, Text mediaType) {
        RTPFormat res = null;
        if (mediaType.equals(AUDIO)) {
            res = audio.find(p);
        } else if (mediaType.equals(VIDEO)) {
            res = video.find(p);
        }
        return res;
    }

    public static boolean isDtmf(RTPFormat format) {
        return format != null && dtmf.getFormat().getName().equals(format.getFormat().getName());
    }

    public static boolean isDefaultDtmf(RTPFormat format) {
        return format != null && dtmf.getID() == format.getID();
    }

    static {
        telephoneEvent.setOptions(new Text("0-15"));
        audio = new RTPFormats();
        video = new RTPFormats();
        application = new RTPFormats();
        pcmu = new RTPFormat(0, FormatFactory.createAudioFormat("pcmu", 8000, 8, 1), 8000);
        pcma = new RTPFormat(8, FormatFactory.createAudioFormat("pcma", 8000, 8, 1), 8000);
        gsm = new RTPFormat(3, FormatFactory.createAudioFormat("gsm", 8000), 8000);
        g729 = new RTPFormat(18, FormatFactory.createAudioFormat("g729", 8000), 8000);
        l16 = new RTPFormat(97, FormatFactory.createAudioFormat("l16", 8000, 16, 1), 8000);
        dtmf = new RTPFormat(101, telephoneEvent, 8000);
        ilbc = new RTPFormat(102, FormatFactory.createAudioFormat("ilbc", 8000, 16, 1), 8000);
        opus = new RTPFormat(111, FormatFactory.createAudioFormat("opus", 48000, 16, 2), 48000);
        linear = new RTPFormat(150, FormatFactory.createAudioFormat("linear", 8000, 16, 1), 8000);
        H261 = new RTPFormat(45, FormatFactory.createVideoFormat("h261"));
        H263 = new RTPFormat(34, FormatFactory.createVideoFormat("h263"));
        MP4V_ES = new RTPFormat(96, FormatFactory.createVideoFormat("mp4v-es"));
        audio.add(pcma);
        audio.add(pcmu);
        audio.add(gsm);
        audio.add(g729);
        audio.add(l16);
        audio.add(ilbc);
        audio.add(opus);
        audio.add(dtmf);
        video.add(H261);
        video.add(H263);
        video.add(MP4V_ES);
    }
}

