/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.sdp.fields.parser;

import java.util.regex.Pattern;
import org.restcomm.media.sdp.SdpException;
import org.restcomm.media.sdp.SdpParser;
import org.restcomm.media.sdp.fields.SessionNameField;

public class SessionNameFieldParser
implements SdpParser<SessionNameField> {
    private static final String REGEX = "^s=\\s|(\\S+\\s?)+$";
    private static final Pattern PATTERN = Pattern.compile("^s=\\s|(\\S+\\s?)+$");

    @Override
    public boolean canParse(String sdp) {
        if (sdp == null || sdp.isEmpty()) {
            return false;
        }
        return PATTERN.matcher(sdp.trim()).matches();
    }

    @Override
    public SessionNameField parse(String sdp) throws SdpException {
        try {
            return new SessionNameField(sdp.trim().substring(2));
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }

    @Override
    public void parse(SessionNameField field, String sdp) throws SdpException {
        try {
            field.setName(sdp.trim().substring(2));
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }
}

