/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.DisplayNameGeneration;
import org.junit.jupiter.api.IndicativeSentencesGeneration;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.STABLE, since="5.7")
public interface DisplayNameGenerator {
    public String generateDisplayNameForClass(Class<?> var1);

    public String generateDisplayNameForNestedClass(Class<?> var1);

    public String generateDisplayNameForMethod(Class<?> var1, Method var2);

    public static String parameterTypesAsString(Method method) {
        Preconditions.notNull(method, "Method must not be null");
        return '(' + ClassUtils.nullSafeToString(Class::getSimpleName, method.getParameterTypes()) + ')';
    }

    public static DisplayNameGenerator getDisplayNameGenerator(Class<?> generatorClass) {
        Preconditions.notNull(generatorClass, "Class must not be null");
        Preconditions.condition(DisplayNameGenerator.class.isAssignableFrom(generatorClass), "Class must be a DisplayNameGenerator implementation");
        if (generatorClass == Standard.class) {
            return Standard.INSTANCE;
        }
        if (generatorClass == Simple.class) {
            return Simple.INSTANCE;
        }
        if (generatorClass == ReplaceUnderscores.class) {
            return ReplaceUnderscores.INSTANCE;
        }
        if (generatorClass == IndicativeSentences.class) {
            return IndicativeSentences.INSTANCE;
        }
        return (DisplayNameGenerator)ReflectionUtils.newInstance(generatorClass, new Object[0]);
    }

    public static class Standard
    implements DisplayNameGenerator {
        static final DisplayNameGenerator INSTANCE = new Standard();

        @Override
        public String generateDisplayNameForClass(Class<?> testClass) {
            String name = testClass.getName();
            int lastDot = name.lastIndexOf(46);
            return name.substring(lastDot + 1);
        }

        @Override
        public String generateDisplayNameForNestedClass(Class<?> nestedClass) {
            return nestedClass.getSimpleName();
        }

        @Override
        public String generateDisplayNameForMethod(Class<?> testClass, Method testMethod) {
            return testMethod.getName() + DisplayNameGenerator.parameterTypesAsString(testMethod);
        }
    }

    public static class Simple
    extends Standard {
        static final DisplayNameGenerator INSTANCE = new Simple();

        @Override
        public String generateDisplayNameForMethod(Class<?> testClass, Method testMethod) {
            String displayName = testMethod.getName();
            if (Simple.hasParameters(testMethod)) {
                displayName = displayName + ' ' + DisplayNameGenerator.parameterTypesAsString(testMethod);
            }
            return displayName;
        }

        private static boolean hasParameters(Method method) {
            return method.getParameterCount() > 0;
        }
    }

    public static class ReplaceUnderscores
    extends Simple {
        static final DisplayNameGenerator INSTANCE = new ReplaceUnderscores();

        @Override
        public String generateDisplayNameForClass(Class<?> testClass) {
            return ReplaceUnderscores.replaceUnderscores(super.generateDisplayNameForClass(testClass));
        }

        @Override
        public String generateDisplayNameForNestedClass(Class<?> nestedClass) {
            return ReplaceUnderscores.replaceUnderscores(super.generateDisplayNameForNestedClass(nestedClass));
        }

        @Override
        public String generateDisplayNameForMethod(Class<?> testClass, Method testMethod) {
            return ReplaceUnderscores.replaceUnderscores(super.generateDisplayNameForMethod(testClass, testMethod));
        }

        private static String replaceUnderscores(String name) {
            return name.replace('_', ' ');
        }
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.7")
    public static class IndicativeSentences
    implements DisplayNameGenerator {
        static final DisplayNameGenerator INSTANCE = new IndicativeSentences();

        @Override
        public String generateDisplayNameForClass(Class<?> testClass) {
            return IndicativeSentences.getGeneratorFor(testClass).generateDisplayNameForClass(testClass);
        }

        @Override
        public String generateDisplayNameForNestedClass(Class<?> nestedClass) {
            return this.getSentenceBeginning(nestedClass);
        }

        @Override
        public String generateDisplayNameForMethod(Class<?> testClass, Method testMethod) {
            return this.getSentenceBeginning(testClass) + IndicativeSentences.getFragmentSeparator(testClass) + IndicativeSentences.getGeneratorFor(testClass).generateDisplayNameForMethod(testClass, testMethod);
        }

        private String getSentenceBeginning(Class<?> testClass) {
            Class<?> enclosingClass = testClass.getEnclosingClass();
            boolean topLevelTestClass = enclosingClass == null || ModifierSupport.isStatic(testClass);
            Optional<String> displayName = AnnotationUtils.findAnnotation(testClass, DisplayName.class).map(DisplayName::value).map(String::trim);
            if (topLevelTestClass) {
                if (displayName.isPresent()) {
                    return displayName.get();
                }
                Class generatorClass = IndicativeSentences.findDisplayNameGeneration(testClass).map(DisplayNameGeneration::value).filter(IndicativeSentences.not(IndicativeSentences.class)).orElse(null);
                if (generatorClass != null) {
                    return DisplayNameGenerator.getDisplayNameGenerator(generatorClass).generateDisplayNameForClass(testClass);
                }
                return this.generateDisplayNameForClass(testClass);
            }
            boolean buildPrefix = IndicativeSentences.findDisplayNameGeneration(enclosingClass).map(DisplayNameGeneration::value).filter(IndicativeSentences.class::equals).isPresent();
            String prefix = buildPrefix ? this.getSentenceBeginning(enclosingClass) + IndicativeSentences.getFragmentSeparator(testClass) : "";
            return prefix + displayName.orElseGet(() -> IndicativeSentences.getGeneratorFor(testClass).generateDisplayNameForNestedClass(testClass));
        }

        private static String getFragmentSeparator(Class<?> testClass) {
            return IndicativeSentences.findIndicativeSentencesGeneration(testClass).map(IndicativeSentencesGeneration::separator).orElse(", ");
        }

        private static DisplayNameGenerator getGeneratorFor(Class<?> testClass) {
            return IndicativeSentences.findIndicativeSentencesGeneration(testClass).map(IndicativeSentencesGeneration::generator).filter(IndicativeSentences.not(IndicativeSentences.class)).map(DisplayNameGenerator::getDisplayNameGenerator).orElseGet(() -> DisplayNameGenerator.getDisplayNameGenerator(IndicativeSentencesGeneration.DEFAULT_GENERATOR));
        }

        private static Optional<DisplayNameGeneration> findDisplayNameGeneration(Class<?> testClass) {
            return AnnotationUtils.findAnnotation(testClass, DisplayNameGeneration.class, true);
        }

        private static Optional<IndicativeSentencesGeneration> findIndicativeSentencesGeneration(Class<?> testClass) {
            return AnnotationUtils.findAnnotation(testClass, IndicativeSentencesGeneration.class, true);
        }

        private static Predicate<Class<?>> not(Class<?> clazz) {
            return ((Predicate<Class>)clazz::equals).negate();
        }
    }
}

