/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Map;
import org.apache.logging.log4j.util.Chars;
import org.apache.logging.log4j.util.StringBuilderFormattable;

public final class StringBuilders {
    private StringBuilders() {
    }

    public static StringBuilder appendDqValue(StringBuilder sb, Object value) {
        return sb.append('\"').append(value).append('\"');
    }

    public static StringBuilder appendKeyDqValue(StringBuilder sb, Map.Entry<String, String> entry) {
        return StringBuilders.appendKeyDqValue(sb, entry.getKey(), entry.getValue());
    }

    public static StringBuilder appendKeyDqValue(StringBuilder sb, String key, Object value) {
        return sb.append(key).append('=').append('\"').append(value).append('\"');
    }

    public static void appendValue(StringBuilder stringBuilder, Object obj) {
        if (!StringBuilders.appendSpecificTypes(stringBuilder, obj)) {
            stringBuilder.append(obj);
        }
    }

    public static boolean appendSpecificTypes(StringBuilder stringBuilder, Object obj) {
        if (obj == null || obj instanceof String) {
            stringBuilder.append((String)obj);
        } else if (obj instanceof StringBuilderFormattable) {
            ((StringBuilderFormattable)obj).formatTo(stringBuilder);
        } else if (obj instanceof CharSequence) {
            stringBuilder.append((CharSequence)obj);
        } else if (obj instanceof Integer) {
            stringBuilder.append((Integer)obj);
        } else if (obj instanceof Long) {
            stringBuilder.append((Long)obj);
        } else if (obj instanceof Double) {
            stringBuilder.append((Double)obj);
        } else if (obj instanceof Boolean) {
            stringBuilder.append((Boolean)obj);
        } else if (obj instanceof Character) {
            stringBuilder.append(((Character)obj).charValue());
        } else if (obj instanceof Short) {
            stringBuilder.append(((Short)obj).shortValue());
        } else if (obj instanceof Float) {
            stringBuilder.append(((Float)obj).floatValue());
        } else if (obj instanceof Byte) {
            stringBuilder.append(((Byte)obj).byteValue());
        } else {
            return false;
        }
        return true;
    }

    public static boolean equals(CharSequence left, int leftOffset, int leftLength, CharSequence right, int rightOffset, int rightLength) {
        if (leftLength == rightLength) {
            for (int i2 = 0; i2 < rightLength; ++i2) {
                if (left.charAt(i2 + leftOffset) == right.charAt(i2 + rightOffset)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equalsIgnoreCase(CharSequence left, int leftOffset, int leftLength, CharSequence right, int rightOffset, int rightLength) {
        if (leftLength == rightLength) {
            for (int i2 = 0; i2 < rightLength; ++i2) {
                if (Character.toLowerCase(left.charAt(i2 + leftOffset)) == Character.toLowerCase(right.charAt(i2 + rightOffset))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void trimToMaxSize(StringBuilder stringBuilder, int maxSize) {
        if (stringBuilder != null && stringBuilder.capacity() > maxSize) {
            stringBuilder.setLength(maxSize);
            stringBuilder.trimToSize();
        }
    }

    public static void escapeJson(StringBuilder toAppendTo, int start2) {
        block8: for (int i2 = toAppendTo.length() - 1; i2 >= start2; --i2) {
            char c = toAppendTo.charAt(i2);
            switch (c) {
                case '\b': {
                    toAppendTo.setCharAt(i2, '\\');
                    toAppendTo.insert(i2 + 1, 'b');
                    continue block8;
                }
                case '\t': {
                    toAppendTo.setCharAt(i2, '\\');
                    toAppendTo.insert(i2 + 1, 't');
                    continue block8;
                }
                case '\f': {
                    toAppendTo.setCharAt(i2, '\\');
                    toAppendTo.insert(i2 + 1, 'f');
                    continue block8;
                }
                case '\n': {
                    toAppendTo.setCharAt(i2, '\\');
                    toAppendTo.insert(i2 + 1, 'n');
                    continue block8;
                }
                case '\r': {
                    toAppendTo.setCharAt(i2, '\\');
                    toAppendTo.insert(i2 + 1, 'r');
                    continue block8;
                }
                case '\"': 
                case '\\': {
                    toAppendTo.insert(i2, '\\');
                    continue block8;
                }
                default: {
                    if (!Character.isISOControl(c)) continue block8;
                    toAppendTo.setCharAt(i2, '\\');
                    toAppendTo.insert(i2 + 1, "u0000");
                    toAppendTo.setCharAt(i2 + 4, Chars.getUpperCaseHex((c & 0xF0) >> 4));
                    toAppendTo.setCharAt(i2 + 5, Chars.getUpperCaseHex(c & 0xF));
                }
            }
        }
    }

    public static void escapeXml(StringBuilder toAppendTo, int start2) {
        block7: for (int i2 = toAppendTo.length() - 1; i2 >= start2; --i2) {
            char c = toAppendTo.charAt(i2);
            switch (c) {
                case '&': {
                    toAppendTo.setCharAt(i2, '&');
                    toAppendTo.insert(i2 + 1, "amp;");
                    continue block7;
                }
                case '<': {
                    toAppendTo.setCharAt(i2, '&');
                    toAppendTo.insert(i2 + 1, "lt;");
                    continue block7;
                }
                case '>': {
                    toAppendTo.setCharAt(i2, '&');
                    toAppendTo.insert(i2 + 1, "gt;");
                    continue block7;
                }
                case '\"': {
                    toAppendTo.setCharAt(i2, '&');
                    toAppendTo.insert(i2 + 1, "quot;");
                    continue block7;
                }
                case '\'': {
                    toAppendTo.setCharAt(i2, '&');
                    toAppendTo.insert(i2 + 1, "apos;");
                }
            }
        }
    }
}

