/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.MetricsNaming;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.Labels;
import io.vertx.micrometer.impl.meters.Counters;
import io.vertx.micrometer.impl.meters.Summaries;
import java.util.concurrent.ConcurrentMap;

class VertxDatagramSocketMetrics
extends AbstractMetrics
implements DatagramSocketMetrics {
    private final Summaries bytesReceived;
    private final Summaries bytesSent;
    private final Counters errorCount;
    private volatile String localAddress;

    VertxDatagramSocketMetrics(MeterRegistry registry, MetricsNaming names, ConcurrentMap<Meter.Id, Object> gaugesTable) {
        super(registry, MetricsDomain.DATAGRAM_SOCKET, gaugesTable);
        this.bytesReceived = this.summaries(names.getDatagramBytesRead(), "Total number of datagram bytes received", Label.LOCAL);
        this.bytesSent = this.summaries(names.getDatagramBytesWritten(), "Total number of datagram bytes sent", new Label[0]);
        this.errorCount = this.counters(names.getDatagramErrorCount(), "Total number of datagram errors", Label.CLASS_NAME);
    }

    @Override
    public void listening(String localName, SocketAddress localAddress) {
        this.localAddress = Labels.address(localAddress, localName);
    }

    @Override
    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        if (this.localAddress != null) {
            this.bytesReceived.get(this.localAddress).record(numberOfBytes);
        }
    }

    @Override
    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.bytesSent.get(new String[0]).record(numberOfBytes);
    }

    @Override
    public void exceptionOccurred(Void socketMetric, SocketAddress remoteAddress, Throwable t) {
        this.errorCount.get(t.getClass().getSimpleName()).increment();
    }

    @Override
    public void close() {
    }
}

