/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl.cache;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.core.shareddata.SharedData;
import io.vertx.ext.web.client.impl.cache.CacheKey;
import io.vertx.ext.web.client.impl.cache.CachedHttpResponse;
import io.vertx.ext.web.client.spi.CacheStore;

public class SharedDataCacheStore
implements CacheStore {
    private static final String ASYNC_MAP_NAME = "HttpCacheStore";
    private final SharedData sharedData;

    public SharedDataCacheStore(Vertx vertx) {
        this.sharedData = vertx.sharedData();
    }

    @Override
    public Future<CachedHttpResponse> get(CacheKey key) {
        return this.asyncMap().compose(map2 -> map2.get(key));
    }

    @Override
    public Future<CachedHttpResponse> set(CacheKey key, CachedHttpResponse response) {
        return this.asyncMap().compose(map2 -> map2.put(key, response)).map(response);
    }

    @Override
    public Future<Void> delete(CacheKey key) {
        return this.asyncMap().compose(map2 -> map2.remove(key)).mapEmpty();
    }

    @Override
    public Future<Void> flush() {
        return this.asyncMap().compose(AsyncMap::clear);
    }

    private Future<AsyncMap<CacheKey, CachedHttpResponse>> asyncMap() {
        return this.sharedData.getAsyncMap(ASYNC_MAP_NAME);
    }
}

