/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.json.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.BufferRecycler;
import io.netty.buffer.ByteBufInputStream;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.EncodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.core.json.jackson.HybridJacksonPool;
import io.vertx.core.json.jackson.JacksonFactory;
import io.vertx.core.spi.json.JsonCodec;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class JacksonCodec
implements JsonCodec {
    private static final Logger log = LoggerFactory.getLogger(JacksonCodec.class);
    private static final String JACKSON_DEFAULT_READ_MAX_NESTING_DEPTH = "vertx.jackson.defaultReadMaxNestingDepth";
    private static final String JACKSON_DEFAULT_READ_MAX_DOC_LEN = "vertx.jackson.defaultReadMaxDocumentLength";
    private static final String JACKSON_DEFAULT_READ_MAX_NUM_LEN = "vertx.jackson.defaultReadMaxNumberLength";
    private static final String JACKSON_DEFAULT_READ_MAX_STRING_LEN = "vertx.jackson.defaultReadMaxStringLength";
    private static final String JACKSON_DEFAULT_READ_MAX_NAME_LEN = "vertx.jackson.defaultReadMaxNameLength";
    static final boolean releaseToPool;
    static final JsonFactory factory;

    private static void setLong(String propertyName, BiConsumer<StreamReadConstraints.Builder, Long> setter, StreamReadConstraints.Builder builder) throws NumberFormatException {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            try {
                long longValue = Long.parseLong(propertyValue);
                setter.accept(builder, longValue);
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid " + propertyName + " system property value");
            }
        }
    }

    private static void setInt(String propertyName, BiConsumer<StreamReadConstraints.Builder, Integer> setter, StreamReadConstraints.Builder builder) throws NumberFormatException {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            try {
                int intValue = Integer.parseInt(propertyValue);
                setter.accept(builder, intValue);
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid " + propertyName + " system property value");
            }
        }
    }

    @Override
    public <T> T fromString(String json, Class<T> clazz) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(json), clazz);
    }

    public <T> T fromString(String str, TypeReference<T> typeRef) throws DecodeException {
        return this.fromString(str, JacksonCodec.classTypeOf(typeRef));
    }

    @Override
    public <T> T fromBuffer(Buffer json, Class<T> clazz) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(json), clazz);
    }

    public <T> T fromBuffer(Buffer buf, TypeReference<T> typeRef) throws DecodeException {
        return this.fromBuffer(buf, JacksonCodec.classTypeOf(typeRef));
    }

    @Override
    public <T> T fromValue(Object json, Class<T> toValueType) {
        throw new DecodeException("Mapping " + toValueType.getName() + "  is not available without Jackson Databind on the classpath");
    }

    public <T> T fromValue(Object json, TypeReference<T> type) {
        throw new DecodeException("Mapping " + type.getType().getTypeName() + " is not available without Jackson Databind on the classpath");
    }

    /*
     * Exception decompiling
     */
    @Override
    public String toString(Object object, boolean pretty) throws EncodeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Buffer toBuffer(Object object, boolean pretty) throws EncodeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void releaseToPool(BufferRecycler br) {
        br.releaseToPool();
    }

    public static JsonParser createParser(String str) {
        try {
            return factory.createParser(str);
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    public static JsonParser createParser(Buffer buf) {
        try {
            return factory.createParser(new ByteBufInputStream(buf.getByteBuf()));
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    private static JsonGenerator createGenerator(Writer out, boolean pretty) {
        try {
            JsonGenerator generator = factory.createGenerator(out);
            if (pretty) {
                generator.useDefaultPrettyPrinter();
            }
            return generator;
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    private static JsonGenerator createGenerator(OutputStream out, boolean pretty) {
        try {
            JsonGenerator generator = factory.createGenerator(out);
            if (pretty) {
                generator.useDefaultPrettyPrinter();
            }
            return generator;
        }
        catch (IOException e) {
            throw new DecodeException("Failed to decode:" + e.getMessage(), e);
        }
    }

    public Object fromString(String str) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(str), Object.class);
    }

    public Object fromBuffer(Buffer buf) throws DecodeException {
        return JacksonCodec.fromParser(JacksonCodec.createParser(buf), Object.class);
    }

    public static <T> T fromParser(JsonParser parser2, Class<T> type) throws DecodeException {
        JsonToken remaining;
        Object res;
        try {
            parser2.nextToken();
            res = JacksonCodec.parseAny(parser2);
            remaining = parser2.nextToken();
        }
        catch (IOException e) {
            throw new DecodeException(e.getMessage(), e);
        }
        finally {
            JacksonCodec.close(parser2);
        }
        if (remaining != null) {
            throw new DecodeException("Unexpected trailing token");
        }
        return JacksonCodec.cast(res, type);
    }

    private static Object parseAny(JsonParser parser2) throws IOException, DecodeException {
        switch (parser2.getCurrentTokenId()) {
            case 1: {
                return JacksonCodec.parseObject(parser2);
            }
            case 3: {
                return JacksonCodec.parseArray(parser2);
            }
            case 6: {
                return parser2.getText();
            }
            case 7: 
            case 8: {
                return parser2.getNumberValue();
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
        }
        throw new DecodeException("Unexpected token");
    }

    private static Map<String, Object> parseObject(JsonParser parser2) throws IOException {
        String key1 = parser2.nextFieldName();
        if (key1 == null) {
            return new LinkedHashMap<String, Object>(2);
        }
        parser2.nextToken();
        Object value1 = JacksonCodec.parseAny(parser2);
        String key2 = parser2.nextFieldName();
        if (key2 == null) {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>(2);
            obj.put(key1, value1);
            return obj;
        }
        parser2.nextToken();
        Object value2 = JacksonCodec.parseAny(parser2);
        String key = parser2.nextFieldName();
        if (key == null) {
            LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>(2);
            obj.put(key1, value1);
            obj.put(key2, value2);
            return obj;
        }
        LinkedHashMap<String, Object> obj = new LinkedHashMap<String, Object>();
        obj.put(key1, value1);
        obj.put(key2, value2);
        do {
            parser2.nextToken();
            Object value = JacksonCodec.parseAny(parser2);
            obj.put(key, value);
        } while ((key = parser2.nextFieldName()) != null);
        return obj;
    }

    private static List<Object> parseArray(JsonParser parser2) throws IOException {
        ArrayList<Object> array = new ArrayList<Object>();
        while (true) {
            parser2.nextToken();
            int tokenId = parser2.getCurrentTokenId();
            if (tokenId == 5) {
                throw new UnsupportedOperationException();
            }
            if (tokenId == 4) {
                return array;
            }
            Object value = JacksonCodec.parseAny(parser2);
            array.add(value);
        }
    }

    static void close(Closeable parser2) {
        try {
            parser2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void encodeJson(Object json, JsonGenerator generator) throws EncodeException {
        block33: {
            try {
                if (json instanceof JsonObject) {
                    json = ((JsonObject)json).getMap();
                } else if (json instanceof JsonArray) {
                    json = ((JsonArray)json).getList();
                }
                if (json instanceof Map) {
                    generator.writeStartObject();
                    for (Map.Entry e : ((Map)json).entrySet()) {
                        generator.writeFieldName((String)e.getKey());
                        JacksonCodec.encodeJson(e.getValue(), generator);
                    }
                    generator.writeEndObject();
                    break block33;
                }
                if (json instanceof List) {
                    generator.writeStartArray();
                    for (Object item : (List)json) {
                        JacksonCodec.encodeJson(item, generator);
                    }
                    generator.writeEndArray();
                    break block33;
                }
                if (json instanceof String) {
                    generator.writeString((String)json);
                    break block33;
                }
                if (json instanceof Number) {
                    if (json instanceof Short) {
                        generator.writeNumber((Short)json);
                    } else if (json instanceof Integer) {
                        generator.writeNumber((Integer)json);
                    } else if (json instanceof Long) {
                        generator.writeNumber((Long)json);
                    } else if (json instanceof Float) {
                        generator.writeNumber(((Float)json).floatValue());
                    } else if (json instanceof Double) {
                        generator.writeNumber((Double)json);
                    } else if (json instanceof Byte) {
                        generator.writeNumber(((Byte)json).byteValue());
                    } else if (json instanceof BigInteger) {
                        generator.writeNumber((BigInteger)json);
                    } else if (json instanceof BigDecimal) {
                        generator.writeNumber((BigDecimal)json);
                    } else {
                        generator.writeNumber(((Number)json).doubleValue());
                    }
                    break block33;
                }
                if (json instanceof Boolean) {
                    generator.writeBoolean((Boolean)json);
                    break block33;
                }
                if (json instanceof Instant) {
                    generator.writeString(DateTimeFormatter.ISO_INSTANT.format((Instant)json));
                    break block33;
                }
                if (json instanceof byte[]) {
                    generator.writeString(JsonUtil.BASE64_ENCODER.encodeToString((byte[])json));
                    break block33;
                }
                if (json instanceof Buffer) {
                    generator.writeString(JsonUtil.BASE64_ENCODER.encodeToString(((Buffer)json).getBytes()));
                    break block33;
                }
                if (json instanceof Enum) {
                    generator.writeString(((Enum)json).name());
                    break block33;
                }
                if (json == null) {
                    generator.writeNull();
                    break block33;
                }
                throw new EncodeException("Mapping " + json.getClass().getName() + "  is not available without Jackson Databind on the classpath");
            }
            catch (IOException e) {
                throw new EncodeException(e.getMessage(), e);
            }
        }
    }

    private static <T> Class<T> classTypeOf(TypeReference<T> typeRef) {
        Type type = typeRef.getType();
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        throw new DecodeException();
    }

    private static <T> T cast(Object o, Class<T> clazz) {
        if (o instanceof Map) {
            if (!clazz.isAssignableFrom(Map.class)) {
                throw new DecodeException("Failed to decode");
            }
            if (clazz == Object.class) {
                o = new JsonObject((Map)o);
            }
            return clazz.cast(o);
        }
        if (o instanceof List) {
            if (!clazz.isAssignableFrom(List.class)) {
                throw new DecodeException("Failed to decode");
            }
            if (clazz == Object.class) {
                o = new JsonArray((List)o);
            }
            return clazz.cast(o);
        }
        if (o instanceof String) {
            String str = (String)o;
            if (clazz.isEnum()) {
                o = Enum.valueOf(clazz, str);
            } else if (clazz == byte[].class) {
                o = JsonUtil.BASE64_DECODER.decode(str);
            } else if (clazz == Buffer.class) {
                o = Buffer.buffer(JsonUtil.BASE64_DECODER.decode(str));
            } else if (clazz == Instant.class) {
                o = Instant.from(DateTimeFormatter.ISO_INSTANT.parse(str));
            } else if (!clazz.isAssignableFrom(String.class)) {
                throw new DecodeException("Failed to decode");
            }
            return clazz.cast(o);
        }
        if (o instanceof Boolean) {
            if (!clazz.isAssignableFrom(Boolean.class)) {
                throw new DecodeException("Failed to decode");
            }
            return clazz.cast(o);
        }
        if (o == null) {
            return null;
        }
        Number number = (Number)o;
        if (clazz == Integer.class) {
            o = number.intValue();
        } else if (clazz == Long.class) {
            o = number.longValue();
        } else if (clazz == Float.class) {
            o = Float.valueOf(number.floatValue());
        } else if (clazz == Double.class) {
            o = number.doubleValue();
        } else if (clazz == Byte.class) {
            o = number.byteValue();
        } else if (clazz == Short.class) {
            o = number.shortValue();
        } else if (clazz != Object.class && !clazz.isAssignableFrom(Number.class)) {
            throw new DecodeException("Failed to decode");
        }
        return clazz.cast(o);
    }

    public static <T> T decodeValue(String str, TypeReference<T> type) throws DecodeException {
        return JacksonFactory.CODEC.fromString(str, type);
    }

    public static <T> T decodeValue(Buffer buf, TypeReference<T> type) throws DecodeException {
        return JacksonFactory.CODEC.fromBuffer(buf, type);
    }

    static {
        boolean releaseToPoolValue = false;
        TSFBuilder<?, ?> builder = JsonFactory.builder();
        StreamReadConstraints.Builder readConstraintsBuilder = StreamReadConstraints.builder();
        JacksonCodec.setInt(JACKSON_DEFAULT_READ_MAX_NESTING_DEPTH, StreamReadConstraints.Builder::maxNestingDepth, readConstraintsBuilder);
        try {
            JacksonCodec.setLong(JACKSON_DEFAULT_READ_MAX_DOC_LEN, StreamReadConstraints.Builder::maxDocumentLength, readConstraintsBuilder);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JacksonCodec.setInt(JACKSON_DEFAULT_READ_MAX_NUM_LEN, StreamReadConstraints.Builder::maxNumberLength, readConstraintsBuilder);
        JacksonCodec.setInt(JACKSON_DEFAULT_READ_MAX_STRING_LEN, StreamReadConstraints.Builder::maxStringLength, readConstraintsBuilder);
        try {
            JacksonCodec.setInt(JACKSON_DEFAULT_READ_MAX_NAME_LEN, StreamReadConstraints.Builder::maxNameLength, readConstraintsBuilder);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        builder.streamReadConstraints(readConstraintsBuilder.build());
        try {
            Method[] methods;
            for (Method method : methods = builder.getClass().getMethods()) {
                if (!method.getName().equals("recyclerPool")) continue;
                method.invoke(builder, JacksonPoolHolder.pool);
                releaseToPoolValue = true;
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        factory = builder.build();
        releaseToPool = releaseToPoolValue;
        factory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }

    private static final class JacksonPoolHolder {
        private static final Object pool = HybridJacksonPool.getInstance();

        private JacksonPoolHolder() {
        }
    }
}

