/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.micrometer.transform;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Metric;
import com.newrelic.telemetry.metrics.Summary;
import com.newrelic.telemetry.micrometer.transform.AttributesMaker;
import com.newrelic.telemetry.micrometer.util.TimeTracker;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Meter;
import java.util.Collection;
import java.util.Collections;

public class FunctionTimerTransformer {
    private final TimeTracker timeTracker;
    private final AttributesMaker attributesMaker = new AttributesMaker();

    public FunctionTimerTransformer(TimeTracker timeTracker) {
        this.timeTracker = timeTracker;
    }

    public Collection<Metric> transform(FunctionTimer functionTimer) {
        Meter.Id id = functionTimer.getId();
        long now = this.timeTracker.getCurrentTime();
        Attributes attributes = this.attributesMaker.make(id, "functionTimer");
        Summary summary = new Summary(id.getName(), (int)functionTimer.count(), functionTimer.totalTime(functionTimer.baseTimeUnit()), Double.NaN, Double.NaN, this.timeTracker.getPreviousTime(), now, attributes);
        return Collections.singleton(summary);
    }
}

