/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.gridfs;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.MongoClients;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import com.mongodb.reactivestreams.client.gridfs.GridFSBucket;
import com.mongodb.reactivestreams.client.gridfs.GridFSDownloadPublisher;
import com.mongodb.reactivestreams.client.gridfs.GridFSFindPublisher;
import com.mongodb.reactivestreams.client.gridfs.GridFSUploadPublisher;
import com.mongodb.reactivestreams.client.internal.gridfs.GridFSPublisherCreator;
import java.nio.ByteBuffer;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.reactivestreams.Publisher;

public final class GridFSBucketImpl
implements GridFSBucket {
    private static final int DEFAULT_CHUNKSIZE_BYTES = 261120;
    private final String bucketName;
    private final int chunkSizeBytes;
    private final MongoCollection<GridFSFile> filesCollection;
    private final MongoCollection<Document> chunksCollection;

    public GridFSBucketImpl(MongoDatabase database) {
        this(database, "fs");
    }

    public GridFSBucketImpl(MongoDatabase database, String bucketName) {
        this(Assertions.notNull("bucketName", bucketName), 261120, GridFSBucketImpl.getFilesCollection(Assertions.notNull("database", database), bucketName), GridFSBucketImpl.getChunksCollection(database, bucketName));
    }

    GridFSBucketImpl(String bucketName, int chunkSizeBytes, MongoCollection<GridFSFile> filesCollection, MongoCollection<Document> chunksCollection) {
        this.bucketName = Assertions.notNull("bucketName", bucketName);
        this.chunkSizeBytes = chunkSizeBytes;
        this.filesCollection = Assertions.notNull("filesCollection", filesCollection);
        this.chunksCollection = Assertions.notNull("chunksCollection", chunksCollection);
    }

    private static MongoCollection<GridFSFile> getFilesCollection(MongoDatabase database, String bucketName) {
        return database.getCollection(bucketName + ".files", GridFSFile.class).withCodecRegistry(CodecRegistries.fromRegistries(database.getCodecRegistry(), MongoClients.getDefaultCodecRegistry()));
    }

    private static MongoCollection<Document> getChunksCollection(MongoDatabase database, String bucketName) {
        return database.getCollection(bucketName + ".chunks").withCodecRegistry(MongoClients.getDefaultCodecRegistry());
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public int getChunkSizeBytes() {
        return this.chunkSizeBytes;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.filesCollection.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.filesCollection.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.filesCollection.getReadConcern();
    }

    @Override
    public GridFSBucket withChunkSizeBytes(int chunkSizeBytes) {
        return new GridFSBucketImpl(this.bucketName, chunkSizeBytes, this.filesCollection, this.chunksCollection);
    }

    @Override
    public GridFSBucket withReadPreference(ReadPreference readPreference) {
        Assertions.notNull("readPreference", readPreference);
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadPreference(readPreference), this.chunksCollection.withReadPreference(readPreference));
    }

    @Override
    public GridFSBucket withWriteConcern(WriteConcern writeConcern) {
        Assertions.notNull("writeConcern", writeConcern);
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withWriteConcern(writeConcern), this.chunksCollection.withWriteConcern(writeConcern));
    }

    @Override
    public GridFSBucket withReadConcern(ReadConcern readConcern) {
        Assertions.notNull("readConcern", readConcern);
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadConcern(readConcern), this.chunksCollection.withReadConcern(readConcern));
    }

    @Override
    public GridFSUploadPublisher<ObjectId> uploadFromPublisher(String filename, Publisher<ByteBuffer> source2) {
        return this.uploadFromPublisher(filename, source2, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadPublisher<ObjectId> uploadFromPublisher(String filename, Publisher<ByteBuffer> source2, GridFSUploadOptions options) {
        return GridFSPublisherCreator.createGridFSUploadPublisher(this.chunkSizeBytes, this.filesCollection, this.chunksCollection, null, new BsonObjectId(), filename, options, source2).withObjectId();
    }

    @Override
    public GridFSUploadPublisher<Void> uploadFromPublisher(BsonValue id, String filename, Publisher<ByteBuffer> source2) {
        return this.uploadFromPublisher(id, filename, source2, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadPublisher<Void> uploadFromPublisher(BsonValue id, String filename, Publisher<ByteBuffer> source2, GridFSUploadOptions options) {
        return GridFSPublisherCreator.createGridFSUploadPublisher(this.chunkSizeBytes, this.filesCollection, this.chunksCollection, null, id, filename, options, source2);
    }

    @Override
    public GridFSUploadPublisher<ObjectId> uploadFromPublisher(ClientSession clientSession, String filename, Publisher<ByteBuffer> source2) {
        return this.uploadFromPublisher(clientSession, filename, source2, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadPublisher<ObjectId> uploadFromPublisher(ClientSession clientSession, String filename, Publisher<ByteBuffer> source2, GridFSUploadOptions options) {
        return GridFSPublisherCreator.createGridFSUploadPublisher(this.chunkSizeBytes, this.filesCollection, this.chunksCollection, Assertions.notNull("clientSession", clientSession), new BsonObjectId(), filename, options, source2).withObjectId();
    }

    @Override
    public GridFSUploadPublisher<Void> uploadFromPublisher(ClientSession clientSession, BsonValue id, String filename, Publisher<ByteBuffer> source2) {
        return this.uploadFromPublisher(clientSession, id, filename, source2, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadPublisher<Void> uploadFromPublisher(ClientSession clientSession, BsonValue id, String filename, Publisher<ByteBuffer> source2, GridFSUploadOptions options) {
        return GridFSPublisherCreator.createGridFSUploadPublisher(this.chunkSizeBytes, this.filesCollection, this.chunksCollection, Assertions.notNull("clientSession", clientSession), new BsonObjectId(), filename, options, source2);
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ObjectId id) {
        return this.downloadToPublisher(new BsonObjectId(id));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(BsonValue id) {
        return GridFSPublisherCreator.createGridFSDownloadPublisher(this.chunksCollection, null, GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, null, new BsonDocument("_id", id)));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(String filename) {
        return this.downloadToPublisher(filename, new GridFSDownloadOptions());
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(String filename, GridFSDownloadOptions options) {
        return GridFSPublisherCreator.createGridFSDownloadPublisher(this.chunksCollection, null, GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, null, filename, options));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ClientSession clientSession, ObjectId id) {
        return this.downloadToPublisher(clientSession, new BsonObjectId(id));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ClientSession clientSession, BsonValue id) {
        return GridFSPublisherCreator.createGridFSDownloadPublisher(this.chunksCollection, Assertions.notNull("clientSession", clientSession), GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, clientSession, new BsonDocument("_id", id)));
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ClientSession clientSession, String filename) {
        return this.downloadToPublisher(clientSession, filename, new GridFSDownloadOptions());
    }

    @Override
    public GridFSDownloadPublisher downloadToPublisher(ClientSession clientSession, String filename, GridFSDownloadOptions options) {
        return GridFSPublisherCreator.createGridFSDownloadPublisher(this.chunksCollection, Assertions.notNull("clientSession", clientSession), GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, clientSession, filename, options));
    }

    @Override
    public GridFSFindPublisher find() {
        return GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, null, null);
    }

    @Override
    public GridFSFindPublisher find(Bson filter2) {
        return GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, null, Assertions.notNull("filter", filter2));
    }

    @Override
    public GridFSFindPublisher find(ClientSession clientSession) {
        return GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, Assertions.notNull("clientSession", clientSession), null);
    }

    @Override
    public GridFSFindPublisher find(ClientSession clientSession, Bson filter2) {
        return GridFSPublisherCreator.createGridFSFindPublisher(this.filesCollection, Assertions.notNull("clientSession", clientSession), Assertions.notNull("filter", filter2));
    }

    @Override
    public Publisher<Void> delete(ObjectId id) {
        return this.delete(new BsonObjectId(id));
    }

    @Override
    public Publisher<Void> delete(BsonValue id) {
        return GridFSPublisherCreator.createDeletePublisher(this.filesCollection, this.chunksCollection, null, id);
    }

    @Override
    public Publisher<Void> delete(ClientSession clientSession, ObjectId id) {
        return this.delete(clientSession, new BsonObjectId(id));
    }

    @Override
    public Publisher<Void> delete(ClientSession clientSession, BsonValue id) {
        return GridFSPublisherCreator.createDeletePublisher(this.filesCollection, this.chunksCollection, Assertions.notNull("clientSession", clientSession), id);
    }

    @Override
    public Publisher<Void> rename(ObjectId id, String newFilename) {
        return this.rename(new BsonObjectId(id), newFilename);
    }

    @Override
    public Publisher<Void> rename(BsonValue id, String newFilename) {
        return GridFSPublisherCreator.createRenamePublisher(this.filesCollection, null, id, newFilename);
    }

    @Override
    public Publisher<Void> rename(ClientSession clientSession, ObjectId id, String newFilename) {
        return this.rename(clientSession, new BsonObjectId(id), newFilename);
    }

    @Override
    public Publisher<Void> rename(ClientSession clientSession, BsonValue id, String newFilename) {
        return GridFSPublisherCreator.createRenamePublisher(this.filesCollection, Assertions.notNull("clientSession", clientSession), id, newFilename);
    }

    @Override
    public Publisher<Void> drop() {
        return GridFSPublisherCreator.createDropPublisher(this.filesCollection, this.chunksCollection, null);
    }

    @Override
    public Publisher<Void> drop(ClientSession clientSession) {
        return GridFSPublisherCreator.createDropPublisher(this.filesCollection, this.chunksCollection, Assertions.notNull("clientSession", clientSession));
    }
}

