/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.sdp.fields.parser;

import java.util.regex.Pattern;
import org.restcomm.media.sdp.SdpException;
import org.restcomm.media.sdp.SdpParser;
import org.restcomm.media.sdp.fields.OriginField;

public class OriginFieldParser
implements SdpParser<OriginField> {
    private static final String REGEX = "^o=\\S+\\s\\d+\\s\\d+\\s\\w+\\s\\w+\\s[0-9\\.]+";
    private static final Pattern PATTERN = Pattern.compile("^o=\\S+\\s\\d+\\s\\d+\\s\\w+\\s\\w+\\s[0-9\\.]+");

    @Override
    public boolean canParse(String sdp) {
        if (sdp == null || sdp.isEmpty()) {
            return false;
        }
        return PATTERN.matcher(sdp.trim()).matches();
    }

    @Override
    public OriginField parse(String sdp) throws SdpException {
        try {
            String[] values2 = sdp.trim().substring(2).split(" ");
            String username = values2[0];
            String sessionId2 = values2[1];
            String sessionVersion = values2[2];
            String netType = values2[3];
            String addressType = values2[4];
            String address = values2[5];
            return new OriginField(username, sessionId2, sessionVersion, netType, addressType, address);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }

    @Override
    public void parse(OriginField field, String sdp) throws SdpException {
        try {
            String[] values2 = sdp.trim().substring(2).split(" ");
            field.setUsername(values2[0]);
            field.setSessionId(values2[1]);
            field.setSessionVersion(values2[2]);
            field.setNetType(values2[3]);
            field.setAddressType(values2[4]);
            field.setAddress(values2[5]);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }
}

