/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.scheduler;

import org.restcomm.media.concurrent.ConcurrentCyclicFIFO;
import org.restcomm.media.scheduler.Task;

public class OrderedTaskQueue {
    private ConcurrentCyclicFIFO<Task>[] taskList = new ConcurrentCyclicFIFO[2];
    private Integer activeIndex = 0;

    public OrderedTaskQueue() {
        this.taskList[0] = new ConcurrentCyclicFIFO();
        this.taskList[1] = new ConcurrentCyclicFIFO();
    }

    public void accept(Task task) {
        if ((this.activeIndex + 1) % 2 == 0) {
            if (!task.isInQueue0().booleanValue()) {
                this.taskList[0].offer(task);
                task.storedInQueue0();
            }
        } else if (!task.isInQueue1().booleanValue()) {
            this.taskList[1].offer(task);
            task.storedInQueue1();
        }
    }

    public Task poll() {
        Task result2 = null;
        if (this.activeIndex == 0) {
            result2 = this.taskList[0].poll();
            if (result2 != null) {
                result2.removeFromQueue0();
            }
        } else {
            result2 = this.taskList[1].poll();
            if (result2 != null) {
                result2.removeFromQueue1();
            }
        }
        return result2;
    }

    public void changePool() {
        this.activeIndex = (this.activeIndex + 1) % 2;
    }

    public void clear() {
        this.taskList[0].clear();
        this.taskList[1].clear();
    }

    public int size() {
        return this.taskList[this.activeIndex].size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Queue[");
        int len = Math.min(30, this.taskList[this.activeIndex].size());
        for (int i2 = 0; i2 < len - 1; ++i2) {
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

