/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentCyclicFIFO<E> {
    private final AtomicInteger count = new AtomicInteger(0);
    private transient Node<E> head;
    private transient Node<E> last;
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();
    private final ReentrantLock putLock = new ReentrantLock();

    private void signalNotEmpty() {
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            takeLock.unlock();
        }
    }

    private void insert(Node<E> x) {
        this.last.next = x;
        this.last = this.last.next;
    }

    private Node<E> extract() {
        Node<E> current = this.head;
        this.head = this.head.next;
        current.item = this.head.item;
        this.head.item = null;
        return current;
    }

    public ConcurrentCyclicFIFO() {
        this.head = new Node<Object>(null);
        this.last = this.head;
    }

    public int size() {
        return this.count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        AtomicInteger count2 = this.count;
        boolean shouldSignal = false;
        ReentrantLock putLock = this.putLock;
        putLock.lock();
        try {
            this.insert(new Node<E>(e));
            shouldSignal = count2.getAndIncrement() == 0;
        }
        finally {
            putLock.unlock();
        }
        if (shouldSignal) {
            this.signalNotEmpty();
        }
        return !shouldSignal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E take() throws InterruptedException {
        Node<E> x;
        AtomicInteger count2 = this.count;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lockInterruptibly();
        try {
            try {
                while (count2.get() == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            x = this.extract();
            if (count2.getAndDecrement() > 1) {
                this.notEmpty.signal();
            }
        }
        finally {
            takeLock.unlock();
        }
        Object result2 = x.item;
        x.item = null;
        x.next = null;
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E poll() {
        AtomicInteger count2 = this.count;
        if (count2.get() == 0) {
            return null;
        }
        Node<E> x = null;
        ReentrantLock takeLock = this.takeLock;
        takeLock.lock();
        try {
            if (count2.get() > 0) {
                x = this.extract();
                if (count2.getAndDecrement() > 1) {
                    this.notEmpty.signal();
                }
            }
        }
        finally {
            takeLock.unlock();
        }
        if (x != null) {
            Object result2 = x.item;
            x.item = null;
            x.next = null;
            return result2;
        }
        return null;
    }

    public void clear() {
        this.putLock.lock();
        this.takeLock.lock();
        try {
            this.head.next = null;
            assert (this.head.item == null);
            this.last = this.head;
            this.count.set(0);
        }
        finally {
            this.takeLock.unlock();
            this.putLock.unlock();
        }
    }

    static class Node<E> {
        volatile E item;
        Node<E> next;

        Node(E x) {
            this.item = x;
        }
    }
}

