/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.m12n;

import groovy.lang.GroovyRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyMethodsSupport;
import org.codehaus.groovy.runtime.m12n.ExtensionModule;
import org.codehaus.groovy.runtime.m12n.StandardPropertiesModuleFactory;
import org.codehaus.groovy.util.URLStreams;

public class ExtensionModuleScanner {
    public static final String LEGACY_MODULE_META_INF_FILE = "META-INF/services/org.codehaus.groovy.runtime.ExtensionModule";
    public static final String MODULE_META_INF_FILE = "META-INF/groovy/org.codehaus.groovy.runtime.ExtensionModule";
    private final ExtensionModuleListener listener;
    private final ClassLoader classLoader;

    public ExtensionModuleScanner(ExtensionModuleListener listener, ClassLoader loader) {
        this.listener = listener;
        this.classLoader = loader;
    }

    public void scanClasspathModules() {
        this.scanClasspathModulesFrom(MODULE_META_INF_FILE);
        this.scanClasspathModulesFrom(LEGACY_MODULE_META_INF_FILE);
    }

    private void scanClasspathModulesFrom(String moduleMetaInfFile) {
        try {
            for (URL url : DefaultGroovyMethods.toSet(this.classLoader.getResources(moduleMetaInfFile))) {
                this.scanExtensionModuleFromMetaInf(url);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void scanExtensionModuleFromMetaInf(URL metadata) {
        Properties properties = new Properties();
        InputStream inStream = null;
        try {
            inStream = URLStreams.openUncachedStream(metadata);
            properties.load(inStream);
        }
        catch (IOException e) {
            throw new GroovyRuntimeException("Unable to load module META-INF descriptor", e);
        }
        finally {
            DefaultGroovyMethodsSupport.closeQuietly(inStream);
        }
        this.scanExtensionModuleFromProperties(properties);
    }

    public void scanExtensionModuleFromProperties(Properties properties) {
        StandardPropertiesModuleFactory factory2 = new StandardPropertiesModuleFactory();
        ExtensionModule module = factory2.newModule(properties, this.classLoader);
        this.listener.onModule(module);
    }

    public static interface ExtensionModuleListener {
        public void onModule(ExtensionModule var1);
    }
}

