/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.record;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.Parameterizable;
import org.bson.codecs.RepresentationConfigurable;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonDiscriminator;
import org.bson.codecs.pojo.annotations.BsonExtraElements;
import org.bson.codecs.pojo.annotations.BsonIgnore;
import org.bson.codecs.record.annotations.BsonId;
import org.bson.codecs.record.annotations.BsonProperty;
import org.bson.codecs.record.annotations.BsonRepresentation;
import org.bson.diagnostics.Logger;
import org.bson.diagnostics.Loggers;

final class RecordCodec<T extends Record>
implements Codec<T>,
Parameterizable {
    private static final Logger LOGGER = Loggers.getLogger("RecordCodec");
    private final Class<T> clazz;
    private final boolean requiresParameterization;
    private final Constructor<?> canonicalConstructor;
    private final List<ComponentModel> componentModels;
    private final ComponentModel componentModelForId;
    private final Map<String, ComponentModel> fieldNameToComponentModel;

    RecordCodec(Class<T> clazz, CodecRegistry codecRegistry) {
        this.clazz = Assertions.notNull("class", clazz);
        if (clazz.getTypeParameters().length > 0) {
            this.requiresParameterization = true;
            this.canonicalConstructor = null;
            this.componentModels = null;
            this.fieldNameToComponentModel = null;
            this.componentModelForId = null;
        } else {
            this.requiresParameterization = false;
            this.canonicalConstructor = Assertions.notNull("canonicalConstructor", RecordCodec.getCanonicalConstructor(clazz));
            this.componentModels = RecordCodec.getComponentModels(clazz, codecRegistry, List.of());
            this.fieldNameToComponentModel = this.componentModels.stream().collect(Collectors.toMap(ComponentModel::getFieldName, Function.identity()));
            this.componentModelForId = RecordCodec.getComponentModelForId(clazz, this.componentModels);
        }
    }

    RecordCodec(Class<T> clazz, CodecRegistry codecRegistry, List<Type> types) {
        if (types.size() != clazz.getTypeParameters().length || types.isEmpty()) {
            throw new CodecConfigurationException("Unexpected number of type parameters for record class " + clazz);
        }
        this.clazz = Assertions.notNull("class", clazz);
        this.requiresParameterization = false;
        this.canonicalConstructor = Assertions.notNull("canonicalConstructor", RecordCodec.getCanonicalConstructor(clazz));
        this.componentModels = RecordCodec.getComponentModels(clazz, codecRegistry, types);
        this.fieldNameToComponentModel = this.componentModels.stream().collect(Collectors.toMap(ComponentModel::getFieldName, Function.identity()));
        this.componentModelForId = RecordCodec.getComponentModelForId(clazz, this.componentModels);
    }

    @Override
    public Codec<?> parameterize(CodecRegistry codecRegistry, List<Type> types) {
        return new RecordCodec<T>(this.clazz, codecRegistry, types);
    }

    @Override
    public T decode(BsonReader reader, DecoderContext decoderContext) {
        if (this.requiresParameterization) {
            throw new CodecConfigurationException("Can not decode to a record with type parameters that has not been parameterized");
        }
        reader.readStartDocument();
        Object[] constructorArguments = new Object[this.componentModels.size()];
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            ComponentModel componentModel = this.fieldNameToComponentModel.get(fieldName);
            if (componentModel == null) {
                reader.skipValue();
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace(String.format("Found property not present in the ClassModel: %s", fieldName));
                continue;
            }
            constructorArguments[componentModel.index] = decoderContext.decodeWithChildContext(componentModel.codec, reader);
        }
        reader.readEndDocument();
        try {
            return (T)((Record)this.canonicalConstructor.newInstance(constructorArguments));
        }
        catch (ReflectiveOperationException e) {
            throw new CodecConfigurationException(String.format("Unable to invoke canonical constructor of record class %s", this.clazz.getName()), e);
        }
    }

    @Override
    public void encode(BsonWriter writer, T record, EncoderContext encoderContext) {
        if (this.requiresParameterization) {
            throw new CodecConfigurationException("Can not decode to a record with type parameters that has not been parameterized");
        }
        writer.writeStartDocument();
        if (this.componentModelForId != null) {
            this.writeComponent(writer, record, this.componentModelForId);
        }
        for (ComponentModel componentModel : this.componentModels) {
            if (componentModel == this.componentModelForId) continue;
            this.writeComponent(writer, record, componentModel);
        }
        writer.writeEndDocument();
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.clazz;
    }

    private void writeComponent(BsonWriter writer, T record, ComponentModel componentModel) {
        try {
            Object componentValue = componentModel.getValue((Record)record);
            if (componentValue != null) {
                writer.writeName(componentModel.getFieldName());
                componentModel.codec.encode(writer, componentValue, EncoderContext.builder().build());
            }
        }
        catch (ReflectiveOperationException e) {
            throw new CodecConfigurationException(String.format("Unable to access value of component %s for record %s", componentModel.getComponentName(), this.clazz.getName()), e);
        }
    }

    private static <T> List<ComponentModel> getComponentModels(Class<T> clazz, CodecRegistry codecRegistry, List<Type> typeParameters) {
        RecordComponent[] recordComponents = clazz.getRecordComponents();
        ArrayList<ComponentModel> componentModels = new ArrayList<ComponentModel>(recordComponents.length);
        for (int i2 = 0; i2 < recordComponents.length; ++i2) {
            componentModels.add(new ComponentModel(typeParameters, recordComponents[i2], codecRegistry, i2));
        }
        return componentModels;
    }

    @Nullable
    private static <T> ComponentModel getComponentModelForId(Class<T> clazz, List<ComponentModel> componentModels) {
        List<ComponentModel> componentModelsForId = componentModels.stream().filter(componentModel -> componentModel.getFieldName().equals("_id")).toList();
        if (componentModelsForId.size() > 1) {
            throw new CodecConfigurationException(String.format("Record %s has more than one _id component", clazz.getName()));
        }
        return componentModelsForId.stream().findFirst().orElse(null);
    }

    private static <T> Constructor<?> getCanonicalConstructor(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor((Class[])Arrays.stream(clazz.getRecordComponents()).map(RecordComponent::getType).toArray(Class[]::new));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)String.format("Could not find canonical constructor for record %s", clazz.getName()));
        }
    }

    private static Class<?> toWrapper(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        return clazz;
    }

    private static final class ComponentModel {
        private final RecordComponent component;
        private final Codec<?> codec;
        private final int index;
        private final String fieldName;

        private ComponentModel(List<Type> typeParameters, RecordComponent component2, CodecRegistry codecRegistry, int index) {
            ComponentModel.validateAnnotations(component2, index);
            this.component = component2;
            this.codec = ComponentModel.computeCodec(typeParameters, component2, codecRegistry);
            this.index = index;
            this.fieldName = ComponentModel.computeFieldName(component2);
        }

        String getComponentName() {
            return this.component.getName();
        }

        String getFieldName() {
            return this.fieldName;
        }

        Object getValue(Record record) throws InvocationTargetException, IllegalAccessException {
            return this.component.getAccessor().invoke((Object)record, new Object[0]);
        }

        private static Codec<?> computeCodec(List<Type> typeParameters, RecordComponent component2, CodecRegistry codecRegistry) {
            Codec<?> codec;
            Class<?> rawType = RecordCodec.toWrapper(ComponentModel.resolveComponentType(typeParameters, component2));
            Type type = component2.getGenericType();
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                codec = codecRegistry.get(rawType, ComponentModel.resolveActualTypeArguments(typeParameters, component2.getDeclaringRecord(), parameterizedType));
            } else {
                codec = codecRegistry.get(rawType);
            }
            Codec<Object> codec2 = codec;
            BsonType bsonRepresentationType = null;
            if (component2.isAnnotationPresent(BsonRepresentation.class)) {
                bsonRepresentationType = component2.getAnnotation(BsonRepresentation.class).value();
            } else if (ComponentModel.isAnnotationPresentOnField(component2, org.bson.codecs.pojo.annotations.BsonRepresentation.class)) {
                bsonRepresentationType = ComponentModel.getAnnotationOnField(component2, org.bson.codecs.pojo.annotations.BsonRepresentation.class).value();
            }
            if (bsonRepresentationType != null) {
                if (codec2 instanceof RepresentationConfigurable) {
                    RepresentationConfigurable representationConfigurable = (RepresentationConfigurable)((Object)codec2);
                    codec2 = representationConfigurable.withRepresentation(bsonRepresentationType);
                } else {
                    throw new CodecConfigurationException(String.format("Codec for %s must implement RepresentationConfigurable to support BsonRepresentation", codec2.getEncoderClass()));
                }
            }
            return codec2;
        }

        private static Class<?> resolveComponentType(List<Type> typeParameters, RecordComponent component2) {
            Class clazz;
            Type resolvedType = ComponentModel.resolveType(component2.getGenericType(), typeParameters, component2.getDeclaringRecord());
            return resolvedType instanceof Class ? (clazz = (Class)resolvedType) : component2.getType();
        }

        private static List<Type> resolveActualTypeArguments(List<Type> typeParameters, Class<?> recordClass, ParameterizedType parameterizedType) {
            return Arrays.stream(parameterizedType.getActualTypeArguments()).map(type -> ComponentModel.resolveType(type, typeParameters, recordClass)).toList();
        }

        private static Type resolveType(Type type, List<Type> typeParameters, Class<?> recordClass) {
            Type type2;
            if (type instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)type;
                type2 = typeParameters.get(ComponentModel.getIndexOfTypeParameter(typeVariable.getName(), recordClass));
            } else {
                type2 = type;
            }
            return type2;
        }

        private static int getIndexOfTypeParameter(String typeParameterName, Class<?> recordClass) {
            TypeVariable<Class<?>>[] typeParameters = recordClass.getTypeParameters();
            for (int i2 = 0; i2 < typeParameters.length; ++i2) {
                if (!typeParameters[i2].getName().equals(typeParameterName)) continue;
                return i2;
            }
            throw new CodecConfigurationException(String.format("Could not find type parameter on record %s with name %s", recordClass.getName(), typeParameterName));
        }

        private static String computeFieldName(RecordComponent component2) {
            if (component2.isAnnotationPresent(BsonId.class)) {
                return "_id";
            }
            if (ComponentModel.isAnnotationPresentOnField(component2, org.bson.codecs.pojo.annotations.BsonId.class)) {
                return "_id";
            }
            if (component2.isAnnotationPresent(BsonProperty.class)) {
                return component2.getAnnotation(BsonProperty.class).value();
            }
            if (ComponentModel.isAnnotationPresentOnField(component2, org.bson.codecs.pojo.annotations.BsonProperty.class)) {
                return ComponentModel.getAnnotationOnField(component2, org.bson.codecs.pojo.annotations.BsonProperty.class).value();
            }
            return component2.getName();
        }

        private static <T extends Annotation> boolean isAnnotationPresentOnField(RecordComponent component2, Class<T> annotation) {
            try {
                return component2.getDeclaringRecord().getDeclaredField(component2.getName()).isAnnotationPresent(annotation);
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError(String.format("Unexpectedly missing the declared field for record component %s", component2), e);
            }
        }

        private static <T extends Annotation> boolean isAnnotationPresentOnCanonicalConstructorParameter(RecordComponent component2, int index, Class<T> annotation) {
            return RecordCodec.getCanonicalConstructor(component2.getDeclaringRecord()).getParameters()[index].isAnnotationPresent(annotation);
        }

        private static <T extends Annotation> T getAnnotationOnField(RecordComponent component2, Class<T> annotation) {
            try {
                return component2.getDeclaringRecord().getDeclaredField(component2.getName()).getAnnotation(annotation);
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError(String.format("Unexpectedly missing the declared field for recordComponent %s", component2), e);
            }
        }

        private static void validateAnnotations(RecordComponent component2, int index) {
            ComponentModel.validateAnnotationNotPresentOnType(component2.getDeclaringRecord(), BsonDiscriminator.class);
            ComponentModel.validateAnnotationNotPresentOnConstructor(component2.getDeclaringRecord(), BsonCreator.class);
            ComponentModel.validateAnnotationNotPresentOnMethod(component2.getDeclaringRecord(), BsonCreator.class);
            ComponentModel.validateAnnotationNotPresentOnFieldOrAccessor(component2, BsonIgnore.class);
            ComponentModel.validateAnnotationNotPresentOnFieldOrAccessor(component2, BsonExtraElements.class);
            ComponentModel.validateAnnotationOnlyOnField(component2, index, org.bson.codecs.pojo.annotations.BsonId.class);
            ComponentModel.validateAnnotationOnlyOnField(component2, index, org.bson.codecs.pojo.annotations.BsonProperty.class);
            ComponentModel.validateAnnotationOnlyOnField(component2, index, org.bson.codecs.pojo.annotations.BsonRepresentation.class);
        }

        private static <T extends Annotation> void validateAnnotationNotPresentOnType(Class<?> clazz, Class<T> annotation) {
            if (clazz.isAnnotationPresent(annotation)) {
                throw new CodecConfigurationException(String.format("Annotation '%s' not supported on records, but found on '%s'", annotation, clazz.getName()));
            }
        }

        private static <T extends Annotation> void validateAnnotationNotPresentOnConstructor(Class<?> clazz, Class<T> annotation) {
            for (Constructor<?> constructor : clazz.getConstructors()) {
                if (!constructor.isAnnotationPresent(annotation)) continue;
                throw new CodecConfigurationException(String.format("Annotation '%s' not supported on record constructors, but found on constructor of '%s'", annotation, clazz.getName()));
            }
        }

        private static <T extends Annotation> void validateAnnotationNotPresentOnMethod(Class<?> clazz, Class<T> annotation) {
            for (Method method : clazz.getMethods()) {
                if (!method.isAnnotationPresent(annotation)) continue;
                throw new CodecConfigurationException(String.format("Annotation '%s' not supported on methods, but found on method '%s' of '%s'", annotation, method.getName(), clazz.getName()));
            }
        }

        private static <T extends Annotation> void validateAnnotationNotPresentOnFieldOrAccessor(RecordComponent component2, Class<T> annotation) {
            if (ComponentModel.isAnnotationPresentOnField(component2, annotation)) {
                throw new CodecConfigurationException(String.format("Annotation '%s' is not supported on records, but found on component '%s' of record '%s'", annotation.getName(), component2, component2.getDeclaringRecord()));
            }
            if (component2.getAccessor().isAnnotationPresent(annotation)) {
                throw new CodecConfigurationException(String.format("Annotation '%s' is not supported on records, but found on accessor for component '%s' of record '%s'", annotation.getName(), component2, component2.getDeclaringRecord()));
            }
        }

        private static <T extends Annotation> void validateAnnotationOnlyOnField(RecordComponent component2, int index, Class<T> annotation) {
            if (!ComponentModel.isAnnotationPresentOnField(component2, annotation)) {
                if (component2.getAccessor().isAnnotationPresent(annotation)) {
                    throw new CodecConfigurationException(String.format("Annotation %s present on accessor but not component '%s' of record '%s'", annotation.getName(), component2, component2.getDeclaringRecord()));
                }
                if (ComponentModel.isAnnotationPresentOnCanonicalConstructorParameter(component2, index, annotation)) {
                    throw new CodecConfigurationException(String.format("Annotation %s present on canonical constructor parameter but not component '%s' of record '%s'", annotation.getName(), component2, component2.getDeclaringRecord()));
                }
            }
        }
    }
}

