/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;

public enum ThreadNameCachingStrategy {
    CACHED{

        @Override
        public String getThreadName() {
            String result2 = (String)THREADLOCAL_NAME.get();
            if (result2 == null) {
                result2 = Thread.currentThread().getName();
                THREADLOCAL_NAME.set(result2);
            }
            return result2;
        }
    }
    ,
    UNCACHED{

        @Override
        public String getThreadName() {
            return Thread.currentThread().getName();
        }
    };

    private static final StatusLogger LOGGER;
    private static final ThreadLocal<String> THREADLOCAL_NAME;

    abstract String getThreadName();

    public static ThreadNameCachingStrategy create() {
        String defaultStrategy = System.getProperty("java.version").compareTo("1.8.0_102") < 0 ? "CACHED" : "UNCACHED";
        String name = PropertiesUtil.getProperties().getStringProperty("AsyncLogger.ThreadNameStrategy");
        try {
            ThreadNameCachingStrategy result2 = ThreadNameCachingStrategy.valueOf(name != null ? name : defaultStrategy);
            LOGGER.debug("AsyncLogger.ThreadNameStrategy={} (user specified {}, default is {})", (Object)result2, (Object)name, (Object)defaultStrategy);
            return result2;
        }
        catch (Exception ex) {
            LOGGER.debug("Using AsyncLogger.ThreadNameStrategy.{}: '{}' not valid: {}", (Object)defaultStrategy, (Object)name, (Object)ex.toString());
            return ThreadNameCachingStrategy.valueOf(defaultStrategy);
        }
    }

    static {
        LOGGER = StatusLogger.getLogger();
        THREADLOCAL_NAME = new ThreadLocal();
    }
}

