/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.parser.antlr4.util;

import groovy.lang.Tuple;
import groovy.lang.Tuple2;
import groovyjarjarantlr4.v4.runtime.Token;
import groovyjarjarantlr4.v4.runtime.tree.TerminalNode;
import org.apache.groovy.parser.antlr4.GroovyParser;
import org.apache.groovy.parser.antlr4.util.StringUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class PositionConfigureUtils {
    public static <T extends ASTNode> T configureAST(T astNode, GroovyParser.GroovyParserRuleContext ctx) {
        Token start2 = ctx.getStart();
        Token stop2 = ctx.getStop();
        astNode.setLineNumber(start2.getLine());
        astNode.setColumnNumber(start2.getCharPositionInLine() + 1);
        PositionConfigureUtils.configureEndPosition(astNode, stop2);
        return astNode;
    }

    public static Tuple2<Integer, Integer> endPosition(Token token) {
        String stopText = token.getText();
        int stopTextLength = 0;
        int newLineCnt = 0;
        if (null != stopText) {
            stopTextLength = stopText.length();
            newLineCnt = (int)StringUtils.countChar(stopText, '\n');
        }
        if (0 == newLineCnt) {
            return Tuple.tuple(token.getLine(), token.getCharPositionInLine() + 1 + token.getText().length());
        }
        return Tuple.tuple(token.getLine() + newLineCnt, stopTextLength - stopText.lastIndexOf(10));
    }

    public static <T extends ASTNode> T configureAST(T astNode, TerminalNode terminalNode) {
        return PositionConfigureUtils.configureAST(astNode, terminalNode.getSymbol());
    }

    public static <T extends ASTNode> T configureAST(T astNode, Token token) {
        astNode.setLineNumber(token.getLine());
        astNode.setColumnNumber(token.getCharPositionInLine() + 1);
        astNode.setLastLineNumber(token.getLine());
        astNode.setLastColumnNumber(token.getCharPositionInLine() + 1 + token.getText().length());
        return astNode;
    }

    public static <T extends ASTNode> T configureAST(T astNode, ASTNode source2) {
        astNode.setLineNumber(source2.getLineNumber());
        astNode.setColumnNumber(source2.getColumnNumber());
        astNode.setLastLineNumber(source2.getLastLineNumber());
        astNode.setLastColumnNumber(source2.getLastColumnNumber());
        return astNode;
    }

    public static <T extends ASTNode> T configureAST(T astNode, GroovyParser.GroovyParserRuleContext ctx, ASTNode initialStop) {
        Token start2 = ctx.getStart();
        astNode.setLineNumber(start2.getLine());
        astNode.setColumnNumber(start2.getCharPositionInLine() + 1);
        if (DefaultGroovyMethods.asBoolean(initialStop)) {
            astNode.setLastLineNumber(initialStop.getLastLineNumber());
            astNode.setLastColumnNumber(initialStop.getLastColumnNumber());
        } else {
            Token stop2 = ctx.getStop();
            PositionConfigureUtils.configureEndPosition(astNode, stop2);
        }
        return astNode;
    }

    public static <T extends ASTNode> void configureEndPosition(T astNode, Token token) {
        Tuple2<Integer, Integer> endPosition = PositionConfigureUtils.endPosition(token);
        astNode.setLastLineNumber(endPosition.getV1());
        astNode.setLastColumnNumber(endPosition.getV2());
    }

    public static <T extends ASTNode> T configureAST(T astNode, ASTNode start2, ASTNode stop2) {
        astNode.setLineNumber(start2.getLineNumber());
        astNode.setColumnNumber(start2.getColumnNumber());
        if (DefaultGroovyMethods.asBoolean(stop2)) {
            astNode.setLastLineNumber(stop2.getLastLineNumber());
            astNode.setLastColumnNumber(stop2.getLastColumnNumber());
        } else {
            astNode.setLastLineNumber(start2.getLastLineNumber());
            astNode.setLastColumnNumber(start2.getLastColumnNumber());
        }
        return astNode;
    }
}

