/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.parser;

import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.Configurable;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.parser.CompositeFileEntryParser;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.net.ftp.parser.MVSFTPEntryParser;
import org.apache.commons.net.ftp.parser.MacOsPeterFTPEntryParser;
import org.apache.commons.net.ftp.parser.NTFTPEntryParser;
import org.apache.commons.net.ftp.parser.NetwareFTPEntryParser;
import org.apache.commons.net.ftp.parser.OS2FTPEntryParser;
import org.apache.commons.net.ftp.parser.OS400FTPEntryParser;
import org.apache.commons.net.ftp.parser.ParserInitializationException;
import org.apache.commons.net.ftp.parser.UnixFTPEntryParser;
import org.apache.commons.net.ftp.parser.VMSVersioningFTPEntryParser;

public class DefaultFTPFileEntryParserFactory
implements FTPFileEntryParserFactory {
    private static final String JAVA_IDENTIFIER = "\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart})*";
    private static final String JAVA_QUALIFIED_NAME = "(\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart})*\\.)+\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart})*";
    private static final Pattern JAVA_QUALIFIED_NAME_PATTERN = Pattern.compile("(\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart})*\\.)+\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart})*");

    @Override
    public FTPFileEntryParser createFileEntryParser(FTPClientConfig config2) throws ParserInitializationException {
        String key = config2.getServerSystemKey();
        return this.createFileEntryParser(key, config2);
    }

    @Override
    public FTPFileEntryParser createFileEntryParser(String key) {
        if (key == null) {
            throw new ParserInitializationException("Parser key cannot be null");
        }
        return this.createFileEntryParser(key, null);
    }

    private FTPFileEntryParser createFileEntryParser(String key, FTPClientConfig config2) {
        FTPFileEntryParser parser2 = null;
        if (JAVA_QUALIFIED_NAME_PATTERN.matcher(key).matches()) {
            try {
                Class<?> parserClass = Class.forName(key);
                try {
                    parser2 = (FTPFileEntryParser)parserClass.newInstance();
                }
                catch (ClassCastException e) {
                    throw new ParserInitializationException(parserClass.getName() + " does not implement the interface org.apache.commons.net.ftp.FTPFileEntryParser.", e);
                }
                catch (Exception | ExceptionInInitializerError e) {
                    throw new ParserInitializationException("Error initializing parser", e);
                }
            }
            catch (ClassNotFoundException parserClass) {
                // empty catch block
            }
        }
        if (parser2 == null) {
            String ukey = key.toUpperCase(Locale.ENGLISH);
            if (ukey.contains("UNIX_LTRIM")) {
                parser2 = new UnixFTPEntryParser(config2, true);
            } else if (ukey.contains("UNIX")) {
                parser2 = new UnixFTPEntryParser(config2, false);
            } else if (ukey.contains("VMS")) {
                parser2 = new VMSVersioningFTPEntryParser(config2);
            } else if (ukey.contains("WINDOWS")) {
                parser2 = this.createNTFTPEntryParser(config2);
            } else if (ukey.contains("OS/2")) {
                parser2 = new OS2FTPEntryParser(config2);
            } else if (ukey.contains("OS/400") || ukey.contains("AS/400")) {
                parser2 = this.createOS400FTPEntryParser(config2);
            } else if (ukey.contains("MVS")) {
                parser2 = new MVSFTPEntryParser();
            } else if (ukey.contains("NETWARE")) {
                parser2 = new NetwareFTPEntryParser(config2);
            } else if (ukey.contains("MACOS PETER")) {
                parser2 = new MacOsPeterFTPEntryParser(config2);
            } else if (ukey.contains("TYPE: L8")) {
                parser2 = new UnixFTPEntryParser(config2);
            } else {
                throw new ParserInitializationException("Unknown parser type: " + key);
            }
        }
        if (parser2 instanceof Configurable) {
            ((Configurable)((Object)parser2)).configure(config2);
        }
        return parser2;
    }

    public FTPFileEntryParser createMVSEntryParser() {
        return new MVSFTPEntryParser();
    }

    public FTPFileEntryParser createNetwareFTPEntryParser() {
        return new NetwareFTPEntryParser();
    }

    public FTPFileEntryParser createNTFTPEntryParser() {
        return this.createNTFTPEntryParser(null);
    }

    private FTPFileEntryParser createNTFTPEntryParser(FTPClientConfig config2) {
        if (config2 != null && "WINDOWS".equals(config2.getServerSystemKey())) {
            return new NTFTPEntryParser(config2);
        }
        FTPClientConfig config22 = config2 != null ? new FTPClientConfig(config2) : null;
        return new CompositeFileEntryParser(new FTPFileEntryParser[]{new NTFTPEntryParser(config2), new UnixFTPEntryParser(config22, config22 != null && "UNIX_LTRIM".equals(config22.getServerSystemKey()))});
    }

    public FTPFileEntryParser createOS2FTPEntryParser() {
        return new OS2FTPEntryParser();
    }

    public FTPFileEntryParser createOS400FTPEntryParser() {
        return this.createOS400FTPEntryParser(null);
    }

    private FTPFileEntryParser createOS400FTPEntryParser(FTPClientConfig config2) {
        if (config2 != null && "OS/400".equals(config2.getServerSystemKey())) {
            return new OS400FTPEntryParser(config2);
        }
        FTPClientConfig config22 = config2 != null ? new FTPClientConfig(config2) : null;
        return new CompositeFileEntryParser(new FTPFileEntryParser[]{new OS400FTPEntryParser(config2), new UnixFTPEntryParser(config22, config22 != null && "UNIX_LTRIM".equals(config22.getServerSystemKey()))});
    }

    public FTPFileEntryParser createUnixFTPEntryParser() {
        return new UnixFTPEntryParser();
    }

    public FTPFileEntryParser createVMSVersioningFTPEntryParser() {
        return new VMSVersioningFTPEntryParser();
    }
}

