/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer;

import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.micrometer.VertxPrometheusOptions;
import java.util.Base64;
import java.util.Map;

public class VertxPrometheusOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, VertxPrometheusOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "embeddedServerEndpoint": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setEmbeddedServerEndpoint((String)member.getValue());
                    break;
                }
                case "embeddedServerOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setEmbeddedServerOptions(new HttpServerOptions((JsonObject)member.getValue()));
                    break;
                }
                case "enabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setEnabled((Boolean)member.getValue());
                    break;
                }
                case "publishQuantiles": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setPublishQuantiles((Boolean)member.getValue());
                    break;
                }
                case "startEmbeddedServer": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setStartEmbeddedServer((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(VertxPrometheusOptions obj, JsonObject json) {
        VertxPrometheusOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(VertxPrometheusOptions obj, Map<String, Object> json) {
        if (obj.getEmbeddedServerEndpoint() != null) {
            json.put("embeddedServerEndpoint", obj.getEmbeddedServerEndpoint());
        }
        if (obj.getEmbeddedServerOptions() != null) {
            json.put("embeddedServerOptions", obj.getEmbeddedServerOptions().toJson());
        }
        json.put("enabled", obj.isEnabled());
        json.put("publishQuantiles", obj.isPublishQuantiles());
        json.put("startEmbeddedServer", obj.isStartEmbeddedServer());
    }
}

