/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ConnectionString;
import com.mongodb.connection.SocketSettings;
import io.vertx.core.json.JsonObject;
import java.util.concurrent.TimeUnit;

class SocketSettingsParser {
    private final SocketSettings settings;

    public SocketSettingsParser(ConnectionString connectionString, JsonObject config2) {
        Integer sendBufferSize;
        Integer receiveBufferSize;
        Integer socketTimeoutMS;
        Integer connectTimeoutMS;
        SocketSettings.Builder settings = SocketSettings.builder();
        if (connectionString != null) {
            settings.applyConnectionString(connectionString);
        }
        if ((connectTimeoutMS = config2.getInteger("connectTimeoutMS")) != null) {
            settings.connectTimeout(connectTimeoutMS, TimeUnit.MILLISECONDS);
        }
        if ((socketTimeoutMS = config2.getInteger("socketTimeoutMS")) != null) {
            settings.readTimeout(socketTimeoutMS, TimeUnit.MILLISECONDS);
        }
        if ((receiveBufferSize = config2.getInteger("receiveBufferSize")) != null) {
            settings.receiveBufferSize(receiveBufferSize);
        }
        if ((sendBufferSize = config2.getInteger("sendBufferSize")) != null) {
            settings.sendBufferSize(sendBufferSize);
        }
        this.settings = settings.build();
    }

    public SocketSettings settings() {
        return this.settings;
    }
}

