/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.rtpr;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.sip3.commons.domain.media.Codec;
import io.sip3.commons.domain.media.MediaControl;
import io.sip3.commons.domain.media.SdpSession;
import io.sip3.commons.domain.payload.RtpReportPayload;
import io.sip3.commons.micrometer.Metrics;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.collections.PeriodicallyExpiringHashMap;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.sip3.salto.ce.RoutesCE;
import io.sip3.salto.ce.domain.Packet;
import io.sip3.salto.ce.rtpr.RtprHandler;
import io.sip3.salto.ce.rtpr.RtprSession;
import io.sip3.salto.ce.rtpr.RtprStream;
import io.sip3.salto.ce.util.AttributeUtilKt;
import io.sip3.salto.ce.util.DurationUtil;
import io.sip3.salto.ce.util.MediaUtil;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.Counter;
import io.vertx.kotlin.coroutines.VertxCoroutineKt;
import java.lang.constant.Constable;
import java.lang.invoke.LambdaMetafactory;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Instance
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0017\u0018\u0000 02\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u0011H\u0016J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010)\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010*\u001a\u00020\u001dH\u0016J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u0018H\u0016J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010.\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%2\u0006\u0010'\u001a\u00020\u0011H\u0016J\u0018\u0010/\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00180\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00180\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lio/sip3/salto/ce/rtpr/RtprHandler;", "Lio/vertx/core/AbstractVerticle;", "()V", "aggregationTimeout", "", "cumulativeMetrics", "", "durationDistributions", "Ljava/util/TreeMap;", "", "expirationDelay", "instances", "", "logger", "Lmu/KLogger;", "mediaControls", "Lio/sip3/commons/vertx/collections/PeriodicallyExpiringHashMap;", "Lio/sip3/commons/domain/media/MediaControl;", "minExpectedPackets", "rFactorDistributions", "Ljava/util/TreeSet;", "rFactorThreshold", "", "rtcp", "Lio/sip3/salto/ce/rtpr/RtprSession;", "rtp", "timeSuffix", "Ljava/time/format/DateTimeFormatter;", "calculateMetrics", "", "prefix", "stream", "Lio/sip3/salto/ce/rtpr/RtprStream;", "handle", "packet", "Lio/sip3/salto/ce/domain/Packet;", "report", "Lio/sip3/commons/domain/payload/RtpReportPayload;", "handleMediaControl", "mediaControl", "handleRaw", "route", "start", "terminateRtprSession", "session", "terminateRtprStream", "updateWithMediaControl", "validate", "Companion", "sip3-salto-ce"})
public class RtprHandler
extends AbstractVerticle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    @NotNull
    private DateTimeFormatter timeSuffix;
    private long expirationDelay;
    private long aggregationTimeout;
    private boolean cumulativeMetrics;
    private int minExpectedPackets;
    private float rFactorThreshold;
    @NotNull
    private TreeSet<Integer> rFactorDistributions;
    @NotNull
    private TreeMap<Long, String> durationDistributions;
    private int instances;
    private PeriodicallyExpiringHashMap<String, MediaControl> mediaControls;
    private PeriodicallyExpiringHashMap<String, RtprSession> rtp;
    private PeriodicallyExpiringHashMap<String, RtprSession> rtcp;
    @NotNull
    private static final IntRange EXPECTED_PACKET_RANGE = new IntRange(1, 4096);
    public static final long MAX_TIMESTAMP_DRIFT = 600000L;
    @NotNull
    public static final String JITTER = "_jitter";
    @NotNull
    public static final String R_FACTOR = "_r-factor";
    @NotNull
    public static final String MOS = "_mos";
    @NotNull
    public static final String EXPECTED_PACKETS = "_expected-packets";
    @NotNull
    public static final String LOST_PACKETS = "_lost-packets";
    @NotNull
    public static final String REJECTED_PACKETS = "_rejected-packets";
    @NotNull
    public static final String MARKER_PACKETS = "_marker-packets";
    @NotNull
    public static final String DURATION = "_duration";
    @NotNull
    public static final String UNDEFINED = "_undefined";

    public RtprHandler() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "ofPattern(\"yyyyMMdd\")");
        this.timeSuffix = dateTimeFormatter;
        this.expirationDelay = 4000L;
        this.aggregationTimeout = 30000L;
        this.cumulativeMetrics = true;
        this.minExpectedPackets = 100;
        this.rFactorThreshold = 85.0f;
        this.rFactorDistributions = new TreeSet();
        this.durationDistributions = new TreeMap();
        this.instances = 1;
    }

    @Override
    public void start() {
        Object object;
        boolean bl;
        JsonObject jsonObject;
        String string = this.config().getString("time_suffix");
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(it);
            Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "ofPattern(it)");
            this.timeSuffix = dateTimeFormatter;
        }
        if ((jsonObject = this.config().getJsonObject("media")) != null && (jsonObject = jsonObject.getJsonObject("rtp_r")) != null) {
            Object it;
            Iterable $this$forEach$iv;
            JsonObject config2 = jsonObject;
            bl = false;
            Object object2 = config2.getLong("expiration_delay");
            Long l = object2;
            if (l != null) {
                Intrinsics.checkNotNullExpressionValue(l, "getLong(\"expiration_delay\")");
                long it3 = ((Number)object2).longValue();
                boolean bl2 = false;
                this.expirationDelay = it3;
            }
            object2 = config2.getLong("aggregation_timeout");
            Long l2 = object2;
            if (l2 != null) {
                Intrinsics.checkNotNullExpressionValue(l2, "getLong(\"aggregation_timeout\")");
                long it2 = ((Number)object2).longValue();
                boolean bl3 = false;
                this.aggregationTimeout = it2;
            }
            object2 = config2.getBoolean("cumulative_metrics");
            Constable constable = object2;
            if (constable != null) {
                Intrinsics.checkNotNullExpressionValue(constable, "getBoolean(\"cumulative_metrics\")");
                boolean bl3 = (Boolean)object2;
                boolean bl4 = false;
                this.cumulativeMetrics = bl3;
            }
            object2 = config2.getInteger("min_expected_packets");
            Constable constable2 = object2;
            if (constable2 != null) {
                Intrinsics.checkNotNullExpressionValue(constable2, "getInteger(\"min_expected_packets\")");
                int n = ((Number)object2).intValue();
                boolean bl5 = false;
                this.minExpectedPackets = n;
            }
            object2 = config2.getFloat("r_factor_threshold");
            Constable constable3 = object2;
            if (constable3 != null) {
                Intrinsics.checkNotNullExpressionValue(constable3, "getFloat(\"r_factor_threshold\")");
                float f = ((Number)object2).floatValue();
                boolean bl6 = false;
                this.rFactorThreshold = f;
            }
            Object object3 = object2 = config2.getJsonArray("r_factor_distributions");
            if (object3 != null) {
                Intrinsics.checkNotNullExpressionValue(object3, "getJsonArray(\"r_factor_distributions\")");
                $this$forEach$iv = (Iterable)object2;
                boolean bl4 = false;
                Iterator iterator3 = $this$forEach$iv.iterator();
                while (iterator3.hasNext()) {
                    Object element$iv;
                    it = element$iv = iterator3.next();
                    boolean bl7 = false;
                    Intrinsics.checkNotNull(it, "null cannot be cast to non-null type kotlin.Int");
                    this.rFactorDistributions.add((Integer)it);
                }
            }
            Object object4 = object2 = config2.getJsonArray("duration_distributions");
            if (object4 != null) {
                Intrinsics.checkNotNullExpressionValue(object4, "getJsonArray(\"duration_distributions\")");
                $this$forEach$iv = (Iterable)object2;
                boolean bl5 = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    it = element$iv = iterator2.next();
                    boolean bl8 = false;
                    Map map2 = this.durationDistributions;
                    Intrinsics.checkNotNull(it, "null cannot be cast to non-null type kotlin.String");
                    map2.put(DurationUtil.INSTANCE.parseDuration((String)it).toMillis(), it);
                }
            }
        }
        if ((object = this.config().getJsonObject("vertx")) != null && (object = ((JsonObject)object).getInteger("instances")) != null) {
            int it = ((Number)object).intValue();
            bl = false;
            this.instances = it;
        }
        PeriodicallyExpiringHashMap.Builder builder = new PeriodicallyExpiringHashMap.Builder(0L, 0, null, null, null, 31, null).delay(this.expirationDelay).period((int)(this.aggregationTimeout / this.expirationDelay)).expireAt((Function2)new Function2<String, MediaControl, Long>(this){
            final /* synthetic */ RtprHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Long invoke(@NotNull String string, @NotNull MediaControl mediaControl) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(mediaControl, "mediaControl");
                return mediaControl.getTimestamp() + RtprHandler.access$getAggregationTimeout$p(this.this$0);
            }
        });
        Vertx vertx = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx, "vertx");
        this.mediaControls = builder.build(vertx);
        PeriodicallyExpiringHashMap.Builder builder2 = new PeriodicallyExpiringHashMap.Builder(0L, 0, null, null, null, 31, null).delay(this.expirationDelay).period((int)(this.aggregationTimeout / this.expirationDelay)).expireAt((Function2)new Function2<String, RtprSession, Long>(this){
            final /* synthetic */ RtprHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Long invoke(@NotNull String string, @NotNull RtprSession session2) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(session2, "session");
                return session2.getTerminatedAt() + RtprHandler.access$getAggregationTimeout$p(this.this$0);
            }
        }).onExpire((Function2)new Function2<String, RtprSession, Unit>(this){
            final /* synthetic */ RtprHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull RtprSession session2) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(session2, "session");
                this.this$0.terminateRtprSession(session2);
            }
        });
        Vertx vertx2 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx2, "vertx");
        this.rtp = builder2.build(vertx2);
        PeriodicallyExpiringHashMap.Builder builder3 = new PeriodicallyExpiringHashMap.Builder(0L, 0, null, null, null, 31, null).delay(this.expirationDelay).period((int)(this.aggregationTimeout / this.expirationDelay)).expireAt((Function2)new Function2<String, RtprSession, Long>(this){
            final /* synthetic */ RtprHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Long invoke(@NotNull String string, @NotNull RtprSession session2) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(session2, "session");
                return session2.getTerminatedAt() + RtprHandler.access$getAggregationTimeout$p(this.this$0);
            }
        }).onExpire((Function2)new Function2<String, RtprSession, Unit>(this){
            final /* synthetic */ RtprHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String string, @NotNull RtprSession session2) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(session2, "session");
                this.this$0.terminateRtprSession(session2);
            }
        });
        Vertx vertx3 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx3, "vertx");
        this.rtcp = builder3.build(vertx3);
        this.vertx.eventBus().localConsumer(RoutesCE.Companion.getMedia() + "_control", arg_0 -> RtprHandler.start$lambda$10(this, arg_0));
        this.vertx.eventBus().localConsumer(RoutesCE.Companion.getRtpr(), arg_0 -> RtprHandler.start$lambda$11(this, arg_0));
        this.vertx.eventBus().localConsumer(RoutesCE.Companion.getRtpr() + "_rtcp", arg_0 -> RtprHandler.start$lambda$12(this, arg_0));
        CoroutineScope coroutineScope = GlobalScope.INSTANCE;
        Vertx vertx4 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx4, "vertx");
        CoroutineDispatcher coroutineDispatcher = VertxCoroutineKt.dispatcher(vertx4);
        Intrinsics.checkNotNull(coroutineDispatcher, "null cannot be cast to non-null type kotlin.coroutines.CoroutineContext");
        BuildersKt.launch$default(coroutineScope, coroutineDispatcher, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ RtprHandler this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        v0 = RtprHandler.access$getVertx$p$s256048838(this.this$0).sharedData().getLocalCounter(RoutesCE.Companion.getRtpr());
                        Intrinsics.checkNotNullExpressionValue(v0, "vertx.sharedData().getLocalCounter(RoutesCE.rtpr)");
                        this.label = 1;
                        v1 = VertxCoroutineKt.coAwait(v0, this);
                        if (v1 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        index = (Counter)v1;
                        var5_4 = RoutesCE.Companion.getRtpr();
                        var4_5 = RtprHandler.access$getVertx$p$s256048838(this.this$0).eventBus();
                        var3_6 = index.getAndIncrement();
                        Intrinsics.checkNotNullExpressionValue(var3_6, "index.andIncrement");
                        this.L$0 = var4_5;
                        this.L$1 = var5_4;
                        this.label = 2;
                        v2 = VertxCoroutineKt.coAwait(var3_6, this);
                        if (v2 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl32
                    }
                    case 2: {
                        var5_4 = (String)this.L$1;
                        var4_5 = (EventBus)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl32:
                        // 2 sources

                        var6_7 = v2;
                        var4_5.localConsumer(var5_4 + "_" + var6_7, (Handler<Message<T>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, invokeSuspend$lambda$0(io.sip3.salto.ce.rtpr.RtprHandler io.vertx.core.eventbus.Message ), (Lio/vertx/core/eventbus/Message;)V)((RtprHandler)this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(RtprHandler this$0, Message event) {
                try {
                    Pair pair = (Pair)event.body();
                    Packet packet = (Packet)pair.component1();
                    RtpReportPayload report = (RtpReportPayload)pair.component2();
                    this$0.handle(packet, report);
                }
                catch (Exception e) {
                    RtprHandler.access$getLogger$p(this$0).error(e, (Function0<? extends Object>)start.1.1.INSTANCE);
                }
            }
        }, 2, null);
    }

    public void handleMediaControl(@NotNull MediaControl mediaControl) {
        SdpSession sdpSession;
        Intrinsics.checkNotNullParameter(mediaControl, "mediaControl");
        SdpSession $this$handleMediaControl_u24lambda_u2413 = sdpSession = mediaControl.getSdpSession();
        boolean bl = false;
        PeriodicallyExpiringHashMap<String, MediaControl> periodicallyExpiringHashMap = this.mediaControls;
        if (periodicallyExpiringHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("mediaControls");
            periodicallyExpiringHashMap = null;
        }
        periodicallyExpiringHashMap.put($this$handleMediaControl_u24lambda_u2413.getSrc().getRtpId(), mediaControl);
        PeriodicallyExpiringHashMap<String, MediaControl> periodicallyExpiringHashMap2 = this.mediaControls;
        if (periodicallyExpiringHashMap2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("mediaControls");
            periodicallyExpiringHashMap2 = null;
        }
        periodicallyExpiringHashMap2.put($this$handleMediaControl_u24lambda_u2413.getSrc().getRtcpId(), mediaControl);
        PeriodicallyExpiringHashMap<String, MediaControl> periodicallyExpiringHashMap3 = this.mediaControls;
        if (periodicallyExpiringHashMap3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("mediaControls");
            periodicallyExpiringHashMap3 = null;
        }
        periodicallyExpiringHashMap3.put($this$handleMediaControl_u24lambda_u2413.getDst().getRtpId(), mediaControl);
        PeriodicallyExpiringHashMap<String, MediaControl> periodicallyExpiringHashMap4 = this.mediaControls;
        if (periodicallyExpiringHashMap4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("mediaControls");
            periodicallyExpiringHashMap4 = null;
        }
        periodicallyExpiringHashMap4.put($this$handleMediaControl_u24lambda_u2413.getDst().getRtcpId(), mediaControl);
    }

    public void handleRaw(@NotNull Packet packet) {
        RtpReportPayload rtpReportPayload;
        Intrinsics.checkNotNullParameter(packet, "packet");
        RtpReportPayload $this$handleRaw_u24lambda_u2414 = rtpReportPayload = new RtpReportPayload();
        boolean bl = false;
        ByteBuf payload = Unpooled.wrappedBuffer(packet.getPayload());
        Intrinsics.checkNotNullExpressionValue(payload, "payload");
        $this$handleRaw_u24lambda_u2414.decode(payload);
        RtpReportPayload report = rtpReportPayload;
        this.route(packet, report);
    }

    public void route(@NotNull Packet packet, @NotNull RtpReportPayload report) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        Intrinsics.checkNotNullParameter(report, "report");
        int index = Integer.hashCode(packet.getSrcAddr().getPort() + packet.getDstAddr().getPort()) % this.instances;
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
        EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getRtpr() + "_" + index, new Pair<Packet, RtpReportPayload>(packet, report), null, 4, null);
    }

    public void handle(@NotNull Packet packet, @NotNull RtpReportPayload report) {
        String sessionId2;
        PeriodicallyExpiringHashMap<String, RtprSession> sessions;
        RtprSession session2;
        PeriodicallyExpiringHashMap<String, RtprSession> periodicallyExpiringHashMap;
        Intrinsics.checkNotNullParameter(packet, "packet");
        Intrinsics.checkNotNullParameter(report, "report");
        if (!this.validate(packet, report)) {
            this.logger.debug((Function0<? extends Object>)new Function0<Object>(report){
                final /* synthetic */ RtpReportPayload $report;
                {
                    this.$report = $report;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Handle invalid RTP Report. Report: " + JsonObject.mapFrom(this.$report);
                }
            });
            return;
        }
        byte source2 = report.getSource();
        byte by = source2;
        if (by == 0) {
            periodicallyExpiringHashMap = this.rtp;
            if (periodicallyExpiringHashMap == null) {
                Intrinsics.throwUninitializedPropertyAccessException("rtp");
                periodicallyExpiringHashMap = null;
            }
        } else if (by == 1) {
            periodicallyExpiringHashMap = this.rtcp;
            if (periodicallyExpiringHashMap == null) {
                Intrinsics.throwUninitializedPropertyAccessException("rtcp");
                periodicallyExpiringHashMap = null;
            }
        } else {
            throw new IllegalArgumentException("Unsupported RTP Report source: '" + report.getSource() + "'");
        }
        if ((session2 = (sessions = periodicallyExpiringHashMap).get(sessionId2 = packet.getSrcAddr().compositeKey(packet.getDstAddr(), handle.sessionId.1.INSTANCE))) == null) {
            MediaControl mediaControl;
            MediaControl mediaControl2;
            PeriodicallyExpiringHashMap<String, MediaControl> periodicallyExpiringHashMap2 = this.mediaControls;
            if (periodicallyExpiringHashMap2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("mediaControls");
                periodicallyExpiringHashMap2 = null;
            }
            if ((mediaControl2 = periodicallyExpiringHashMap2.get(packet.getSrcAddr().sdpSessionId())) == null) {
                PeriodicallyExpiringHashMap<String, MediaControl> periodicallyExpiringHashMap3 = this.mediaControls;
                if (periodicallyExpiringHashMap3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("mediaControls");
                    periodicallyExpiringHashMap3 = null;
                }
                mediaControl2 = periodicallyExpiringHashMap3.get(packet.getDstAddr().sdpSessionId());
            }
            if ((mediaControl = mediaControl2) != null) {
                RtprSession rtprSession;
                RtprSession $this$handle_u24lambda_u2415 = rtprSession = RtprSession.Companion.create(source2, mediaControl, packet);
                boolean bl = false;
                $this$handle_u24lambda_u2415.setRFactorThreshold(Float.valueOf(this.rFactorThreshold));
                session2 = rtprSession;
                sessions.put(sessionId2, session2);
            }
        }
        if (session2 != null) {
            this.updateWithMediaControl(report, session2.getMediaControl());
            session2.add(packet, report);
            if (session2.getMediaControl().getRecording() == null && session2.getSource() == 0) {
                EventBus eventBus = this.vertx.eventBus();
                Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
                EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getRtpr() + "_update", session2, null, 4, null);
            }
        }
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
        EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getRtpr() + "_bulk_writer", new Pair<Packet, RtpReportPayload>(packet, report), null, 4, null);
    }

    private final boolean validate(Packet packet, RtpReportPayload report) {
        IntRange intRange = EXPECTED_PACKET_RANGE;
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        int n3 = report.getExpectedPacketCount();
        return (n <= n3 ? n3 <= n2 : false) && Math.abs(report.getCreatedAt() - packet.getCreatedAt()) < 600000L;
    }

    public void updateWithMediaControl(@NotNull RtpReportPayload report, @NotNull MediaControl mediaControl) {
        Codec codec;
        boolean isRtcp;
        Intrinsics.checkNotNullParameter(report, "report");
        Intrinsics.checkNotNullParameter(mediaControl, "mediaControl");
        report.setCallId(mediaControl.getCallId());
        if (report.getCodecName() != null) {
            return;
        }
        SdpSession sdpSession = mediaControl.getSdpSession();
        boolean bl = isRtcp = report.getSource() == 1;
        if (report.getDuration() == 0) {
            report.setDuration(report.getExpectedPacketCount() * sdpSession.getPtime());
            if (isRtcp && report.getCreatedAt() == report.getReportedAt()) {
                report.setCreatedAt(report.getCreatedAt() - (long)report.getDuration());
            }
        }
        Codec codec2 = codec = isRtcp ? CollectionsKt.firstOrNull(sdpSession.getCodecs()) : sdpSession.codec(report.getPayloadType());
        if (codec != null) {
            report.setCodecName(codec.getName());
            float ppl = report.getFractionLost() * (float)100;
            float ieEff = codec.getIe() + ((float)95 - codec.getIe()) * ppl / (ppl + codec.getBpl());
            report.setRFactor(93.2f - ieEff);
            report.setMos(MediaUtil.INSTANCE.computeMos(report.getRFactor()));
            if (isRtcp) {
                RtpReportPayload rtpReportPayload;
                RtpReportPayload $this$updateWithMediaControl_u24lambda_u2416 = rtpReportPayload = report;
                boolean bl2 = false;
                $this$updateWithMediaControl_u24lambda_u2416.setLastJitter($this$updateWithMediaControl_u24lambda_u2416.getLastJitter() / (float)codec.getClockRate() * 1000.0f);
                $this$updateWithMediaControl_u24lambda_u2416.setAvgJitter($this$updateWithMediaControl_u24lambda_u2416.getAvgJitter() / (float)codec.getClockRate() * 1000.0f);
                $this$updateWithMediaControl_u24lambda_u2416.setMinJitter($this$updateWithMediaControl_u24lambda_u2416.getMinJitter() / (float)codec.getClockRate() * 1000.0f);
                $this$updateWithMediaControl_u24lambda_u2416.setMaxJitter($this$updateWithMediaControl_u24lambda_u2416.getMaxJitter() / (float)codec.getClockRate() * 1000.0f);
            }
        }
    }

    public void terminateRtprSession(@NotNull RtprSession session2) {
        RtprStream it;
        Intrinsics.checkNotNullParameter(session2, "session");
        RtprStream rtprStream = session2.getForward();
        if (rtprStream != null) {
            it = rtprStream;
            boolean bl = false;
            this.terminateRtprStream(it);
        }
        RtprStream rtprStream2 = session2.getReverse();
        if (rtprStream2 != null) {
            it = rtprStream2;
            boolean bl = false;
            this.terminateRtprStream(it);
        }
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
        EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getRtpr() + "_session", session2, null, 4, null);
    }

    public void terminateRtprStream(@NotNull RtprStream stream2) {
        String string;
        Intrinsics.checkNotNullParameter(stream2, "stream");
        byte by = stream2.getSource();
        if (by == 0) {
            string = "rtpr_rtp";
        } else if (by == 1) {
            string = "rtpr_rtcp";
        } else {
            throw new IllegalArgumentException("Unsupported RTP Report source: '" + stream2.getSource() + "'");
        }
        String prefix = string;
        this.calculateMetrics(prefix, stream2);
    }

    /*
     * WARNING - void declaration
     */
    public void calculateMetrics(@NotNull String prefix, @NotNull RtprStream stream2) {
        void $this$forEach$iv;
        String it;
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(stream2, "stream");
        RtpReportPayload report = stream2.getReport();
        Object object = new LinkedHashMap();
        Map $this$calculateMetrics_u24lambda_u2423 = object;
        boolean bl = false;
        String string = stream2.getSrcAddr().getHost();
        if (string != null) {
            it = string;
            boolean bl2 = false;
            $this$calculateMetrics_u24lambda_u2423.put("src_host", it);
        }
        String string2 = stream2.getDstAddr().getHost();
        if (string2 != null) {
            it = string2;
            boolean bl3 = false;
            $this$calculateMetrics_u24lambda_u2423.put("dst_host", it);
        }
        String string3 = report.getCodecName();
        if (string3 != null) {
            it = string3;
            boolean bl4 = false;
            $this$calculateMetrics_u24lambda_u2423.put("codec", it);
        }
        if (report.getExpectedPacketCount() >= this.minExpectedPackets) {
            $this$calculateMetrics_u24lambda_u2423.put("ranked", true);
        }
        Map map2 = AttributeUtilKt.toMetricsAttributes$default(stream2.getAttributes(), null, 1, null);
        boolean $i$f$forEach2 = false;
        Object object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = object2.next();
            boolean bl5 = false;
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            $this$calculateMetrics_u24lambda_u2423.put(name, value);
        }
        Map attributes = object;
        Object $this$calculateMetrics_u24lambda_u2426 = object = report;
        boolean bl6 = false;
        Metrics.INSTANCE.summary(prefix + EXPECTED_PACKETS, attributes).record(((RtpReportPayload)$this$calculateMetrics_u24lambda_u2426).getExpectedPacketCount());
        Metrics.INSTANCE.summary(prefix + LOST_PACKETS, attributes).record(((RtpReportPayload)$this$calculateMetrics_u24lambda_u2426).getLostPacketCount());
        Metrics.INSTANCE.summary(prefix + REJECTED_PACKETS, attributes).record(((RtpReportPayload)$this$calculateMetrics_u24lambda_u2426).getRejectedPacketCount());
        if (report.getSource() == 0) {
            Metrics.INSTANCE.summary(prefix + MARKER_PACKETS, attributes).record(((RtpReportPayload)$this$calculateMetrics_u24lambda_u2426).getMarkerPacketCount());
        }
        if (((RtpReportPayload)$this$calculateMetrics_u24lambda_u2426).getCallId() != null && ((RtpReportPayload)$this$calculateMetrics_u24lambda_u2426).getCodecName() != null) {
            Metrics.INSTANCE.timer(prefix + DURATION, attributes).record(((RtpReportPayload)$this$calculateMetrics_u24lambda_u2426).getDuration(), TimeUnit.MILLISECONDS);
            Metrics.INSTANCE.summary(prefix + JITTER, attributes).record(((RtpReportPayload)$this$calculateMetrics_u24lambda_u2426).getAvgJitter());
            Metrics.INSTANCE.summary(prefix + MOS, attributes).record(((RtpReportPayload)$this$calculateMetrics_u24lambda_u2426).getMos());
            object2 = this.rFactorDistributions.ceiling((int)((RtpReportPayload)$this$calculateMetrics_u24lambda_u2426).getRFactor());
            if (object2 != null) {
                int it2 = ((Number)object2).intValue();
                boolean bl7 = false;
                Integer $i$f$forEach2 = it2;
                attributes.put("distribution", $i$f$forEach2);
            }
            object2 = this.durationDistributions.ceilingKey(Long.valueOf(report.getDuration()));
            if (object2 != null) {
                long it3 = ((Number)object2).longValue();
                boolean bl8 = false;
                String string4 = this.durationDistributions.get(it3);
                Intrinsics.checkNotNull(string4);
                attributes.put("duration", string4);
            }
            Metrics.INSTANCE.summary(prefix + R_FACTOR, attributes).record(((RtpReportPayload)$this$calculateMetrics_u24lambda_u2426).getRFactor());
        } else {
            Metrics.INSTANCE.counter(prefix + UNDEFINED, attributes).increment();
        }
    }

    private static final void start$lambda$10(RtprHandler this$0, Message event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        MediaControl mediaControl = (MediaControl)event.body();
        Intrinsics.checkNotNullExpressionValue(mediaControl, "mediaControl");
        this$0.handleMediaControl(mediaControl);
    }

    private static final void start$lambda$11(RtprHandler this$0, Message event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            Packet packet = (Packet)event.body();
            Intrinsics.checkNotNullExpressionValue(packet, "packet");
            this$0.handleRaw(packet);
        }
        catch (Exception e) {
            this$0.logger.error(e, (Function0<? extends Object>)start.10.1.INSTANCE);
        }
    }

    private static final void start$lambda$12(RtprHandler this$0, Message event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            Pair pair = (Pair)event.body();
            Packet packet = (Packet)pair.component1();
            RtpReportPayload report = (RtpReportPayload)pair.component2();
            this$0.route(packet, report);
        }
        catch (Exception e) {
            this$0.logger.error(e, (Function0<? extends Object>)start.11.1.INSTANCE);
        }
    }

    public static final /* synthetic */ long access$getAggregationTimeout$p(RtprHandler $this) {
        return $this.aggregationTimeout;
    }

    public static final /* synthetic */ Vertx access$getVertx$p$s256048838(RtprHandler $this) {
        return $this.vertx;
    }

    public static final /* synthetic */ KLogger access$getLogger$p(RtprHandler $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/sip3/salto/ce/rtpr/RtprHandler$Companion;", "", "()V", "DURATION", "", "EXPECTED_PACKETS", "EXPECTED_PACKET_RANGE", "Lkotlin/ranges/IntRange;", "getEXPECTED_PACKET_RANGE", "()Lkotlin/ranges/IntRange;", "JITTER", "LOST_PACKETS", "MARKER_PACKETS", "MAX_TIMESTAMP_DRIFT", "", "MOS", "REJECTED_PACKETS", "R_FACTOR", "UNDEFINED", "sip3-salto-ce"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntRange getEXPECTED_PACKET_RANGE() {
            return EXPECTED_PACKET_RANGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

