/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.mongo;

import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.salto.ce.RoutesCE;
import io.sip3.salto.ce.mongo.MongoBulkWriter;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.WriteOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Instance
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/sip3/salto/ce/mongo/MongoBulkWriter;", "Lio/vertx/core/AbstractVerticle;", "()V", "bulkSize", "", "bulkWriteOptions", "Lio/vertx/ext/mongo/BulkWriteOptions;", "client", "Lio/vertx/ext/mongo/MongoClient;", "logger", "Lmu/KLogger;", "operations", "", "", "", "Lio/vertx/ext/mongo/BulkOperation;", "size", "flushToDatabase", "", "handle", "collection", "operation", "Lio/vertx/core/json/JsonObject;", "start", "stop", "sip3-salto-ce"})
public class MongoBulkWriter
extends AbstractVerticle {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    private MongoClient client;
    private int bulkSize;
    @NotNull
    private final BulkWriteOptions bulkWriteOptions = new BulkWriteOptions(false);
    @NotNull
    private final Map<String, List<BulkOperation>> operations = new LinkedHashMap();
    private int size;

    @Override
    public void start() {
        Integer n;
        JsonObject config2 = this.config().getJsonObject("mongo");
        boolean bl = false;
        Vertx vertx = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx, "vertx");
        Intrinsics.checkNotNullExpressionValue(config2, "config");
        this.client = io.sip3.commons.mongo.MongoClient.INSTANCE.createShared(vertx, config2);
        Integer n2 = config2.getInteger("bulk_size");
        Intrinsics.checkNotNullExpressionValue(n2, "config.getInteger(\"bulk_size\")");
        this.bulkSize = ((Number)n2).intValue();
        Integer n3 = n = config2.getInteger("write_option");
        if (n3 != null) {
            Intrinsics.checkNotNullExpressionValue(n3, "getInteger(\"write_option\")");
            int writeOption = ((Number)n).intValue();
            boolean bl2 = false;
            this.bulkWriteOptions.setWriteOption(WriteOption.values()[writeOption]);
        }
        this.vertx.eventBus().localConsumer(RoutesCE.Companion.getMongo_bulk_writer(), arg_0 -> MongoBulkWriter.start$lambda$2(this, arg_0));
    }

    @Override
    public void stop() {
        this.flushToDatabase();
    }

    public void handle(@NotNull String collection, @NotNull JsonObject operation) {
        List list;
        JsonObject jsonObject;
        Intrinsics.checkNotNullParameter(collection, "collection");
        Intrinsics.checkNotNullParameter(operation, "operation");
        JsonObject $this$handle_u24lambda_u243 = jsonObject = operation;
        boolean bl = false;
        if (!$this$handle_u24lambda_u243.containsKey("type")) {
            $this$handle_u24lambda_u243.put("type", "INSERT");
        }
        if (!$this$handle_u24lambda_u243.containsKey("multi")) {
            $this$handle_u24lambda_u243.put("multi", false);
        }
        if (!$this$handle_u24lambda_u243.containsKey("upsert")) {
            $this$handle_u24lambda_u243.put("upsert", false);
        }
        Map<String, List<BulkOperation>> $this$getOrPut$iv = this.operations;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(collection);
        if (value$iv == null) {
            boolean bl2 = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(collection, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        List bulkOperations = list;
        bulkOperations.add((BulkOperation)new BulkOperation(operation));
        int n = this.size;
        this.size = n + 1;
        if (this.size >= this.bulkSize) {
            this.flushToDatabase();
        }
    }

    private final void flushToDatabase() {
        Map<String, List<BulkOperation>> $this$forEach$iv = this.operations;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, List<BulkOperation>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, List<BulkOperation>> element$iv;
            Map.Entry<String, List<BulkOperation>> entry = element$iv = iterator2.next();
            boolean bl = false;
            String collection = entry.getKey();
            List<BulkOperation> bulkOperations = entry.getValue();
            MongoClient mongoClient = this.client;
            if (mongoClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException("client");
                mongoClient = null;
            }
            mongoClient.bulkWriteWithOptions(collection, bulkOperations, this.bulkWriteOptions, arg_0 -> MongoBulkWriter.flushToDatabase$lambda$6$lambda$5(this, arg_0));
        }
        this.operations.clear();
        this.size = 0;
    }

    private static final void start$lambda$2(MongoBulkWriter this$0, Message bulkOperation) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            Pair pair = (Pair)bulkOperation.body();
            String collection = (String)pair.component1();
            JsonObject operation = (JsonObject)pair.component2();
            this$0.handle(collection, operation);
        }
        catch (Exception e) {
            this$0.logger.error(e, (Function0<? extends Object>)start.2.1.INSTANCE);
        }
    }

    private static final void flushToDatabase$lambda$6$lambda$5(MongoBulkWriter this$0, AsyncResult asr) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (asr.failed()) {
            this$0.logger.error(asr.cause(), (Function0<? extends Object>)flushToDatabase.1.1.1.INSTANCE);
        }
    }
}

