/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.management;

import io.sip3.commons.util.SocketAddressUtilKt;
import io.sip3.commons.vertx.annotations.ConditionalOnProperty;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.salto.ce.management.AbstractServer;
import io.sip3.salto.ce.management.UdpServer;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramPacket;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Instance(singleton=true)
@ConditionalOnProperty(pointer="/management", matcher=".*: ?\"?udp://.*")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/sip3/salto/ce/management/UdpServer;", "Lio/sip3/salto/ce/management/AbstractServer;", "()V", "logger", "Lmu/KLogger;", "socket", "Lio/vertx/core/datagram/DatagramSocket;", "uri", "Ljava/net/URI;", "readConfig", "", "send", "message", "Lio/vertx/core/json/JsonObject;", "uris", "", "startServer", "sip3-salto-ce"})
public class UdpServer
extends AbstractServer {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    private URI uri;
    private DatagramSocket socket;

    @Override
    public void readConfig() {
        block3: {
            JsonObject jsonObject;
            JsonObject jsonObject2 = this.config().getJsonObject("management");
            if (jsonObject2 == null) break block3;
            JsonObject management = jsonObject2;
            boolean bl = false;
            Object object = management.getJsonObject("udp");
            JsonObject jsonObject3 = object;
            if (jsonObject3 == null) {
                jsonObject = management;
            } else {
                Intrinsics.checkNotNullExpressionValue(jsonObject3, "management.getJsonObject(\"udp\") ?: management");
                jsonObject = object;
            }
            JsonObject config2 = jsonObject;
            Object object2 = object = config2.getString("uri");
            if (object2 == null) {
                throw new IllegalArgumentException("uri");
            }
            Intrinsics.checkNotNullExpressionValue(object2, "config.getString(\"uri\") \u2026lArgumentException(\"uri\")");
            this.uri = new URI((String)object);
        }
    }

    @Override
    public void startServer() {
        URI uRI;
        DatagramSocketOptions datagramSocketOptions;
        DatagramSocketOptions $this$startServer_u24lambda_u241 = datagramSocketOptions = new DatagramSocketOptions();
        boolean bl = false;
        URI uRI2 = this.uri;
        if (uRI2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("uri");
            uRI2 = null;
        }
        String string = uRI2.getHost();
        Intrinsics.checkNotNullExpressionValue(string, "uri.host");
        CharSequence charSequence = string;
        $this$startServer_u24lambda_u241.setIpV6(new Regex("\\[.*]").matches(charSequence));
        DatagramSocketOptions options = datagramSocketOptions;
        DatagramSocket datagramSocket = this.vertx.createDatagramSocket(options);
        Intrinsics.checkNotNullExpressionValue(datagramSocket, "vertx.createDatagramSocket(options)");
        this.socket = datagramSocket;
        DatagramSocket datagramSocket2 = this.socket;
        if (datagramSocket2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("socket");
            datagramSocket2 = null;
        }
        datagramSocket2.handler(arg_0 -> UdpServer.startServer$lambda$2(options, this, arg_0));
        DatagramSocket datagramSocket3 = this.socket;
        if (datagramSocket3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("socket");
            datagramSocket3 = null;
        }
        if ((uRI = this.uri) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("uri");
            uRI = null;
        }
        int n = uRI.getPort();
        URI uRI3 = this.uri;
        if (uRI3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("uri");
            uRI3 = null;
        }
        datagramSocket3.listen(n, uRI3.getHost()).onFailure(arg_0 -> UdpServer.startServer$lambda$3(this, arg_0)).onSuccess(arg_0 -> UdpServer.startServer$lambda$4(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void send(@NotNull JsonObject message, @NotNull List<URI> uris) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        URI it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(uris, "uris");
        Buffer buffer = message.toBuffer();
        Iterable $this$filter$iv = uris;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (URI)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getScheme(), "udp")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (URI)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair<String, Integer>(it.getHost(), it.getPort()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            String host = (String)pair.component1();
            int port = ((Number)pair.component2()).intValue();
            this.logger.trace((Function0<? extends Object>)new Function0<Object>(host, port){
                final /* synthetic */ String $host;
                final /* synthetic */ int $port;
                {
                    this.$host = $host;
                    this.$port = $port;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Sending message to " + this.$host + ":" + this.$port;
                }
            });
            DatagramSocket datagramSocket = this.socket;
            if (datagramSocket == null) {
                Intrinsics.throwUninitializedPropertyAccessException("socket");
                datagramSocket = null;
            }
            datagramSocket.send(buffer, port, host);
        }
    }

    private static final void startServer$lambda$2(DatagramSocketOptions $options, UdpServer this$0, DatagramPacket packet) {
        Intrinsics.checkNotNullParameter($options, "$options");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        SocketAddress socketAddress = packet.sender();
        Intrinsics.checkNotNullExpressionValue(socketAddress, "socketAddress");
        URI senderUri = SocketAddressUtilKt.toURI(socketAddress, "udp", $options.isIpV6());
        Buffer buffer = packet.data();
        try {
            JsonObject message = buffer.toJsonObject();
            Intrinsics.checkNotNullExpressionValue(message, "message");
            this$0.handle(senderUri, message);
        }
        catch (Exception e) {
            this$0.logger.error(e, (Function0<? extends Object>)startServer.1.1.INSTANCE);
        }
    }

    private static final void startServer$lambda$3(UdpServer this$0, Throwable t) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.logger.error(t, (Function0<? extends Object>)new Function0<Object>(this$0){
            final /* synthetic */ UdpServer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                URI uRI = UdpServer.access$getUri$p(this.this$0);
                if (uRI == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("uri");
                    uRI = null;
                }
                return "UDP connection failed. URI: " + uRI;
            }
        });
        Intrinsics.checkNotNullExpressionValue(t, "t");
        throw t;
    }

    private static final void startServer$lambda$4(UdpServer this$0, DatagramSocket it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.logger.info((Function0<? extends Object>)new Function0<Object>(this$0){
            final /* synthetic */ UdpServer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                URI uRI = UdpServer.access$getUri$p(this.this$0);
                if (uRI == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("uri");
                    uRI = null;
                }
                return "Listening on " + uRI;
            }
        });
    }

    public static final /* synthetic */ URI access$getUri$p(UdpServer $this) {
        return $this.uri;
    }
}

