/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.decoder;

import io.micrometer.core.instrument.Counter;
import io.netty.buffer.ByteBufUtil;
import io.sip3.commons.micrometer.Metrics;
import io.sip3.commons.util.IpUtil;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.sip3.salto.ce.RoutesCE;
import io.sip3.salto.ce.decoder.Decoder;
import io.sip3.salto.ce.domain.Address;
import io.sip3.salto.ce.domain.Packet;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.InflaterInputStream;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Instance
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/sip3/salto/ce/decoder/Decoder;", "Lio/vertx/core/AbstractVerticle;", "()V", "logger", "Lmu/KLogger;", "packetsDecoded", "Lio/micrometer/core/instrument/Counter;", "decode", "", "sender", "Lio/sip3/salto/ce/domain/Address;", "buffer", "Lio/vertx/core/buffer/Buffer;", "", "Lio/sip3/salto/ce/domain/Packet;", "start", "Companion", "sip3-salto-ce"})
public final class Decoder
extends AbstractVerticle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    @NotNull
    private final Counter packetsDecoded = Metrics.INSTANCE.counter("packets_decoded", MapsKt.mapOf(TuplesKt.to("proto", "sip3")));
    public static final int HEADER_LENGTH = 4;

    @Override
    public void start() {
        this.vertx.eventBus().localConsumer(RoutesCE.Companion.getSip3(), arg_0 -> Decoder.start$lambda$0(this, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void decode(Address sender, Buffer buffer) {
        List<Packet> list;
        byte protocolVersion;
        int offset = 4;
        if ((protocolVersion = buffer.getByte(offset++)) == 2) {
            boolean compressed;
            boolean bl = compressed = buffer.getByte(offset++) == 1;
            if (compressed) {
                byte[] payload = buffer.slice(offset, buffer.length()).getBytes();
                Closeable closeable = new InflaterInputStream(new ByteArrayInputStream(payload));
                Throwable throwable = null;
                try {
                    InflaterInputStream inflater = (InflaterInputStream)closeable;
                    boolean bl2 = false;
                    Buffer buffer2 = Buffer.buffer(ByteStreamsKt.readBytes(inflater));
                    Intrinsics.checkNotNullExpressionValue(buffer2, "buffer(inflater.readBytes())");
                    List<Packet> list2 = this.decode(buffer2);
                    list = list2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            } else {
                Buffer buffer3 = buffer.slice(offset, buffer.length());
                Intrinsics.checkNotNullExpressionValue(buffer3, "buffer.slice(offset, buffer.length())");
                list = this.decode(buffer3);
            }
        } else {
            throw new NotImplementedError("Unsupported protocol version. Version: " + protocolVersion);
        }
        List<Packet> packets = list;
        this.packetsDecoded.increment(packets.size());
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
        EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getRouter(), new Pair<Address, List<Packet>>(sender, packets), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Packet> decode(Buffer buffer) {
        int packetLength;
        List packets = new ArrayList();
        for (int offset = 0; offset < buffer.length(); offset += packetLength) {
            Packet packet;
            int packetOffset = offset;
            byte packetType = buffer.getByte(packetOffset);
            byte packetVersion = buffer.getByte(++packetOffset);
            if (packetType != 1 && packetType != 2 || packetVersion != 1) {
                throw new NotImplementedError("Unknown SIP3 packet type or version. Type: " + packetType + ", Version: " + packetVersion);
            }
            Long millis = null;
            Integer nanos = null;
            byte[] srcAddr = null;
            byte[] dstAddr = null;
            Integer srcPort = null;
            Integer dstPort = null;
            Byte protocolCode = null;
            byte[] payload = null;
            packetLength = buffer.getUnsignedShort(++packetOffset);
            packetOffset += 2;
            while (packetOffset < offset + packetLength) {
                byte type = buffer.getByte(packetOffset);
                int length = buffer.getUnsignedShort(++packetOffset) - 3;
                packetOffset += 2;
                switch (type) {
                    case 1: {
                        millis = buffer.getLong(packetOffset);
                        break;
                    }
                    case 2: {
                        nanos = buffer.getInt(packetOffset);
                        break;
                    }
                    case 3: {
                        srcAddr = buffer.getBytes(packetOffset, packetOffset + length);
                        break;
                    }
                    case 4: {
                        dstAddr = buffer.getBytes(packetOffset, packetOffset + length);
                        break;
                    }
                    case 5: {
                        srcPort = buffer.getUnsignedShort(packetOffset);
                        break;
                    }
                    case 6: {
                        dstPort = buffer.getUnsignedShort(packetOffset);
                        break;
                    }
                    case 7: {
                        protocolCode = buffer.getByte(packetOffset);
                        break;
                    }
                    case 8: {
                        payload = buffer.getBytes(packetOffset, packetOffset + length);
                    }
                }
                packetOffset += length;
            }
            Packet $this$decode_u24lambda_u244 = packet = new Packet();
            boolean bl = false;
            Long l = millis;
            Intrinsics.checkNotNull(l);
            $this$decode_u24lambda_u244.setCreatedAt(((Number)l).longValue());
            Integer n = nanos;
            Intrinsics.checkNotNull(n);
            $this$decode_u24lambda_u244.setNanos(((Number)n).intValue());
            $this$decode_u24lambda_u244.setType(packetType);
            Intrinsics.checkNotNull(payload);
            $this$decode_u24lambda_u244.setPayload(payload);
            if (packetType == 1) {
                void $this$decode_u24lambda_u244_u24lambda_u243;
                Address $this$decode_u24lambda_u244_u24lambda_u242;
                Address address;
                Address address2 = address = new Address();
                Packet packet2 = $this$decode_u24lambda_u244;
                boolean bl2 = false;
                Intrinsics.checkNotNull(srcAddr);
                $this$decode_u24lambda_u244_u24lambda_u242.setAddr(IpUtil.INSTANCE.convertToString(srcAddr));
                Integer n2 = srcPort;
                Intrinsics.checkNotNull(n2);
                $this$decode_u24lambda_u244_u24lambda_u242.setPort(((Number)n2).intValue());
                packet2.setSrcAddr(address);
                $this$decode_u24lambda_u244_u24lambda_u242 = address = new Address();
                packet2 = $this$decode_u24lambda_u244;
                boolean bl3 = false;
                Intrinsics.checkNotNull(dstAddr);
                $this$decode_u24lambda_u244_u24lambda_u243.setAddr(IpUtil.INSTANCE.convertToString(dstAddr));
                Integer n3 = dstPort;
                Intrinsics.checkNotNull(n3);
                $this$decode_u24lambda_u244_u24lambda_u243.setPort(((Number)n3).intValue());
                packet2.setDstAddr(address);
                Byte by = protocolCode;
                Intrinsics.checkNotNull(by);
                $this$decode_u24lambda_u244.setProtocolCode(((Number)by).byteValue());
            }
            $this$decode_u24lambda_u244.setSource("sip3");
            Packet packet3 = packet;
            packets.add(packet3);
        }
        return packets;
    }

    private static final void start$lambda$0(Decoder this$0, Message event) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Pair pair = (Pair)event.body();
        Address sender = (Address)pair.component1();
        Buffer buffer = (Buffer)pair.component2();
        try {
            this$0.decode(sender, buffer);
        }
        catch (Exception e) {
            this$0.logger.error(e, (Function0<? extends Object>)start.1.1.INSTANCE);
            this$0.logger.debug((Function0<? extends Object>)new Function0<Object>(buffer){
                final /* synthetic */ Buffer $buffer;
                {
                    this.$buffer = $buffer;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Packet buffer:\n" + ByteBufUtil.prettyHexDump(this.$buffer.getByteBuf());
                }
            });
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/sip3/salto/ce/decoder/Decoder$Companion;", "", "()V", "HEADER_LENGTH", "", "sip3-salto-ce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

