/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.CommonLogger;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.parser.MessageParser;
import gov.nist.javax.sip.parser.Pipeline;
import gov.nist.javax.sip.parser.PostParseExecutorServices;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.stack.ConnectionOrientedMessageChannel;
import gov.nist.javax.sip.stack.QueuedMessageDispatchBase;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;

public final class PipelinedMsgParser
implements Runnable {
    private static StackLogger logger = CommonLogger.getLogger(PipelinedMsgParser.class);
    private static final String CRLF = "\r\n";
    protected SIPMessageListener sipMessageListener;
    private Thread mythread;
    private Pipeline rawInputStream;
    private int maxMessageSize;
    private int sizeCounter;
    private SIPTransactionStack sipStack;
    private MessageParser smp = null;
    private ConcurrentHashMap<String, CallIDOrderingStructure> messagesOrderingMap = new ConcurrentHashMap();
    boolean isRunning = false;
    private static int uid = 0;

    protected PipelinedMsgParser() {
    }

    private static synchronized int getNewUid() {
        return uid++;
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, SIPMessageListener sipMessageListener, Pipeline in, boolean debug, int maxMessageSize) {
        this();
        this.sipStack = sipStack;
        this.smp = sipStack.getMessageParserFactory().createMessageParser(sipStack);
        this.sipMessageListener = sipMessageListener;
        this.rawInputStream = in;
        this.maxMessageSize = maxMessageSize;
        this.mythread = new Thread(this);
        this.mythread.setName("PipelineThread-" + PipelinedMsgParser.getNewUid());
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, SIPMessageListener mhandler, Pipeline in, int maxMsgSize) {
        this(sipStack, mhandler, in, false, maxMsgSize);
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, Pipeline in) {
        this(sipStack, null, in, false, 0);
    }

    public void processInput() {
        this.mythread.start();
    }

    protected Object clone() {
        PipelinedMsgParser p = new PipelinedMsgParser();
        p.rawInputStream = this.rawInputStream;
        p.sipMessageListener = this.sipMessageListener;
        Thread mythread = new Thread(p);
        mythread.setName("PipelineThread");
        return p;
    }

    public void setMessageListener(SIPMessageListener mlistener) {
        this.sipMessageListener = mlistener;
    }

    private String readLine(InputStream inputStream2) throws IOException {
        int increment;
        int counter = 0;
        int bufferSize = increment = 1024;
        byte[] lineBuffer = new byte[bufferSize];
        byte[] crlfBuffer = new byte[2];
        int crlfCounter = 0;
        while (true) {
            int i2;
            if ((i2 = inputStream2.read()) == -1) {
                throw new IOException("End of stream");
            }
            char ch = (char)(i2 & 0xFF);
            if (this.maxMessageSize > 0) {
                --this.sizeCounter;
                if (this.sizeCounter <= 0) {
                    throw new IOException("Max size exceeded!");
                }
            }
            if (ch != '\r') {
                lineBuffer[counter++] = (byte)(i2 & 0xFF);
            } else if (counter == 0) {
                crlfBuffer[crlfCounter++] = 13;
            }
            if (ch == '\n') {
                if (counter != 1 || crlfCounter <= 0) break;
                crlfBuffer[crlfCounter++] = 10;
                break;
            }
            if (counter != bufferSize) continue;
            byte[] tempBuffer = new byte[bufferSize + increment];
            System.arraycopy(lineBuffer, 0, tempBuffer, 0, bufferSize);
            bufferSize += increment;
            lineBuffer = tempBuffer;
        }
        if (counter == 1 && crlfCounter > 0) {
            return new String(crlfBuffer, 0, crlfCounter, "UTF-8");
        }
        return new String(lineBuffer, 0, counter, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Pipeline inputStream2 = this.rawInputStream;
        StackLogger stackLogger = logger;
        try {
            this.isRunning = true;
            while (this.isRunning) {
                String clString;
                SIPMessage sipMessage;
                block74: {
                    String line1;
                    this.sizeCounter = this.maxMessageSize;
                    StringBuilder inputBuffer = new StringBuilder();
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Starting to parse.");
                    }
                    String line2 = null;
                    boolean isPreviousLineCRLF = false;
                    try {
                        while (true) {
                            if ((line1 = this.readLine(inputStream2)).equals("\n")) {
                                if (!logger.isLoggingEnabled(32)) continue;
                                logger.logDebug("Discarding blank line");
                                continue;
                            }
                            if (!CRLF.equals(line1)) break;
                            if (isPreviousLineCRLF) {
                                if (logger.isLoggingEnabled(32)) {
                                    logger.logDebug("KeepAlive Double CRLF received, sending single CRLF as defined per RFC 5626 Section 4.4.1");
                                    logger.logDebug("~~~ setting isPreviousLineCRLF=false");
                                }
                                isPreviousLineCRLF = false;
                                try {
                                    this.sipMessageListener.sendSingleCLRF();
                                }
                                catch (Exception e) {
                                    logger.logError("A problem occured while trying to send a single CLRF in response to a double CLRF", e);
                                }
                                continue;
                            }
                            isPreviousLineCRLF = true;
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("Received CRLF");
                            }
                            if (this.sipMessageListener == null || !(this.sipMessageListener instanceof ConnectionOrientedMessageChannel)) continue;
                            ((ConnectionOrientedMessageChannel)this.sipMessageListener).cancelPingKeepAliveTimeoutTaskIfStarted();
                        }
                    }
                    catch (IOException ex) {
                        if (PostParseExecutorServices.getPostParseExecutor() != null && this.isRunning) {
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("waiting for messagesOrderingMap " + this + " threadname " + this.mythread.getName());
                            }
                            ConcurrentHashMap<String, CallIDOrderingStructure> concurrentHashMap = this.messagesOrderingMap;
                            // MONITORENTER : concurrentHashMap
                            try {
                                this.messagesOrderingMap.wait(64000L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("got notified for messagesOrderingMap " + this + " threadname " + this.mythread.getName());
                            }
                        }
                        this.rawInputStream.stopTimer();
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("thread ending for threadname " + this.mythread.getName());
                        }
                        if (logger.isLoggingEnabled(32)) {
                            logger.logStackTrace(32);
                        }
                        try {
                            this.cleanMessageOrderingMap();
                            if (inputStream2.isClosed()) return;
                            inputStream2.close();
                            return;
                        }
                        catch (IOException e) {
                            InternalErrorHandler.handleException(e);
                        }
                        return;
                    }
                    inputBuffer.append(line1);
                    this.rawInputStream.startTimer();
                    int bytesRead = 0;
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Reading Input stream.");
                    }
                    try {
                        do {
                            line2 = this.readLine(inputStream2);
                            if (this.maxMessageSize > 0 && (bytesRead += line2.length()) > this.maxMessageSize / 2) {
                                throw new IOException("Pre-content-length headers size exceeded. The size of the message of the headers prior to Content-Length is too large. This must be an invalid message. Limit is MAX_MESSAGE_SIZE/2=" + this.maxMessageSize / 2);
                            }
                            inputBuffer.append(line2);
                        } while (!line2.trim().equals(""));
                    }
                    catch (IOException ex) {
                        if (PostParseExecutorServices.getPostParseExecutor() != null && this.isRunning) {
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("waiting for messagesOrderingMap " + this + " threadname " + this.mythread.getName());
                            }
                            ConcurrentHashMap<String, CallIDOrderingStructure> e = this.messagesOrderingMap;
                            // MONITORENTER : e
                            try {
                                this.messagesOrderingMap.wait(64000L);
                            }
                            catch (InterruptedException e2) {
                                // empty catch block
                            }
                            if (logger.isLoggingEnabled(32)) {
                                logger.logDebug("got notified for messagesOrderingMap " + this + " threadname " + this.mythread.getName());
                            }
                        }
                        this.rawInputStream.stopTimer();
                        if (logger.isLoggingEnabled(32)) {
                            logger.logDebug("thread ending for threadname " + this.mythread.getName());
                        }
                        if (logger.isLoggingEnabled(32)) {
                            logger.logStackTrace(32);
                        }
                        try {
                            this.cleanMessageOrderingMap();
                            if (inputStream2.isClosed()) return;
                            inputStream2.close();
                            return;
                        }
                        catch (IOException e) {
                            InternalErrorHandler.handleException(e);
                        }
                        return;
                    }
                    this.rawInputStream.stopTimer();
                    inputBuffer.append(line2);
                    sipMessage = null;
                    try {
                        byte[] inputBufferBytes;
                        if (stackLogger.isLoggingEnabled(32)) {
                            stackLogger.logDebug("About to parse : " + inputBuffer.toString());
                        }
                        try {
                            inputBufferBytes = inputBuffer.toString().getBytes("UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            inputBufferBytes = inputBuffer.toString().getBytes();
                        }
                        sipMessage = this.smp.parseSIPMessage(inputBufferBytes, false, false, this.sipMessageListener);
                        if (sipMessage == null) {
                            this.rawInputStream.stopTimer();
                        }
                        break block74;
                    }
                    catch (ParseException ex) {
                        if (!logger.isLoggingEnabled(32)) continue;
                        logger.logDebug("Detected a parsing issue " + inputBuffer.toString() + " " + ex.getMessage());
                    }
                    continue;
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Completed parsing message");
                }
                if ((clString = sipMessage.getHeaderAsFormattedString("Content-Length")).length() > 30) {
                    throw new RuntimeException("Bad content lenght header " + clString);
                }
                ContentLength cl = (ContentLength)sipMessage.getContentLength();
                int contentLength = 0;
                contentLength = cl != null ? cl.getContentLength() : 0;
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Content length = " + contentLength);
                }
                if (this.maxMessageSize > 0 && contentLength > this.maxMessageSize) {
                    throw new RuntimeException("Max content size Exceeded! :" + contentLength + " allowed max size is " + this.maxMessageSize);
                }
                if (contentLength == 0) {
                    sipMessage.removeContent();
                } else if (this.maxMessageSize == 0 || contentLength < this.sizeCounter) {
                    byte[] message_body = new byte[contentLength];
                    int nread = 0;
                    while (nread < contentLength) {
                        this.rawInputStream.startTimer();
                        try {
                            int readlength = inputStream2.read(message_body, nread, contentLength - nread);
                            if (readlength <= 0) break;
                            nread += readlength;
                        }
                        catch (IOException ex) {
                            stackLogger.logError("Exception Reading Content", ex);
                            break;
                        }
                        finally {
                            this.rawInputStream.stopTimer();
                        }
                    }
                    sipMessage.setMessageContent(message_body);
                }
                if (this.sipMessageListener == null) continue;
                try {
                    CallIDOrderingStructure newCallIDOrderingStructure;
                    if (PostParseExecutorServices.getPostParseExecutor() == null) {
                        if (this.sipStack.sipEventInterceptor != null) {
                            this.sipStack.sipEventInterceptor.beforeMessage(sipMessage);
                        }
                        this.sipMessageListener.processMessage(sipMessage);
                        if (this.sipStack.sipEventInterceptor == null) continue;
                        this.sipStack.sipEventInterceptor.afterMessage(sipMessage);
                        continue;
                    }
                    String callId = sipMessage.getCallId().getCallId();
                    CallIDOrderingStructure orderingStructure = this.messagesOrderingMap.get(callId);
                    if (orderingStructure == null && (orderingStructure = this.messagesOrderingMap.putIfAbsent(callId, newCallIDOrderingStructure = new CallIDOrderingStructure())) == null) {
                        orderingStructure = newCallIDOrderingStructure;
                        if (stackLogger.isLoggingEnabled(32)) {
                            stackLogger.logDebug("new CallIDOrderingStructure added for message " + sipMessage);
                        }
                    }
                    CallIDOrderingStructure callIDOrderingStructure = orderingStructure;
                    callIDOrderingStructure.getMessagesForCallID().offer(sipMessage);
                    PostParseExecutorServices.getPostParseExecutor().execute(new Dispatch(callIDOrderingStructure, callId));
                }
                catch (Exception ex) {
                    return;
                }
            }
            return;
        }
        finally {
            try {
                this.cleanMessageOrderingMap();
                if (!inputStream2.isClosed()) {
                    inputStream2.close();
                }
            }
            catch (IOException e) {
                InternalErrorHandler.handleException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block7: {
            this.isRunning = false;
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Closing pipelinedmsgparser " + this + " threadname " + this.mythread.getName());
            }
            try {
                this.rawInputStream.close();
            }
            catch (IOException ex) {
                if (!logger.isLoggingEnabled(32)) break block7;
                logger.logDebug("Couldn't close the rawInputStream " + this + " threadname " + this.mythread.getName() + " already closed ? " + this.rawInputStream.isClosed());
            }
        }
        if (PostParseExecutorServices.getPostParseExecutor() != null) {
            this.cleanMessageOrderingMap();
            Thread thread2 = this.mythread;
            synchronized (thread2) {
                this.mythread.notifyAll();
                this.mythread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanMessageOrderingMap() {
        this.messagesOrderingMap.clear();
        ConcurrentHashMap<String, CallIDOrderingStructure> concurrentHashMap = this.messagesOrderingMap;
        synchronized (concurrentHashMap) {
            this.messagesOrderingMap.notifyAll();
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("cleaned the messagesOrderingMap " + this + " threadname " + this.mythread.getName());
        }
    }

    class CallIDOrderingStructure {
        private Semaphore semaphore = new Semaphore(1, true);
        private Queue<SIPMessage> messagesForCallID = new ConcurrentLinkedQueue<SIPMessage>();

        public Semaphore getSemaphore() {
            return this.semaphore;
        }

        public Queue<SIPMessage> getMessagesForCallID() {
            return this.messagesForCallID;
        }
    }

    public class Dispatch
    implements Runnable,
    QueuedMessageDispatchBase {
        CallIDOrderingStructure callIDOrderingStructure;
        String callId;
        long time;

        public Dispatch(CallIDOrderingStructure callIDOrderingStructure, String callId) {
            this.callIDOrderingStructure = callIDOrderingStructure;
            this.callId = callId;
            this.time = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Semaphore semaphore = this.callIDOrderingStructure.getSemaphore();
            Queue<SIPMessage> messagesForCallID = this.callIDOrderingStructure.getMessagesForCallID();
            if (((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor != null) {
                ((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor.beforeMessage(messagesForCallID.peek());
            }
            try {
                semaphore.acquire();
            }
            catch (InterruptedException e) {
                logger.logError("Semaphore acquisition for callId " + this.callId + " interrupted", e);
            }
            SIPMessage message = messagesForCallID.poll();
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("semaphore acquired for message " + message);
            }
            try {
                PipelinedMsgParser.this.sipMessageListener.processMessage(message);
            }
            catch (Exception e) {
                logger.logError("Error occured processing message", e);
            }
            finally {
                if (messagesForCallID.size() <= 0) {
                    PipelinedMsgParser.this.messagesOrderingMap.remove(this.callId);
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("CallIDOrderingStructure removed for message " + this.callId);
                    }
                }
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("releasing semaphore for message " + message);
                }
                semaphore.release();
                if (PipelinedMsgParser.this.messagesOrderingMap.isEmpty()) {
                    ConcurrentHashMap concurrentHashMap = PipelinedMsgParser.this.messagesOrderingMap;
                    synchronized (concurrentHashMap) {
                        PipelinedMsgParser.this.messagesOrderingMap.notify();
                    }
                }
                if (((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor != null) {
                    ((PipelinedMsgParser)PipelinedMsgParser.this).sipStack.sipEventInterceptor.afterMessage(message);
                }
            }
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("dispatch task done on " + message + " threadname " + PipelinedMsgParser.this.mythread.getName());
            }
        }

        @Override
        public long getReceptionTime() {
            return this.time;
        }
    }
}

