/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.message;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.SIPHeaderList;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.MessageFactoryImpl;
import gov.nist.javax.sip.message.RequestExt;
import gov.nist.javax.sip.message.SIPDuplicateHeaderException;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sip.SipException;
import javax.sip.address.URI;
import javax.sip.header.Header;
import javax.sip.header.ServerHeader;
import javax.sip.message.Request;

public class SIPRequest
extends SIPMessage
implements Request,
RequestExt {
    private static final long serialVersionUID = 3360720013577322927L;
    private static final String DEFAULT_USER = "ip";
    private static final String DEFAULT_TRANSPORT = "udp";
    private transient Object transactionPointer;
    protected RequestLine requestLine;
    private transient Object messageChannel;
    private transient Object inviteTransaction;
    private static final Set<String> targetRefreshMethods = new HashSet<String>();
    private static final Map<String, String> nameTable = new ConcurrentHashMap<String, String>(15);
    protected static final Set<String> headersToIncludeInResponse = new HashSet<String>(0);

    private static void putName(String name) {
        nameTable.put(name, name);
    }

    public static boolean isTargetRefresh(String ucaseMethod) {
        return targetRefreshMethods.contains(ucaseMethod);
    }

    public static boolean isDialogCreating(String ucaseMethod) {
        return SIPTransactionStack.isDialogCreated(ucaseMethod);
    }

    public static String getCannonicalName(String method) {
        if (nameTable.containsKey(method)) {
            return nameTable.get(method);
        }
        return method;
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public void setRequestLine(RequestLine requestLine) {
        this.requestLine = requestLine;
    }

    @Override
    public String debugDump() {
        String superstring = super.debugDump();
        this.stringRepresentation = "";
        this.sprint(SIPRequest.class.getName());
        this.sprint("{");
        if (this.requestLine != null) {
            this.sprint(this.requestLine.debugDump());
        }
        this.sprint(superstring);
        this.sprint("}");
        return this.stringRepresentation;
    }

    public void checkHeaders() throws ParseException {
        String method;
        String prefix = "Missing a required header : ";
        if (this.getCSeq() == null) {
            throw new ParseException(prefix + "CSeq", 0);
        }
        if (this.getTo() == null) {
            throw new ParseException(prefix + "To", 0);
        }
        if (this.callIdHeader == null || this.callIdHeader.getCallId() == null || this.callIdHeader.getCallId().equals("")) {
            throw new ParseException(prefix + "Call-ID", 0);
        }
        if (this.getFrom() == null) {
            throw new ParseException(prefix + "From", 0);
        }
        if (this.getViaHeaders() == null) {
            throw new ParseException(prefix + "Via", 0);
        }
        if (this.getMaxForwards() == null) {
            throw new ParseException(prefix + "Max-Forwards", 0);
        }
        if (this.getTopmostVia() == null) {
            throw new ParseException("No via header in request! ", 0);
        }
        if (this.getMethod().equals("NOTIFY")) {
            if (this.getHeader("Subscription-State") == null) {
                throw new ParseException(prefix + "Subscription-State", 0);
            }
            if (this.getFromHeader().getTag() != null && this.getToHeader().getTag() != null && this.getHeader("Event") == null) {
                throw new ParseException(prefix + "Event", 0);
            }
        } else if (this.getMethod().equals("PUBLISH") && this.getHeader("Event") == null) {
            throw new ParseException(prefix + "Event", 0);
        }
        if (SIPTransactionStack.isDialogCreated(method = this.requestLine.getMethod()) && this.getContactHeader() == null && this.getToTag() == null) {
            throw new ParseException(prefix + "Contact", 0);
        }
        if (this.requestLine != null && method != null && this.getCSeq().getMethod() != null && method.compareTo(this.getCSeq().getMethod()) != 0) {
            throw new ParseException("CSEQ method mismatch with  Request-Line ", 0);
        }
    }

    protected void setDefaults() {
        if (this.requestLine == null) {
            return;
        }
        String method = this.requestLine.getMethod();
        if (method == null) {
            return;
        }
        GenericURI u = this.requestLine.getUri();
        if (u == null) {
            return;
        }
        if ((method.compareTo("REGISTER") == 0 || method.compareTo("INVITE") == 0) && u instanceof SipUri) {
            SipUri sipUri = (SipUri)u;
            sipUri.setUserParam(DEFAULT_USER);
            try {
                sipUri.setTransportParam(DEFAULT_TRANSPORT);
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
    }

    protected void setRequestLineDefaults() {
        CSeq cseq;
        String method = this.requestLine.getMethod();
        if (method == null && (cseq = (CSeq)this.getCSeq()) != null) {
            method = SIPRequest.getCannonicalName(cseq.getMethod());
            this.requestLine.setMethod(method);
        }
    }

    @Override
    public URI getRequestURI() {
        if (this.requestLine == null) {
            return null;
        }
        return this.requestLine.getUri();
    }

    @Override
    public void setRequestURI(URI uri) {
        if (uri == null) {
            throw new NullPointerException("Null request URI");
        }
        if (this.requestLine == null) {
            this.requestLine = new RequestLine();
        }
        this.requestLine.setUri((GenericURI)uri);
        this.nullRequest = false;
    }

    @Override
    public void setMethod(String method) {
        if (method == null) {
            throw new IllegalArgumentException("null method");
        }
        if (this.requestLine == null) {
            this.requestLine = new RequestLine();
        }
        String meth = SIPRequest.getCannonicalName(method);
        this.requestLine.setMethod(meth);
        if (this.cSeqHeader != null) {
            try {
                this.cSeqHeader.setMethod(meth);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getMethod() {
        if (this.requestLine == null) {
            return null;
        }
        return this.requestLine.getMethod();
    }

    @Override
    public String encode() {
        String retval;
        if (this.requestLine != null) {
            this.setRequestLineDefaults();
            retval = this.requestLine.encode() + super.encode();
        } else {
            retval = this.isNullRequest() ? "\r\n\r\n" : super.encode();
        }
        return retval;
    }

    @Override
    public StringBuilder encodeMessage(StringBuilder retval) {
        if (this.requestLine != null) {
            this.setRequestLineDefaults();
            this.requestLine.encode(retval);
            this.encodeSIPHeaders(retval);
        } else if (this.isNullRequest()) {
            retval.append("\r\n\r\n");
        } else {
            retval = this.encodeSIPHeaders(retval);
        }
        return retval;
    }

    @Override
    public String toString() {
        return this.encode();
    }

    @Override
    public Object clone() {
        SIPRequest retval = (SIPRequest)super.clone();
        retval.transactionPointer = null;
        if (this.requestLine != null) {
            retval.requestLine = (RequestLine)this.requestLine.clone();
        }
        return retval;
    }

    @Override
    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        SIPRequest that = (SIPRequest)other;
        return this.requestLine.equals(that.requestLine) && super.equals(other);
    }

    public LinkedList getMessageAsEncodedStrings() {
        LinkedList<String> retval = super.getMessageAsEncodedStrings();
        if (this.requestLine != null) {
            this.setRequestLineDefaults();
            retval.addFirst(this.requestLine.encode());
        }
        return retval;
    }

    @Override
    public boolean match(Object matchObj) {
        if (matchObj == null) {
            return true;
        }
        if (!matchObj.getClass().equals(this.getClass())) {
            return false;
        }
        if (matchObj == this) {
            return true;
        }
        SIPRequest that = (SIPRequest)matchObj;
        RequestLine rline = that.requestLine;
        if (this.requestLine == null && rline != null) {
            return false;
        }
        if (this.requestLine == rline) {
            return super.match(matchObj);
        }
        return this.requestLine.match(that.requestLine) && super.match(matchObj);
    }

    @Override
    public byte[] encodeAsBytes(String transport) {
        if (this.isNullRequest()) {
            return "\r\n\r\n".getBytes();
        }
        if (this.requestLine == null) {
            return new byte[0];
        }
        byte[] rlbytes = null;
        if (this.requestLine != null) {
            try {
                rlbytes = this.requestLine.encode().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException(ex);
            }
        }
        byte[] superbytes = super.encodeAsBytes(transport);
        byte[] retval = new byte[rlbytes.length + superbytes.length];
        System.arraycopy(rlbytes, 0, retval, 0, rlbytes.length);
        System.arraycopy(superbytes, 0, retval, rlbytes.length, superbytes.length);
        return retval;
    }

    public SIPResponse createResponse(int statusCode) {
        String reasonPhrase = SIPResponse.getReasonPhrase(statusCode);
        return this.createResponse(statusCode, reasonPhrase);
    }

    public SIPResponse createResponse(int statusCode, String reasonPhrase) {
        ServerHeader server;
        SIPResponse newResponse = new SIPResponse();
        try {
            newResponse.setStatusCode(statusCode);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Bad code " + statusCode);
        }
        if (reasonPhrase != null) {
            newResponse.setReasonPhrase(reasonPhrase);
        } else {
            newResponse.setReasonPhrase(SIPResponse.getReasonPhrase(statusCode));
        }
        for (String headerName : headersToIncludeInResponse) {
            SIPHeader nextHeader = (SIPHeader)this.headerTable.get(headerName);
            if (nextHeader == null || nextHeader instanceof RecordRouteList && (!(nextHeader instanceof RecordRouteList) || !this.mustCopyRR(statusCode))) continue;
            try {
                newResponse.attachHeader((SIPHeader)nextHeader.clone(), false);
            }
            catch (SIPDuplicateHeaderException e) {
                e.printStackTrace();
            }
        }
        if (MessageFactoryImpl.getDefaultServerHeader() != null) {
            newResponse.setHeader(MessageFactoryImpl.getDefaultServerHeader());
        }
        if ((server = MessageFactoryImpl.getDefaultServerHeader()) != null) {
            newResponse.setHeader(server);
        }
        return newResponse;
    }

    protected final boolean mustCopyRR(int code) {
        if (code > 100 && code < 300) {
            return SIPRequest.isDialogCreating(this.getMethod()) && this.getToTag() == null;
        }
        return false;
    }

    public SIPRequest createCancelRequest() throws SipException {
        if (!this.getMethod().equals("INVITE")) {
            throw new SipException("Attempt to create CANCEL for " + this.getMethod());
        }
        SIPRequest cancel = new SIPRequest();
        cancel.setRequestLine((RequestLine)this.requestLine.clone());
        cancel.setMethod("CANCEL");
        cancel.setHeader((Header)this.callIdHeader.clone());
        cancel.setHeader((Header)this.toHeader.clone());
        cancel.setHeader((Header)this.cSeqHeader.clone());
        try {
            cancel.getCSeq().setMethod("CANCEL");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        cancel.setHeader((Header)this.fromHeader.clone());
        cancel.addFirst((Header)this.getTopmostVia().clone());
        cancel.setHeader((Header)this.maxForwardsHeader.clone());
        if (this.getRouteHeaders() != null) {
            cancel.setHeader((Header)((SIPHeaderList)this.getRouteHeaders().clone()));
        }
        if (MessageFactoryImpl.getDefaultUserAgentHeader() != null) {
            cancel.setHeader(MessageFactoryImpl.getDefaultUserAgentHeader());
        }
        return cancel;
    }

    public SIPRequest createAckRequest(To responseToHeader) {
        SIPRequest newRequest = (SIPRequest)this.clone();
        newRequest.setMethod("ACK");
        newRequest.removeHeader("Route");
        newRequest.removeHeader("Proxy-Authorization");
        newRequest.removeContent();
        newRequest.removeHeader("Content-Type");
        try {
            newRequest.getCSeq().setMethod("ACK");
        }
        catch (ParseException e) {
            // empty catch block
        }
        if (responseToHeader != null) {
            newRequest.setTo(responseToHeader);
        }
        newRequest.removeHeader("Contact");
        newRequest.removeHeader("Expires");
        ViaList via = newRequest.getViaHeaders();
        if (via != null && via.size() > 1) {
            for (int i2 = 2; i2 < via.size(); ++i2) {
                via.remove(i2);
            }
        }
        if (MessageFactoryImpl.getDefaultUserAgentHeader() != null) {
            newRequest.setHeader(MessageFactoryImpl.getDefaultUserAgentHeader());
        }
        return newRequest;
    }

    public final SIPRequest createErrorAck(To responseToHeader) throws SipException, ParseException {
        SIPRequest newRequest = new SIPRequest();
        newRequest.setRequestLine((RequestLine)this.requestLine.clone());
        newRequest.setMethod("ACK");
        newRequest.setHeader((Header)this.callIdHeader.clone());
        newRequest.setHeader((Header)this.maxForwardsHeader.clone());
        newRequest.setHeader((Header)this.fromHeader.clone());
        newRequest.setHeader((Header)responseToHeader.clone());
        newRequest.addFirst((Header)this.getTopmostVia().clone());
        newRequest.setHeader((Header)this.cSeqHeader.clone());
        newRequest.getCSeq().setMethod("ACK");
        if (this.getRouteHeaders() != null) {
            newRequest.setHeader((SIPHeaderList)this.getRouteHeaders().clone());
        }
        if (MessageFactoryImpl.getDefaultUserAgentHeader() != null) {
            newRequest.setHeader(MessageFactoryImpl.getDefaultUserAgentHeader());
        }
        return newRequest;
    }

    public String getViaHost() {
        Via via = (Via)this.getViaHeaders().getFirst();
        return via.getHost();
    }

    public int getViaPort() {
        Via via = (Via)this.getViaHeaders().getFirst();
        if (via.hasPort()) {
            return via.getPort();
        }
        return 5060;
    }

    @Override
    public String getFirstLine() {
        if (this.requestLine == null) {
            return null;
        }
        return this.requestLine.encode();
    }

    @Override
    public void setSIPVersion(String sipVersion) throws ParseException {
        if (sipVersion == null || !sipVersion.equalsIgnoreCase("SIP/2.0")) {
            throw new ParseException("sipVersion", 0);
        }
        this.requestLine.setSipVersion(sipVersion);
    }

    @Override
    public String getSIPVersion() {
        return this.requestLine.getSipVersion();
    }

    public Object getTransaction() {
        return this.transactionPointer;
    }

    public void setTransaction(Object transaction2) {
        this.transactionPointer = transaction2;
    }

    public Object getMessageChannel() {
        return this.messageChannel;
    }

    public void setMessageChannel(Object messageChannel) {
        this.messageChannel = messageChannel;
    }

    public String getMergeId() {
        String fromTag = this.getFromTag();
        String cseq = this.cSeqHeader.toString();
        String callId = this.callIdHeader.getCallId();
        String requestUri = this.getRequestURI().toString();
        if (fromTag != null) {
            return requestUri + ":" + fromTag + ":" + cseq + ":" + callId;
        }
        return null;
    }

    public void setInviteTransaction(Object inviteTransaction) {
        this.inviteTransaction = inviteTransaction;
    }

    public Object getInviteTransaction() {
        return this.inviteTransaction;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
    }

    static {
        targetRefreshMethods.add("INVITE");
        targetRefreshMethods.add("UPDATE");
        targetRefreshMethods.add("SUBSCRIBE");
        targetRefreshMethods.add("NOTIFY");
        targetRefreshMethods.add("REFER");
        SIPRequest.putName("INVITE");
        SIPRequest.putName("BYE");
        SIPRequest.putName("CANCEL");
        SIPRequest.putName("ACK");
        SIPRequest.putName("PRACK");
        SIPRequest.putName("INFO");
        SIPRequest.putName("MESSAGE");
        SIPRequest.putName("NOTIFY");
        SIPRequest.putName("OPTIONS");
        SIPRequest.putName("PRACK");
        SIPRequest.putName("PUBLISH");
        SIPRequest.putName("REFER");
        SIPRequest.putName("REGISTER");
        SIPRequest.putName("SUBSCRIBE");
        SIPRequest.putName("UPDATE");
        headersToIncludeInResponse.add("From".toLowerCase());
        headersToIncludeInResponse.add("To".toLowerCase());
        headersToIncludeInResponse.add("Via".toLowerCase());
        headersToIncludeInResponse.add("Record-Route".toLowerCase());
        headersToIncludeInResponse.add("Call-ID".toLowerCase());
        headersToIncludeInResponse.add("CSeq".toLowerCase());
        headersToIncludeInResponse.add("Timestamp".toLowerCase());
    }
}

