/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.MongoCredential;
import com.mongodb.internal.Locks;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MongoCredentialWithCache {
    private final MongoCredential credential;
    private final Cache cache;

    public MongoCredentialWithCache(MongoCredential credential) {
        this(credential, null);
    }

    public MongoCredentialWithCache(MongoCredential credential, Cache cache2) {
        this.credential = credential;
        this.cache = cache2 != null ? cache2 : new Cache();
    }

    public MongoCredentialWithCache withMechanism(AuthenticationMechanism mechanism) {
        return new MongoCredentialWithCache(this.credential.withMechanism(mechanism), this.cache);
    }

    public AuthenticationMechanism getAuthenticationMechanism() {
        return this.credential.getAuthenticationMechanism();
    }

    public MongoCredential getCredential() {
        return this.credential;
    }

    public <T> T getFromCache(Object key, Class<T> clazz) {
        return clazz.cast(this.cache.get(key));
    }

    public void putInCache(Object key, Object value) {
        this.cache.set(key, value);
    }

    public Lock getLock() {
        return this.cache.lock;
    }

    static class Cache {
        private final ReentrantLock lock = new ReentrantLock();
        private Object cacheKey;
        private Object cacheValue;

        Cache() {
        }

        Object get(Object key) {
            return Locks.withLock((Lock)this.lock, () -> {
                if (this.cacheKey != null && this.cacheKey.equals(key)) {
                    return this.cacheValue;
                }
                return null;
            });
        }

        void set(Object key, Object value) {
            Locks.withLock((Lock)this.lock, () -> {
                this.cacheKey = key;
                this.cacheValue = value;
            });
        }
    }
}

