/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.sdp.ice.attributes.parser;

import java.util.regex.Pattern;
import org.restcomm.media.sdp.SdpException;
import org.restcomm.media.sdp.SdpParser;
import org.restcomm.media.sdp.ice.attributes.CandidateAttribute;

public class CandidateAttributeParser
implements SdpParser<CandidateAttribute> {
    private static final String REGEX = "^a=candidate:\\w+\\s\\d\\s\\w+\\s\\d+\\s[0-9\\.]+\\s\\d+\\s(typ)\\s\\w+(\\stcptype\\s\\w+)?(\\s(raddr)\\s[0-9\\.]+\\s(rport)\\s\\d+)?\\s(generation)\\s\\d+$";
    private static final Pattern PATTERN = Pattern.compile("^a=candidate:\\w+\\s\\d\\s\\w+\\s\\d+\\s[0-9\\.]+\\s\\d+\\s(typ)\\s\\w+(\\stcptype\\s\\w+)?(\\s(raddr)\\s[0-9\\.]+\\s(rport)\\s\\d+)?\\s(generation)\\s\\d+$");

    @Override
    public boolean canParse(String sdp) {
        if (sdp == null || sdp.isEmpty()) {
            return false;
        }
        return PATTERN.matcher(sdp.trim()).matches();
    }

    @Override
    public CandidateAttribute parse(String sdp) throws SdpException {
        try {
            String[] values2 = sdp.trim().substring(12).split(" ");
            int index = 0;
            String foundation = values2[index++];
            short componentId = Short.parseShort(values2[index++]);
            String protocol = values2[index++];
            long priority = Long.parseLong(values2[index++]);
            String address = values2[index++];
            int port = Integer.parseInt(values2[index++]);
            int n = ++index;
            ++index;
            String type = values2[n];
            if (!CandidateAttribute.isCandidateTypeValid(type)) {
                throw new IllegalArgumentException("Unrecognized candidate type: " + type);
            }
            String relatedAddress = null;
            int relatedPort = 0;
            if (!"host".equals(type)) {
                int n2 = ++index;
                ++index;
                relatedAddress = values2[n2];
                int n3 = ++index;
                ++index;
                relatedPort = Integer.parseInt(values2[n3]);
            }
            String tcptype = null;
            if (protocol.equalsIgnoreCase("tcp")) {
                int n4 = ++index;
                ++index;
                tcptype = values2[n4];
            }
            int generation = 0;
            if (++index == values2.length - 1) {
                generation = Integer.parseInt(values2[index]);
            }
            CandidateAttribute candidate = new CandidateAttribute();
            candidate.setFoundation(foundation);
            candidate.setComponentId(componentId);
            candidate.setProtocol(protocol);
            candidate.setPriority(priority);
            candidate.setAddress(address);
            candidate.setPort(port);
            candidate.setCandidateType(type);
            candidate.setRelatedAddress(relatedAddress);
            candidate.setRelatedPort(relatedPort);
            candidate.setTcpType(tcptype);
            candidate.setGeneration(generation);
            return candidate;
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }

    @Override
    public void parse(CandidateAttribute field, String sdp) throws SdpException {
        try {
            String[] values2 = sdp.trim().substring(12).split(" ");
            int index = 0;
            String foundation = values2[index++];
            short componentId = Short.parseShort(values2[index++]);
            String protocol = values2[index++];
            long priority = Long.parseLong(values2[index++]);
            String address = values2[index++];
            int port = Integer.parseInt(values2[index++]);
            int n = ++index;
            ++index;
            String type = values2[n];
            if (!CandidateAttribute.isCandidateTypeValid(type)) {
                throw new IllegalArgumentException("Unrecognized candidate type: " + type);
            }
            String relatedAddress = null;
            int relatedPort = 0;
            if (!"host".equals(type)) {
                int n2 = ++index;
                ++index;
                relatedAddress = values2[n2];
                int n3 = ++index;
                ++index;
                relatedPort = Integer.parseInt(values2[n3]);
            }
            String tcptype = null;
            if (protocol.equals("tcp")) {
                int n4 = ++index;
                ++index;
                tcptype = values2[n4];
            }
            int generation = 0;
            if (++index == values2.length - 1) {
                generation = Integer.parseInt(values2[index]);
            }
            field.setFoundation(foundation);
            field.setComponentId(componentId);
            field.setProtocol(protocol);
            field.setPriority(priority);
            field.setAddress(address);
            field.setPort(port);
            field.setCandidateType(type);
            field.setRelatedAddress(relatedAddress);
            field.setRelatedPort(relatedPort);
            field.setTcpType(tcptype);
            field.setGeneration(generation);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }
}

