/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.sdp.attributes.parser;

import java.util.regex.Pattern;
import org.restcomm.media.sdp.SdpException;
import org.restcomm.media.sdp.SdpParser;
import org.restcomm.media.sdp.attributes.RtpMapAttribute;

public class RtpMapAttributeParser
implements SdpParser<RtpMapAttribute> {
    private static final String REGEX = "^a=rtpmap:\\d+\\s\\w+/\\d+(/\\d+)?$";
    private static final Pattern PATTERN = Pattern.compile("^a=rtpmap:\\d+\\s\\w+/\\d+(/\\d+)?$");

    @Override
    public boolean canParse(String sdp) {
        if (sdp == null || sdp.isEmpty()) {
            return false;
        }
        return PATTERN.matcher(sdp.trim()).matches();
    }

    @Override
    public RtpMapAttribute parse(String sdp) throws SdpException {
        try {
            int index = 0;
            String[] values2 = sdp.trim().substring(9).split("\\s|/");
            int payloadType = Integer.parseInt(values2[index++]);
            String codec = values2[index++];
            int clockRate = Integer.parseInt(values2[index++]);
            int codecParams = 1;
            if (index == values2.length - 1) {
                codecParams = Integer.parseInt(values2[index]);
            }
            return new RtpMapAttribute(payloadType, codec, clockRate, codecParams);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }

    @Override
    public void parse(RtpMapAttribute field, String sdp) throws SdpException {
        try {
            int index = 0;
            String[] values2 = sdp.trim().substring(9).split("\\s|/");
            int payloadType = Integer.parseInt(values2[index++]);
            String codec = values2[index++];
            int clockRate = Integer.parseInt(values2[index++]);
            int codecParams = 1;
            if (index == values2.length - 1) {
                codecParams = Integer.parseInt(values2[index]);
            }
            field.setPayloadType(payloadType);
            field.setCodec(codec);
            field.setClockRate(clockRate);
            field.setCodecParams(codecParams);
        }
        catch (Exception e) {
            throw new SdpException("Could not parse SDP: " + sdp, e);
        }
    }
}

