/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.Match;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.MetricsNaming;
import io.vertx.micrometer.MicrometerMetricsOptionsConverter;
import io.vertx.micrometer.VertxInfluxDbOptions;
import io.vertx.micrometer.VertxJmxMetricsOptions;
import io.vertx.micrometer.VertxPrometheusOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

@DataObject
@JsonGen(publicConverter=false, inheritConverter=true)
public class MicrometerMetricsOptions
extends MetricsOptions {
    public static final String DEFAULT_REGISTRY_NAME = "default";
    public static final List<Label> DEFAULT_LABELS = Arrays.asList(Label.HTTP_ROUTE, Label.HTTP_METHOD, Label.HTTP_CODE, Label.POOL_TYPE, Label.EB_SIDE);
    public static final boolean DEFAULT_JVM_METRICS_ENABLED = false;
    public static final MetricsNaming DEFAULT_METRICS_NAMING = MetricsNaming.v4Names();
    private Set<String> disabledMetricsCategories;
    private String registryName;
    private Set<Label> labels;
    private List<Match> labelMatches;
    private MeterRegistry micrometerRegistry;
    private VertxInfluxDbOptions influxDbOptions;
    private VertxPrometheusOptions prometheusOptions;
    private VertxJmxMetricsOptions jmxMetricsOptions;
    private boolean jvmMetricsEnabled;
    private MetricsNaming metricsNaming;
    private Function<HttpRequest, Iterable<Tag>> serverRequestTagsProvider;
    private Function<HttpRequest, Iterable<Tag>> clientRequestTagsProvider;

    public MicrometerMetricsOptions() {
        this.disabledMetricsCategories = new HashSet<String>();
        this.registryName = DEFAULT_REGISTRY_NAME;
        this.labels = EnumSet.copyOf(DEFAULT_LABELS);
        this.labelMatches = new ArrayList<Match>();
        this.jvmMetricsEnabled = false;
        this.metricsNaming = DEFAULT_METRICS_NAMING;
        this.serverRequestTagsProvider = null;
        this.clientRequestTagsProvider = null;
    }

    public MicrometerMetricsOptions(MicrometerMetricsOptions other) {
        super(other);
        this.disabledMetricsCategories = other.disabledMetricsCategories != null ? new HashSet<String>(other.disabledMetricsCategories) : new HashSet();
        this.registryName = other.registryName;
        this.labels = other.labels != null ? EnumSet.copyOf(other.labels) : EnumSet.noneOf(Label.class);
        this.labelMatches = new ArrayList<Match>(other.labelMatches);
        this.micrometerRegistry = other.micrometerRegistry;
        if (other.influxDbOptions != null) {
            this.influxDbOptions = new VertxInfluxDbOptions(other.influxDbOptions);
        }
        if (other.prometheusOptions != null) {
            this.prometheusOptions = new VertxPrometheusOptions(other.prometheusOptions);
        }
        if (other.jmxMetricsOptions != null) {
            this.jmxMetricsOptions = new VertxJmxMetricsOptions(other.jmxMetricsOptions);
        }
        this.jvmMetricsEnabled = other.jvmMetricsEnabled;
        this.metricsNaming = other.metricsNaming;
        this.serverRequestTagsProvider = other.serverRequestTagsProvider;
        this.clientRequestTagsProvider = other.clientRequestTagsProvider;
    }

    public MicrometerMetricsOptions(JsonObject json) {
        this();
        MicrometerMetricsOptionsConverter.fromJson(json, this);
        this.labelMatches = this.loadLabelMatches(json);
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        MicrometerMetricsOptionsConverter.toJson(this, json);
        return json;
    }

    private List<Match> loadLabelMatches(JsonObject json) {
        ArrayList<Match> list = new ArrayList<Match>();
        JsonArray monitored = json.getJsonArray("labelMatches", new JsonArray());
        monitored.forEach(object -> {
            if (object instanceof JsonObject) {
                list.add(new Match((JsonObject)object));
            }
        });
        return list;
    }

    @Override
    public MicrometerMetricsOptions setEnabled(boolean enable) {
        super.setEnabled(enable);
        return this;
    }

    @Override
    public MicrometerMetricsOptions setFactory(VertxMetricsFactory factory2) {
        super.setFactory(factory2);
        return this;
    }

    public Set<String> getDisabledMetricsCategories() {
        return this.disabledMetricsCategories;
    }

    public MicrometerMetricsOptions setDisabledMetricsCategories(Set<String> disabledMetricsCategories) {
        this.disabledMetricsCategories = disabledMetricsCategories;
        return this;
    }

    @GenIgnore
    public MicrometerMetricsOptions addDisabledMetricsCategory(MetricsDomain metricsDomain) {
        if (this.disabledMetricsCategories == null) {
            this.disabledMetricsCategories = new HashSet<String>();
        }
        this.disabledMetricsCategories.add(metricsDomain.toCategory());
        return this;
    }

    @GenIgnore
    public MicrometerMetricsOptions addDisabledMetricsCategory(String category) {
        if (this.disabledMetricsCategories == null) {
            this.disabledMetricsCategories = new HashSet<String>();
        }
        this.disabledMetricsCategories.add(category);
        return this;
    }

    @GenIgnore
    public boolean isMetricsCategoryDisabled(MetricsDomain metricsDomain) {
        return this.disabledMetricsCategories != null && this.disabledMetricsCategories.contains(metricsDomain.toCategory());
    }

    @GenIgnore
    public boolean isMetricsCategoryDisabled(String category) {
        return this.disabledMetricsCategories != null && this.disabledMetricsCategories.contains(category);
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public MicrometerMetricsOptions setRegistryName(String registryName) {
        this.registryName = registryName;
        return this;
    }

    public Set<Label> getLabels() {
        return this.labels;
    }

    public MicrometerMetricsOptions setLabels(Set<Label> labels) {
        this.labels = labels;
        return this;
    }

    @GenIgnore
    public MicrometerMetricsOptions addLabels(Label ... labels) {
        if (this.labels == null) {
            this.labels = EnumSet.noneOf(Label.class);
        }
        this.labels.addAll(Arrays.asList(labels));
        return this;
    }

    public List<Match> getLabelMatches() {
        return this.labelMatches;
    }

    public MicrometerMetricsOptions setLabelMatches(List<Match> matches) {
        this.labelMatches = new ArrayList<Match>(matches);
        return this;
    }

    public MicrometerMetricsOptions addLabelMatch(Match match) {
        this.labelMatches.add(match);
        return this;
    }

    @Deprecated
    public MeterRegistry getMicrometerRegistry() {
        return this.micrometerRegistry;
    }

    @Deprecated
    public MicrometerMetricsOptions setMicrometerRegistry(MeterRegistry micrometerRegistry) {
        this.micrometerRegistry = micrometerRegistry;
        return this;
    }

    public VertxInfluxDbOptions getInfluxDbOptions() {
        return this.influxDbOptions;
    }

    public MicrometerMetricsOptions setInfluxDbOptions(VertxInfluxDbOptions influxDbOptions) {
        this.influxDbOptions = influxDbOptions;
        return this;
    }

    public VertxPrometheusOptions getPrometheusOptions() {
        return this.prometheusOptions;
    }

    public MicrometerMetricsOptions setPrometheusOptions(VertxPrometheusOptions prometheusOptions) {
        this.prometheusOptions = prometheusOptions;
        return this;
    }

    public VertxJmxMetricsOptions getJmxMetricsOptions() {
        return this.jmxMetricsOptions;
    }

    public MicrometerMetricsOptions setJmxMetricsOptions(VertxJmxMetricsOptions jmxMetricsOptions) {
        this.jmxMetricsOptions = jmxMetricsOptions;
        return this;
    }

    public boolean isJvmMetricsEnabled() {
        return this.jvmMetricsEnabled;
    }

    public MicrometerMetricsOptions setJvmMetricsEnabled(boolean jvmMetricsEnabled) {
        this.jvmMetricsEnabled = jvmMetricsEnabled;
        return this;
    }

    public MetricsNaming getMetricsNaming() {
        return this.metricsNaming;
    }

    public MicrometerMetricsOptions setMetricsNaming(MetricsNaming metricsNaming) {
        this.metricsNaming = metricsNaming;
        return this;
    }

    @GenIgnore
    @Deprecated
    public Function<HttpRequest, Iterable<Tag>> getRequestsTagsProvider() {
        return this.getServerRequestTagsProvider();
    }

    @GenIgnore
    @Deprecated
    public MicrometerMetricsOptions setRequestsTagsProvider(Function<HttpRequest, Iterable<Tag>> serverRequestTagsProvider) {
        return this.setServerRequestTagsProvider(serverRequestTagsProvider);
    }

    @GenIgnore
    public Function<HttpRequest, Iterable<Tag>> getServerRequestTagsProvider() {
        return this.serverRequestTagsProvider;
    }

    @GenIgnore
    public MicrometerMetricsOptions setServerRequestTagsProvider(Function<HttpRequest, Iterable<Tag>> serverRequestTagsProvider) {
        this.serverRequestTagsProvider = serverRequestTagsProvider;
        return this;
    }

    @GenIgnore
    public Function<HttpRequest, Iterable<Tag>> getClientRequestTagsProvider() {
        return this.clientRequestTagsProvider;
    }

    @GenIgnore
    public MicrometerMetricsOptions setClientRequestTagsProvider(Function<HttpRequest, Iterable<Tag>> clientRequestTagsProvider) {
        this.clientRequestTagsProvider = clientRequestTagsProvider;
        return this;
    }
}

