/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl;

import io.vertx.core.Handler;
import io.vertx.core.streams.ReadStream;
import java.util.Objects;
import java.util.function.Function;

public class MappingStream<I, O>
implements ReadStream<O> {
    private final ReadStream<I> input;
    private final Function<I, O> mapper;

    public MappingStream(ReadStream<I> input, Function<I, O> mapper) {
        Objects.requireNonNull(input, "input is null");
        Objects.requireNonNull(mapper, "mapper is null");
        this.input = input;
        this.mapper = mapper;
    }

    @Override
    public ReadStream<O> exceptionHandler(Handler<Throwable> handler) {
        this.input.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public ReadStream<O> handler(Handler<O> handler) {
        if (handler != null) {
            this.input.handler((T event) -> handler.handle(this.mapper.apply(event)));
        } else {
            this.input.handler(null);
        }
        return this;
    }

    @Override
    public ReadStream<O> pause() {
        this.input.pause();
        return this;
    }

    @Override
    public ReadStream<O> resume() {
        this.input.resume();
        return this;
    }

    @Override
    public ReadStream<O> fetch(long amount) {
        this.input.fetch(amount);
        return this;
    }

    @Override
    public ReadStream<O> endHandler(Handler<Void> endHandler) {
        this.input.endHandler(endHandler);
        return this;
    }
}

