/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import java.nio.charset.StandardCharsets;

public final class URIDecoder {
    private URIDecoder() {
        throw new RuntimeException("Static Class");
    }

    public static String decodeURIComponent(String s) {
        return URIDecoder.decodeURIComponent(s, true);
    }

    private static int indexOfPercentOrPlus(String s) {
        int size = s.length();
        for (int i2 = 0; i2 < size; ++i2) {
            char c = s.charAt(i2);
            if (c != '%' && c != '+') continue;
            return i2;
        }
        return -1;
    }

    public static String decodeURIComponent(String s, boolean plus2) {
        int i2;
        if (s == null) {
            return null;
        }
        int n = i2 = !plus2 ? s.indexOf(37) : URIDecoder.indexOfPercentOrPlus(s);
        if (i2 == -1) {
            return s;
        }
        return URIDecoder.decodeAndTransformURIComponent(s, i2, plus2);
    }

    private static String decodeAndTransformURIComponent(String s, int i2, boolean plus2) {
        byte[] buf = s.getBytes(StandardCharsets.UTF_8);
        int pos = i2;
        int size = s.length();
        while (i2 < size) {
            int c = s.charAt(i2);
            if (c == 37) {
                if (i2 == size - 1) {
                    throw new IllegalArgumentException("unterminated escape sequence at end of string: " + s);
                }
                if ((c = (int)s.charAt(++i2)) == 37) {
                    buf[pos++] = 37;
                    break;
                }
                if (i2 >= size - 1) {
                    throw new IllegalArgumentException("partial escape sequence at end of string: " + s);
                }
                c = URIDecoder.decodeHexNibble((char)c);
                char c2 = URIDecoder.decodeHexNibble(s.charAt(++i2));
                if (c == 65535 || c2 == '\uffff') {
                    throw new IllegalArgumentException("invalid escape sequence `%" + s.charAt(i2 - 1) + s.charAt(i2) + "' at index " + (i2 - 2) + " of: " + s);
                }
                c = (char)(c * 16 + c2);
                buf[pos++] = (byte)c;
            } else {
                buf[pos++] = (byte)(plus2 && c == 43 ? 32 : c);
            }
            ++i2;
        }
        return new String(buf, 0, pos, StandardCharsets.UTF_8);
    }

    private static char decodeHexNibble(char c) {
        if ('0' <= c && c <= '9') {
            return (char)(c - 48);
        }
        if ('a' <= c && c <= 'f') {
            return (char)(c - 97 + 10);
        }
        if ('A' <= c && c <= 'F') {
            return (char)(c - 65 + 10);
        }
        return '\uffff';
    }
}

