/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.sip;

import io.sip3.commons.micrometer.Metrics;
import io.sip3.commons.util.DateTimeFormatterUtilKt;
import io.sip3.commons.vertx.annotations.Instance;
import io.sip3.commons.vertx.collections.PeriodicallyExpiringHashMap;
import io.sip3.commons.vertx.util.EventBusUtilKt;
import io.sip3.salto.ce.RoutesCE;
import io.sip3.salto.ce.attributes.AttributesRegistry;
import io.sip3.salto.ce.domain.Address;
import io.sip3.salto.ce.sip.SipCallHandler;
import io.sip3.salto.ce.sip.SipTransaction;
import io.sip3.salto.ce.udf.UdfExecutor;
import io.sip3.salto.ce.util.AttributeUtilKt;
import io.sip3.salto.ce.util.DurationUtil;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.Counter;
import io.vertx.kotlin.coroutines.VertxCoroutineKt;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Instance
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010$\n\u0002\b\u000b\b\u0017\u0018\u0000 ;2\u00020\u0001:\u0002;<B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0006H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\u0014\u0010&\u001a\u00020 2\n\u0010'\u001a\u00060\tR\u00020\u0000H\u0016J\u0010\u0010(\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010)\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\u0014\u0010*\u001a\u00020 2\n\u0010'\u001a\u00060\tR\u00020\u0000H\u0016J\b\u0010+\u001a\u00020 H\u0016J\u0010\u0010,\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\u0014\u0010-\u001a\u00020 2\n\u0010'\u001a\u00060\tR\u00020\u0000H\u0016J\u0014\u0010.\u001a\u00020\u000b2\n\u0010'\u001a\u00060\tR\u00020\u0000H\u0016J(\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020\u000b2\u0016\u00101\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\tR\u00020\u000002H\u0016J \u00103\u001a\u00020\u000b2\u0016\u00101\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\tR\u00020\u000002H\u0016J\u0010\u00104\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u00105\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u00106\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\u0014\u00107\u001a\u00020 2\n\u0010'\u001a\u00060\tR\u00020\u0000H\u0016J&\u00108\u001a\u00020 2\u0006\u00109\u001a\u00020\u00052\n\u0010'\u001a\u00060\tR\u00020\u00002\b\b\u0002\u0010:\u001a\u00020\u0018H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\tR\u00020\u00000\b0\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lio/sip3/salto/ce/sip/SipCallHandler;", "Lio/vertx/core/AbstractVerticle;", "()V", "activeSessionCounters", "Lio/sip3/commons/vertx/collections/PeriodicallyExpiringHashMap;", "", "Ljava/util/concurrent/atomic/AtomicInteger;", "activeSessions", "", "Lio/sip3/salto/ce/sip/SipCallHandler$SipSession;", "aggregationTimeout", "", "attributesRegistry", "Lio/sip3/salto/ce/attributes/AttributesRegistry;", "correlationRole", "durationDistributions", "Ljava/util/TreeMap;", "durationTimeout", "expirationDelay", "hint", "Lio/vertx/core/json/JsonObject;", "logger", "Lmu/KLogger;", "recordCallUsersAttributes", "", "recordIpAddressesAttributes", "terminationTimeout", "timeSuffix", "Ljava/time/format/DateTimeFormatter;", "udfExecutor", "Lio/sip3/salto/ce/udf/UdfExecutor;", "calculateActiveCallSessions", "", "hostsKey", "counter", "calculateByeTransactionMetrics", "transaction", "Lio/sip3/salto/ce/sip/SipTransaction;", "calculateCallSessionMetrics", "session", "calculateInviteTransactionMetrics", "handle", "sendToCorrelationHandlerIfNeeded", "start", "terminateByeTransaction", "terminateCallSession", "terminateCallSessionAt", "terminateCallSessions", "now", "sessions", "", "terminateCallSessionsAt", "terminateInfoTransaction", "terminateInviteTransaction", "terminateTransaction", "writeAttributes", "writeToDatabase", "prefix", "upsert", "Companion", "SipSession", "sip3-salto-ce"})
public class SipCallHandler
extends AbstractVerticle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    @NotNull
    private DateTimeFormatter timeSuffix;
    private long expirationDelay;
    private long aggregationTimeout;
    private long terminationTimeout;
    private long durationTimeout;
    @NotNull
    private TreeMap<Long, String> durationDistributions;
    @Nullable
    private String correlationRole;
    private boolean recordIpAddressesAttributes;
    private boolean recordCallUsersAttributes;
    @Nullable
    private JsonObject hint;
    private PeriodicallyExpiringHashMap<String, Map<String, SipSession>> activeSessions;
    private PeriodicallyExpiringHashMap<String, AtomicInteger> activeSessionCounters;
    private UdfExecutor udfExecutor;
    private AttributesRegistry attributesRegistry;
    @NotNull
    private static final List<String> EXCLUDED_ATTRIBUTES;
    @NotNull
    public static final String PREFIX = "sip_call";
    @NotNull
    public static final String UNKNOWN = "unknown";
    @NotNull
    public static final String FAILED = "failed";
    @NotNull
    public static final String CANCELED = "canceled";
    @NotNull
    public static final String ANSWERED = "answered";
    @NotNull
    public static final String REDIRECTED = "redirected";
    @NotNull
    public static final String UNAUTHORIZED = "unauthorized";
    @NotNull
    public static final String TRANSACTIONS = "sip_call_transactions";
    @NotNull
    public static final String RETRANSMITS = "sip_call_retransmits";
    @NotNull
    public static final String ATTEMPTS = "sip_call_attempts";
    @NotNull
    public static final String DURATION = "sip_call_duration";
    @NotNull
    public static final String TRYING_DELAY = "sip_call_trying-delay";
    @NotNull
    public static final String SETUP_TIME = "sip_call_setup-time";
    @NotNull
    public static final String ESTABLISH_TIME = "sip_call_establish-time";
    @NotNull
    public static final String DISCONNECT_TIME = "sip_call_disconnect-time";
    @NotNull
    public static final String ESTABLISHED = "sip_call_established";

    public SipCallHandler() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "ofPattern(\"yyyyMMdd\")");
        this.timeSuffix = dateTimeFormatter;
        this.expirationDelay = 1000L;
        this.aggregationTimeout = 60000L;
        this.terminationTimeout = 2000L;
        this.durationTimeout = 3600000L;
        this.durationDistributions = new TreeMap();
    }

    @Override
    public void start() {
        JsonObject jsonObject;
        String string = this.config().getString("time_suffix");
        if (string != null) {
            String it = string;
            boolean bl = false;
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(it);
            Intrinsics.checkNotNullExpressionValue(dateTimeFormatter, "ofPattern(it)");
            this.timeSuffix = dateTimeFormatter;
        }
        if ((jsonObject = this.config().getJsonObject("sip")) != null && (jsonObject = jsonObject.getJsonObject("call")) != null) {
            String string2;
            Object object;
            long it;
            JsonObject config2 = jsonObject;
            boolean bl = false;
            Object object2 = config2.getLong("expiration_delay");
            Long l = object2;
            if (l != null) {
                Intrinsics.checkNotNullExpressionValue(l, "getLong(\"expiration_delay\")");
                it = ((Number)object2).longValue();
                boolean bl2 = false;
                this.expirationDelay = it;
            }
            object2 = config2.getLong("aggregation_timeout");
            Long l2 = object2;
            if (l2 != null) {
                Intrinsics.checkNotNullExpressionValue(l2, "getLong(\"aggregation_timeout\")");
                it = ((Number)object2).longValue();
                boolean bl3 = false;
                this.aggregationTimeout = it;
            }
            object2 = config2.getLong("termination_timeout");
            Long l3 = object2;
            if (l3 != null) {
                Intrinsics.checkNotNullExpressionValue(l3, "getLong(\"termination_timeout\")");
                it = ((Number)object2).longValue();
                boolean bl4 = false;
                this.terminationTimeout = it;
            }
            object2 = config2.getLong("duration_timeout");
            Long l4 = object2;
            if (l4 != null) {
                Intrinsics.checkNotNullExpressionValue(l4, "getLong(\"duration_timeout\")");
                it = ((Number)object2).longValue();
                boolean bl5 = false;
                this.durationTimeout = it;
            }
            Object object3 = object2 = config2.getJsonArray("duration_distributions");
            if (object3 != null) {
                Intrinsics.checkNotNullExpressionValue(object3, "getJsonArray(\"duration_distributions\")");
                Iterable $this$forEach$iv = (Iterable)object2;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it2 = element$iv = iterator2.next();
                    boolean bl6 = false;
                    Map map2 = this.durationDistributions;
                    Intrinsics.checkNotNull(it2, "null cannot be cast to non-null type kotlin.String");
                    map2.put(DurationUtil.INSTANCE.parseDuration((String)it2).toMillis(), it2);
                }
            }
            if ((object = config2.getJsonObject("correlation")) != null && (object = (string2 = ((JsonObject)object).getString("role"))) != null) {
                Intrinsics.checkNotNullExpressionValue(object, "getString(\"role\")");
                String it3 = string2;
                boolean bl7 = false;
                this.correlationRole = it3;
            }
        }
        JsonObject jsonObject2 = this.config().getJsonObject("attributes");
        if (jsonObject2 != null) {
            Boolean bl;
            JsonObject config3 = jsonObject2;
            boolean bl8 = false;
            Boolean bl9 = bl = config3.getBoolean("record_ip_addresses");
            if (bl9 != null) {
                Intrinsics.checkNotNullExpressionValue(bl9, "getBoolean(\"record_ip_addresses\")");
                boolean it = bl;
                boolean bl10 = false;
                this.recordIpAddressesAttributes = it;
            }
            Boolean bl11 = bl = config3.getBoolean("record_call_users");
            if (bl11 != null) {
                Intrinsics.checkNotNullExpressionValue(bl11, "getBoolean(\"record_call_users\")");
                boolean it = bl;
                boolean bl12 = false;
                this.recordCallUsersAttributes = it;
            }
        }
        Vertx vertx = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx, "vertx");
        this.udfExecutor = new UdfExecutor(vertx);
        Vertx vertx2 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx2, "vertx");
        JsonObject jsonObject3 = this.config();
        Intrinsics.checkNotNullExpressionValue(jsonObject3, "config()");
        this.attributesRegistry = new AttributesRegistry(vertx2, jsonObject3);
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
        EventBusUtilKt.localRequest$default(eventBus, RoutesCE.Companion.getMongo_collection_hint(), "sip_call_index", null, new Function1<AsyncResult<Message<JsonObject>>, Unit>(this){
            final /* synthetic */ SipCallHandler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull AsyncResult<Message<JsonObject>> asr) {
                Intrinsics.checkNotNullParameter(asr, "asr");
                if (asr.succeeded()) {
                    JsonObject jsonObject = asr.result().body();
                    if (jsonObject != null) {
                        JsonObject jsonObject2 = jsonObject;
                        SipCallHandler sipCallHandler = this.this$0;
                        JsonObject it = jsonObject2;
                        boolean bl = false;
                        SipCallHandler.access$setHint$p(sipCallHandler, it);
                    }
                } else {
                    SipCallHandler.access$getLogger$p(this.this$0).error(asr.cause(), (Function0<? extends Object>)start.2.INSTANCE);
                }
            }
        }, 4, null);
        PeriodicallyExpiringHashMap.Builder builder = new PeriodicallyExpiringHashMap.Builder(0L, 0, null, null, null, 31, null).delay(this.expirationDelay).period((int)(this.aggregationTimeout / this.expirationDelay)).expireAt((Function2)new Function2<String, Map<String, SipSession>, Long>(this){
            final /* synthetic */ SipCallHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final Long invoke(@NotNull String string, @NotNull Map<String, SipSession> sessions) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(sessions, "sessions");
                return this.this$0.terminateCallSessionsAt(sessions);
            }
        }).onExpire((Function3)new Function3<Long, String, Map<String, SipSession>, Unit>(this){
            final /* synthetic */ SipCallHandler this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(long now, @NotNull String string, @NotNull Map<String, SipSession> sessions) {
                Intrinsics.checkNotNullParameter(string, "<anonymous parameter 1>");
                Intrinsics.checkNotNullParameter(sessions, "sessions");
                this.this$0.terminateCallSessions(now, sessions);
            }
        });
        Vertx vertx3 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx3, "vertx");
        this.activeSessions = builder.build(vertx3);
        PeriodicallyExpiringHashMap.Builder builder2 = new PeriodicallyExpiringHashMap.Builder(0L, 0, null, null, null, 31, null).delay(this.expirationDelay).expireAt(start.7.INSTANCE).onRemain((Function2)new Function2<String, AtomicInteger, Unit>(this){
            final /* synthetic */ SipCallHandler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String hostsKey, @NotNull AtomicInteger counter) {
                Intrinsics.checkNotNullParameter(hostsKey, "hostsKey");
                Intrinsics.checkNotNullParameter(counter, "counter");
                this.this$0.calculateActiveCallSessions(hostsKey, counter);
            }
        });
        Vertx vertx4 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx4, "vertx");
        this.activeSessionCounters = builder2.build(vertx4);
        CoroutineScope coroutineScope = GlobalScope.INSTANCE;
        Vertx vertx5 = this.vertx;
        Intrinsics.checkNotNullExpressionValue(vertx5, "vertx");
        CoroutineDispatcher coroutineDispatcher = VertxCoroutineKt.dispatcher(vertx5);
        Intrinsics.checkNotNull(coroutineDispatcher, "null cannot be cast to non-null type kotlin.coroutines.CoroutineContext");
        BuildersKt.launch$default(coroutineScope, coroutineDispatcher, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ SipCallHandler this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        v0 = SipCallHandler.access$getVertx$p$s-529614350(this.this$0).sharedData().getLocalCounter("sip_call");
                        Intrinsics.checkNotNullExpressionValue(v0, "vertx.sharedData().getLocalCounter(PREFIX)");
                        this.label = 1;
                        v1 = VertxCoroutineKt.coAwait(v0, this);
                        if (v1 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        index = (Counter)v1;
                        var4_4 = SipCallHandler.access$getVertx$p$s-529614350(this.this$0).eventBus();
                        var3_5 = index.getAndIncrement();
                        Intrinsics.checkNotNullExpressionValue(var3_5, "index.andIncrement");
                        this.L$0 = var4_4;
                        this.label = 2;
                        v2 = VertxCoroutineKt.coAwait(var3_5, this);
                        if (v2 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl29
                    }
                    case 2: {
                        var4_4 = (EventBus)this.L$0;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl29:
                        // 2 sources

                        var4_4.localConsumer("sip_call_" + v2, (Handler<Message<T>>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, invokeSuspend$lambda$0(io.sip3.salto.ce.sip.SipCallHandler io.vertx.core.eventbus.Message ), (Lio/vertx/core/eventbus/Message;)V)((SipCallHandler)this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(SipCallHandler this$0, Message event) {
                try {
                    SipTransaction transaction2 = (SipTransaction)event.body();
                    Intrinsics.checkNotNullExpressionValue(transaction2, "transaction");
                    this$0.handle(transaction2);
                }
                catch (Exception e) {
                    SipCallHandler.access$getLogger$p(this$0).error("SipCallHandler 'handle()' failed.", e);
                }
            }
        }, 2, null);
    }

    public void handle(@NotNull SipTransaction transaction2) {
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        PeriodicallyExpiringHashMap<String, Map<String, SipSession>> periodicallyExpiringHashMap = this.activeSessions;
        if (periodicallyExpiringHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("activeSessions");
            periodicallyExpiringHashMap = null;
        }
        periodicallyExpiringHashMap.touch(transaction2.getCallId());
        switch (transaction2.getCseqMethod()) {
            case "INVITE": {
                this.terminateInviteTransaction(transaction2);
                break;
            }
            case "BYE": {
                this.terminateByeTransaction(transaction2);
                break;
            }
            case "INFO": {
                this.terminateInfoTransaction(transaction2);
                break;
            }
            default: {
                this.terminateTransaction(transaction2);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void terminateInviteTransaction(@NotNull SipTransaction transaction) {
        block18: {
            Intrinsics.checkNotNullParameter(transaction, "transaction");
            v0 = this.activeSessions;
            if (v0 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("activeSessions");
                v0 = null;
            }
            if ((v1 = v0.get(transaction.getCallId())) == null || (v1 = v1.get(transaction.getLegId())) == null) {
                v1 = new SipSession();
            }
            session = v1;
            previousState = session.getState();
            session.addInviteTransaction(transaction);
            var4_4 = session.getState();
            switch (var4_4.hashCode()) {
                case -123173735: {
                    if (!var4_4.equals("canceled")) {
                        ** break;
                    }
                    ** GOTO lbl26
                }
                case -499559203: {
                    if (var4_4.equals("answered")) break;
                    ** break;
                }
                case 1449033083: {
                    if (!var4_4.equals("redirected")) {
                        ** break;
                    }
                    ** GOTO lbl26
                }
                case -1281977283: {
                    if (!var4_4.equals("failed")) ** break;
lbl26:
                    // 3 sources

                    this.terminateCallSession((SipSession)session);
                    v2 = this.activeSessions;
                    if (v2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("activeSessions");
                        v2 = null;
                    }
                    v3 = v2.get(transaction.getCallId());
                    if (v3 != null) {
                        v3.remove(transaction.getLegId());
                    }
                    break block18;
                }
            }
            if (!Intrinsics.areEqual(previousState, "answered")) {
                this.writeAttributes((SipSession)session);
                this.writeToDatabase("sip_call", (SipSession)session, true);
                this.sendToCorrelationHandlerIfNeeded((SipSession)session);
                v4 = session.getSrcAddr().getHost();
                if (v4 == null) {
                    v4 = "";
                }
                if ((v5 = session.getDstAddr().getHost()) == null) {
                    v5 = "";
                }
                activeSessionCountersKey = v4 + ":" + v5;
                v6 = this.activeSessionCounters;
                if (v6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("activeSessionCounters");
                    v6 = null;
                }
                v6.getOrPut(activeSessionCountersKey, terminateInviteTransaction.1.INSTANCE).incrementAndGet();
            }
            if ((v7 = this.activeSessions) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("activeSessions");
                v7 = null;
            }
            v7.getOrPut(transaction.getCallId(), terminateInviteTransaction.2.INSTANCE).put(transaction.getLegId(), (SipSession)session);
            break block18;
lbl58:
            // 5 sources

            if ((v8 = this.activeSessions) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("activeSessions");
                v8 = null;
            }
            v8.getOrPut(transaction.getCallId(), terminateInviteTransaction.3.INSTANCE).put(transaction.getLegId(), (SipSession)session);
        }
        this.calculateInviteTransactionMetrics(transaction);
    }

    public void calculateInviteTransactionMetrics(@NotNull SipTransaction transaction2) {
        block8: {
            String it;
            Map<String, Object> map2;
            Intrinsics.checkNotNullParameter(transaction2, "transaction");
            long createdAt = transaction2.getCreatedAt();
            Map<String, Object> $this$calculateInviteTransactionMetrics_u24lambda_u2413 = map2 = AttributeUtilKt.toMetricsAttributes(transaction2.getAttributes(), EXCLUDED_ATTRIBUTES);
            boolean bl = false;
            String string = transaction2.getSrcAddr().getHost();
            if (string != null) {
                it = string;
                boolean bl2 = false;
                $this$calculateInviteTransactionMetrics_u24lambda_u2413.put("src_host", it);
            }
            String string2 = transaction2.getDstAddr().getHost();
            if (string2 != null) {
                it = string2;
                boolean bl3 = false;
                $this$calculateInviteTransactionMetrics_u24lambda_u2413.put("dst_host", it);
            }
            Map<String, Object> attributes = map2;
            Long l = transaction2.getTryingAt();
            if (l != null) {
                long tryingAt = ((Number)l).longValue();
                boolean bl4 = false;
                if (createdAt < tryingAt) {
                    Metrics.INSTANCE.timer(TRYING_DELAY, attributes).record(tryingAt - createdAt, TimeUnit.MILLISECONDS);
                }
            }
            Long l2 = transaction2.getRingingAt();
            if (l2 != null) {
                long ringingAt = ((Number)l2).longValue();
                boolean bl5 = false;
                if (createdAt < ringingAt) {
                    Metrics.INSTANCE.timer(SETUP_TIME, attributes).record(ringingAt - createdAt, TimeUnit.MILLISECONDS);
                }
            }
            if (!Intrinsics.areEqual(transaction2.getState(), "succeed")) break block8;
            Long l3 = transaction2.getTerminatedAt();
            if (l3 != null) {
                long terminatedAt = ((Number)l3).longValue();
                boolean bl6 = false;
                if (createdAt < terminatedAt) {
                    Metrics.INSTANCE.timer(ESTABLISH_TIME, attributes).record(terminatedAt - createdAt, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    public void terminateByeTransaction(@NotNull SipTransaction transaction2) {
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        PeriodicallyExpiringHashMap<String, Map<String, SipSession>> periodicallyExpiringHashMap = this.activeSessions;
        if (periodicallyExpiringHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("activeSessions");
            periodicallyExpiringHashMap = null;
        }
        Map<String, SipSession> map2 = periodicallyExpiringHashMap.get(transaction2.getCallId());
        if (map2 != null) {
            Map<String, SipSession> sessions = map2;
            boolean bl = false;
            SipSession session2 = sessions.get(transaction2.getLegId());
            if (session2 != null) {
                session2.addByeTransaction(transaction2);
            } else {
                Map<String, SipSession> $this$forEach$iv = sessions;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, SipSession>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, SipSession> element$iv;
                    Map.Entry<String, SipSession> entry = element$iv = iterator2.next();
                    boolean bl2 = false;
                    SipSession session3 = entry.getValue();
                    if ((!Intrinsics.areEqual(session3.getCaller(), transaction2.getCaller()) || !Intrinsics.areEqual(session3.getCallee(), transaction2.getCallee())) && (!Intrinsics.areEqual(session3.getCaller(), transaction2.getCallee()) || !Intrinsics.areEqual(session3.getCallee(), transaction2.getCaller()))) continue;
                    session3.addByeTransaction(transaction2);
                }
            }
        }
        this.calculateByeTransactionMetrics(transaction2);
    }

    public void terminateTransaction(@NotNull SipTransaction transaction2) {
        block4: {
            Intrinsics.checkNotNullParameter(transaction2, "transaction");
            PeriodicallyExpiringHashMap<String, Map<String, SipSession>> periodicallyExpiringHashMap = this.activeSessions;
            if (periodicallyExpiringHashMap == null) {
                Intrinsics.throwUninitializedPropertyAccessException("activeSessions");
                periodicallyExpiringHashMap = null;
            }
            Map<String, SipSession> map2 = periodicallyExpiringHashMap.get(transaction2.getCallId());
            if (map2 == null) break block4;
            Map<String, SipSession> sessions = map2;
            boolean bl = false;
            SipSession session2 = sessions.get(transaction2.getLegId());
            if (session2 != null) {
                session2.addTransaction(transaction2);
            } else {
                Map<String, SipSession> $this$forEach$iv = sessions;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, SipSession>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, SipSession> element$iv;
                    Map.Entry<String, SipSession> entry = element$iv = iterator2.next();
                    boolean bl2 = false;
                    SipSession session3 = entry.getValue();
                    if ((!Intrinsics.areEqual(session3.getCaller(), transaction2.getCaller()) || !Intrinsics.areEqual(session3.getCallee(), transaction2.getCallee())) && (!Intrinsics.areEqual(session3.getCaller(), transaction2.getCallee()) || !Intrinsics.areEqual(session3.getCallee(), transaction2.getCaller()))) continue;
                    session3.addTransaction(transaction2);
                }
            }
        }
    }

    public void terminateInfoTransaction(@NotNull SipTransaction transaction2) {
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
        EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getSip() + "_info", transaction2, null, 4, null);
    }

    public void calculateByeTransactionMetrics(@NotNull SipTransaction transaction2) {
        block3: {
            String it;
            Map<String, Object> map2;
            Intrinsics.checkNotNullParameter(transaction2, "transaction");
            long createdAt = transaction2.getCreatedAt();
            Map<String, Object> $this$calculateByeTransactionMetrics_u24lambda_u2423 = map2 = AttributeUtilKt.toMetricsAttributes(transaction2.getAttributes(), EXCLUDED_ATTRIBUTES);
            boolean bl = false;
            String string = transaction2.getSrcAddr().getHost();
            if (string != null) {
                it = string;
                boolean bl2 = false;
                $this$calculateByeTransactionMetrics_u24lambda_u2423.put("src_host", it);
            }
            String string2 = transaction2.getDstAddr().getHost();
            if (string2 != null) {
                it = string2;
                boolean bl3 = false;
                $this$calculateByeTransactionMetrics_u24lambda_u2423.put("dst_host", it);
            }
            Map<String, Object> attributes = map2;
            Long l = transaction2.getTerminatedAt();
            if (l == null) break block3;
            long terminatedAt = ((Number)l).longValue();
            boolean bl4 = false;
            if (createdAt < terminatedAt) {
                Metrics.INSTANCE.timer(DISCONNECT_TIME, attributes).record(terminatedAt - createdAt, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public long terminateCallSessionsAt(@NotNull Map<String, SipSession> sessions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(sessions, "sessions");
        Map<String, SipSession> $this$map$iv = sessions;
        boolean $i$f$map = false;
        Map<String, SipSession> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SipSession session2 = (SipSession)entry.getValue();
            collection.add(this.terminateCallSessionAt(session2));
        }
        Long l = (Long)CollectionsKt.minOrNull((List)destination$iv$iv);
        return l != null ? l : Long.MIN_VALUE;
    }

    public long terminateCallSessionAt(@NotNull SipSession session2) {
        long l;
        Intrinsics.checkNotNullParameter(session2, "session");
        if (Intrinsics.areEqual(session2.getState(), UNKNOWN)) {
            l = session2.getCreatedAt() + this.terminationTimeout;
        } else {
            Long l2 = session2.getTerminatedAt();
            if (l2 != null) {
                long it = ((Number)l2).longValue();
                boolean bl = false;
                l = it + this.terminationTimeout;
            } else {
                Long l3 = session2.getAnsweredAt();
                if (l3 != null) {
                    long it = ((Number)l3).longValue();
                    boolean bl = false;
                    l = it + this.durationTimeout;
                } else {
                    l = session2.getCreatedAt() + this.aggregationTimeout;
                }
            }
        }
        return l;
    }

    public void terminateCallSessions(long now, @NotNull Map<String, SipSession> sessions) {
        Intrinsics.checkNotNullParameter(sessions, "sessions");
        Map<String, SipSession> $this$forEach$iv = sessions;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, SipSession>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, SipSession> element$iv;
            Map.Entry<String, SipSession> entry = element$iv = iterator2.next();
            boolean bl = false;
            SipSession session2 = entry.getValue();
            if (this.terminateCallSessionAt(session2) > now) {
                PeriodicallyExpiringHashMap<String, Map<String, SipSession>> periodicallyExpiringHashMap = this.activeSessions;
                if (periodicallyExpiringHashMap == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("activeSessions");
                    periodicallyExpiringHashMap = null;
                }
                periodicallyExpiringHashMap.getOrPut(session2.getCallId(), terminateCallSessions.1.1.INSTANCE).put(session2.getLegId(), session2);
                continue;
            }
            this.terminateCallSession(session2);
        }
    }

    public void terminateCallSession(@NotNull SipSession session2) {
        UdfExecutor udfExecutor;
        String state;
        Intrinsics.checkNotNullParameter(session2, "session");
        if (session2.getTerminatedAt() == null) {
            session2.setTerminatedAt(System.currentTimeMillis());
        }
        if (Intrinsics.areEqual(state = session2.getState(), ANSWERED)) {
            String string;
            String string2;
            if (session2.getDuration() == null) {
                session2.getAttributes().put("expired", true);
            }
            if ((string2 = session2.getSrcAddr().getHost()) == null) {
                string2 = "";
            }
            if ((string = session2.getDstAddr().getHost()) == null) {
                string = "";
            }
            String activeSessionCountersKey = string2 + ":" + string;
            PeriodicallyExpiringHashMap<String, AtomicInteger> periodicallyExpiringHashMap = this.activeSessionCounters;
            if (periodicallyExpiringHashMap == null) {
                Intrinsics.throwUninitializedPropertyAccessException("activeSessionCounters");
                periodicallyExpiringHashMap = null;
            }
            periodicallyExpiringHashMap.getOrPut(activeSessionCountersKey, terminateCallSession.1.INSTANCE).decrementAndGet();
        }
        if ((udfExecutor = this.udfExecutor) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("udfExecutor");
            udfExecutor = null;
        }
        udfExecutor.execute(RoutesCE.Companion.getSip_call_udf(), (Function0<? extends Map<String, Object>>)new Function0<Map<String, Object>>(session2){
            final /* synthetic */ SipSession $session;
            {
                this.$session = $session;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<String, Object> invoke() {
                String it;
                long it2;
                void $this$invoke_u24lambda_u2413_u24lambda_u2412;
                Object it3;
                Map map2 = new LinkedHashMap<K, V>();
                SipSession sipSession = this.$session;
                Map $this$invoke_u24lambda_u2413 = map2;
                boolean bl = false;
                Address src = sipSession.getSrcAddr();
                $this$invoke_u24lambda_u2413.put("src_addr", src.getAddr());
                $this$invoke_u24lambda_u2413.put("src_port", src.getPort());
                String string = src.getHost();
                if (string != null) {
                    it3 = string;
                    boolean bl2 = false;
                    $this$invoke_u24lambda_u2413.put("src_host", it3);
                }
                Address dst = sipSession.getDstAddr();
                $this$invoke_u24lambda_u2413.put("dst_addr", dst.getAddr());
                $this$invoke_u24lambda_u2413.put("dst_port", dst.getPort());
                String string2 = dst.getHost();
                if (string2 != null) {
                    String it4 = string2;
                    boolean bl3 = false;
                    $this$invoke_u24lambda_u2413.put("dst_host", it4);
                }
                Map map3 = new LinkedHashMap<K, V>();
                it3 = map3;
                String string3 = "payload";
                Map map4 = $this$invoke_u24lambda_u2413;
                boolean bl4 = false;
                $this$invoke_u24lambda_u2413_u24lambda_u2412.put("created_at", sipSession.getCreatedAt());
                Long l = sipSession.getTerminatedAt();
                Intrinsics.checkNotNull(l);
                $this$invoke_u24lambda_u2413_u24lambda_u2412.put("terminated_at", l);
                $this$invoke_u24lambda_u2413_u24lambda_u2412.put("state", sipSession.getState());
                $this$invoke_u24lambda_u2413_u24lambda_u2412.put("caller", sipSession.getCaller());
                $this$invoke_u24lambda_u2413_u24lambda_u2412.put("callee", sipSession.getCallee());
                $this$invoke_u24lambda_u2413_u24lambda_u2412.put("call_id", sipSession.getCallId());
                Long l2 = sipSession.getDuration();
                if (l2 != null) {
                    it2 = ((Number)l2).longValue();
                    boolean bl5 = false;
                    $this$invoke_u24lambda_u2413_u24lambda_u2412.put("duration", it2);
                }
                Long l3 = sipSession.getTryingDelay();
                if (l3 != null) {
                    it2 = ((Number)l3).longValue();
                    boolean bl6 = false;
                    $this$invoke_u24lambda_u2413_u24lambda_u2412.put("trying_delay", it2);
                }
                Long l4 = sipSession.getSetupTime();
                if (l4 != null) {
                    it2 = ((Number)l4).longValue();
                    boolean bl7 = false;
                    $this$invoke_u24lambda_u2413_u24lambda_u2412.put("setup_time", it2);
                }
                Long l5 = sipSession.getEstablishTime();
                if (l5 != null) {
                    it2 = ((Number)l5).longValue();
                    boolean bl8 = false;
                    $this$invoke_u24lambda_u2413_u24lambda_u2412.put("establish_time", it2);
                }
                Long l6 = sipSession.getCancelTime();
                if (l6 != null) {
                    it2 = ((Number)l6).longValue();
                    boolean bl9 = false;
                    $this$invoke_u24lambda_u2413_u24lambda_u2412.put("cancel_time", it2);
                }
                Long l7 = sipSession.getDisconnectTime();
                if (l7 != null) {
                    it2 = ((Number)l7).longValue();
                    boolean bl10 = false;
                    $this$invoke_u24lambda_u2413_u24lambda_u2412.put("disconnect_time", it2);
                }
                String string4 = sipSession.getTerminatedBy();
                if (string4 != null) {
                    it = string4;
                    boolean bl11 = false;
                    $this$invoke_u24lambda_u2413_u24lambda_u2412.put("terminated_by", it);
                }
                String string5 = sipSession.getErrorCode();
                if (string5 != null) {
                    it = string5;
                    boolean bl12 = false;
                    $this$invoke_u24lambda_u2413_u24lambda_u2412.put("error_code", it);
                }
                String string6 = sipSession.getErrorType();
                if (string6 != null) {
                    it = string6;
                    boolean bl13 = false;
                    $this$invoke_u24lambda_u2413_u24lambda_u2412.put("error_type", it);
                }
                $this$invoke_u24lambda_u2413_u24lambda_u2412.put("transactions", sipSession.getTransactions());
                $this$invoke_u24lambda_u2413_u24lambda_u2412.put("retransmits", sipSession.getRetransmits());
                Map<String, Object> $this$forEach$iv = sipSession.getAttributes();
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, Object> element$iv;
                    Map.Entry<String, Object> entry = element$iv = iterator2.next();
                    boolean bl14 = false;
                    String k = entry.getKey();
                    Object v = entry.getValue();
                    $this$invoke_u24lambda_u2413_u24lambda_u2412.put(k, v);
                }
                Unit unit = Unit.INSTANCE;
                map4.put(string3, map3);
                return map2;
            }
        }, (Function1<? super AsyncResult<Pair<Boolean, Map<String, Object>>>, Unit>)new Function1<AsyncResult<Pair<? extends Boolean, ? extends Map<String, ? extends Object>>>, Unit>(this, session2){
            final /* synthetic */ SipCallHandler this$0;
            final /* synthetic */ SipSession $session;
            {
                this.this$0 = $receiver;
                this.$session = $session;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull AsyncResult<Pair<Boolean, Map<String, Object>>> asr) {
                void $this$forEach$iv;
                Map<String, Object> attributes;
                Intrinsics.checkNotNullParameter(asr, "asr");
                Map<String, Object> map2 = attributes = asr.result().component2();
                SipSession sipSession = this.$session;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> entry = element$iv = iterator2.next();
                    boolean bl = false;
                    String k = (String)entry.getKey();
                    V v = entry.getValue();
                    sipSession.getAttributes().put(k, v);
                }
                this.this$0.writeAttributes(this.$session);
                this.this$0.writeToDatabase("sip_call", this.$session, Intrinsics.areEqual(this.$session.getState(), "answered"));
                this.this$0.sendToCorrelationHandlerIfNeeded(this.$session);
                this.this$0.calculateCallSessionMetrics(this.$session);
            }
        });
    }

    public void calculateActiveCallSessions(@NotNull String hostsKey, @NotNull AtomicInteger counter) {
        Map map2;
        Intrinsics.checkNotNullParameter(hostsKey, "hostsKey");
        Intrinsics.checkNotNullParameter(counter, "counter");
        String[] stringArray = new String[]{":"};
        List hosts = StringsKt.split$default((CharSequence)hostsKey, stringArray, false, 0, 6, null);
        Map $this$calculateActiveCallSessions_u24lambda_u2429 = map2 = (Map)new LinkedHashMap();
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)hosts.get(0))) {
            $this$calculateActiveCallSessions_u24lambda_u2429.put("src_host", hosts.get(0));
        }
        if (!StringsKt.isBlank((CharSequence)hosts.get(1))) {
            $this$calculateActiveCallSessions_u24lambda_u2429.put("dst_host", hosts.get(1));
        }
        Map attributes = map2;
        Metrics.INSTANCE.counter(ESTABLISHED, attributes).increment(counter.doubleValue());
    }

    public void calculateCallSessionMetrics(@NotNull SipSession session2) {
        block6: {
            String it;
            Map<String, Object> map2;
            Intrinsics.checkNotNullParameter(session2, "session");
            Map<String, Object> $this$calculateCallSessionMetrics_u24lambda_u2432 = map2 = AttributeUtilKt.toMetricsAttributes(session2.getAttributes(), EXCLUDED_ATTRIBUTES);
            boolean bl = false;
            $this$calculateCallSessionMetrics_u24lambda_u2432.put("state", session2.getState());
            String string = session2.getSrcAddr().getHost();
            if (string != null) {
                it = string;
                boolean bl2 = false;
                $this$calculateCallSessionMetrics_u24lambda_u2432.put("src_host", it);
            }
            String string2 = session2.getDstAddr().getHost();
            if (string2 != null) {
                it = string2;
                boolean bl3 = false;
                $this$calculateCallSessionMetrics_u24lambda_u2432.put("dst_host", it);
            }
            Map<String, Object> attributes = map2;
            Metrics.INSTANCE.counter(TRANSACTIONS, attributes).increment(session2.getTransactions());
            Metrics.INSTANCE.counter(RETRANSMITS, attributes).increment(session2.getRetransmits());
            Map<String, Object> $this$calculateCallSessionMetrics_u24lambda_u2436 = map2 = attributes;
            boolean bl4 = false;
            String string3 = session2.getTerminatedBy();
            if (string3 != null) {
                it = string3;
                boolean bl5 = false;
                $this$calculateCallSessionMetrics_u24lambda_u2436.put("terminated_by", it);
            }
            String string4 = session2.getErrorCode();
            if (string4 != null) {
                it = string4;
                boolean bl6 = false;
                $this$calculateCallSessionMetrics_u24lambda_u2436.put("error_code", it);
            }
            String string5 = session2.getErrorType();
            if (string5 != null) {
                it = string5;
                boolean bl7 = false;
                $this$calculateCallSessionMetrics_u24lambda_u2436.put("error_type", it);
            }
            Metrics.INSTANCE.counter(ATTEMPTS, attributes).increment();
            Long l = session2.getDuration();
            if (l == null) break block6;
            long duration = ((Number)l).longValue();
            boolean bl8 = false;
            Long l2 = this.durationDistributions.ceilingKey(duration);
            if (l2 != null) {
                long it2 = ((Number)l2).longValue();
                boolean bl9 = false;
                String string6 = this.durationDistributions.get(it2);
                Intrinsics.checkNotNull(string6);
                attributes.put("distribution", string6);
            }
            Metrics.INSTANCE.summary(DURATION, attributes).record(duration);
        }
    }

    public void writeAttributes(@NotNull SipSession session2) {
        String it;
        long it2;
        Object object;
        Map map2;
        Intrinsics.checkNotNullParameter(session2, "session");
        Map $this$writeAttributes_u24lambda_u2450 = map2 = AttributeUtilKt.toAttributes$default(session2.getAttributes(), null, 1, null);
        boolean bl = false;
        $this$writeAttributes_u24lambda_u2450.put("method", "INVITE");
        $this$writeAttributes_u24lambda_u2450.put("state", session2.getState());
        Address src = session2.getSrcAddr();
        $this$writeAttributes_u24lambda_u2450.put("src_addr", this.recordIpAddressesAttributes ? src.getAddr() : "");
        String string = src.getHost();
        if (string != null) {
            String it3 = string;
            boolean bl2 = false;
            $this$writeAttributes_u24lambda_u2450.put("src_host", it3);
        }
        Address dst = session2.getDstAddr();
        $this$writeAttributes_u24lambda_u2450.put("dst_addr", this.recordIpAddressesAttributes ? dst.getAddr() : "");
        String string2 = dst.getHost();
        if (string2 != null) {
            String it4 = string2;
            boolean bl3 = false;
            $this$writeAttributes_u24lambda_u2450.put("dst_host", it4);
        }
        if ((object = $this$writeAttributes_u24lambda_u2450.get("caller")) == null) {
            object = session2.getCaller();
        }
        Object caller = object;
        $this$writeAttributes_u24lambda_u2450.put("caller", this.recordCallUsersAttributes ? caller : "");
        Object object2 = $this$writeAttributes_u24lambda_u2450.get("callee");
        if (object2 == null) {
            object2 = session2.getCallee();
        }
        Object callee = object2;
        $this$writeAttributes_u24lambda_u2450.put("callee", this.recordCallUsersAttributes ? callee : "");
        $this$writeAttributes_u24lambda_u2450.put("call_id", "");
        Long l = session2.getDuration();
        if (l != null) {
            it2 = ((Number)l).longValue();
            boolean bl4 = false;
            $this$writeAttributes_u24lambda_u2450.put("duration", it2);
        }
        Long l2 = session2.getTryingDelay();
        if (l2 != null) {
            it2 = ((Number)l2).longValue();
            boolean bl5 = false;
            $this$writeAttributes_u24lambda_u2450.put("trying_delay", it2);
        }
        Long l3 = session2.getSetupTime();
        if (l3 != null) {
            it2 = ((Number)l3).longValue();
            boolean bl6 = false;
            $this$writeAttributes_u24lambda_u2450.put("setup_time", it2);
        }
        Long l4 = session2.getEstablishTime();
        if (l4 != null) {
            it2 = ((Number)l4).longValue();
            boolean bl7 = false;
            $this$writeAttributes_u24lambda_u2450.put("establish_time", it2);
        }
        Long l5 = session2.getCancelTime();
        if (l5 != null) {
            it2 = ((Number)l5).longValue();
            boolean bl8 = false;
            $this$writeAttributes_u24lambda_u2450.put("cancel_time", it2);
        }
        Long l6 = session2.getDisconnectTime();
        if (l6 != null) {
            it2 = ((Number)l6).longValue();
            boolean bl9 = false;
            $this$writeAttributes_u24lambda_u2450.put("disconnect_time", it2);
        }
        String string3 = session2.getTerminatedBy();
        if (string3 != null) {
            it = string3;
            boolean bl10 = false;
            $this$writeAttributes_u24lambda_u2450.put("terminated_by", it);
        }
        String string4 = session2.getErrorCode();
        if (string4 != null) {
            it = string4;
            boolean bl11 = false;
            $this$writeAttributes_u24lambda_u2450.put("error_code", it);
        }
        String string5 = session2.getErrorType();
        if (string5 != null) {
            it = string5;
            boolean bl12 = false;
            $this$writeAttributes_u24lambda_u2450.put("error_type", it);
        }
        $this$writeAttributes_u24lambda_u2450.put("transactions", session2.getTransactions());
        $this$writeAttributes_u24lambda_u2450.put("retransmits", session2.getRetransmits());
        $this$writeAttributes_u24lambda_u2450.remove("x_call_id");
        $this$writeAttributes_u24lambda_u2450.remove("recording_mode");
        Map attributes = map2;
        AttributesRegistry attributesRegistry = this.attributesRegistry;
        if (attributesRegistry == null) {
            Intrinsics.throwUninitializedPropertyAccessException("attributesRegistry");
            attributesRegistry = null;
        }
        attributesRegistry.handle("sip", attributes);
    }

    public void sendToCorrelationHandlerIfNeeded(@NotNull SipSession session2) {
        Intrinsics.checkNotNullParameter(session2, "session");
        if (this.correlationRole == null) {
            return;
        }
        Object object = new JsonObject();
        JsonObject $this$sendToCorrelationHandlerIfNeeded_u24lambda_u2453 = object;
        boolean bl = false;
        $this$sendToCorrelationHandlerIfNeeded_u24lambda_u2453.put("created_at", session2.getCreatedAt());
        Long l = session2.getTerminatedAt();
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl2 = false;
            $this$sendToCorrelationHandlerIfNeeded_u24lambda_u2453.put("terminated_at", it);
        }
        Address src = session2.getSrcAddr();
        String string = src.getHost();
        if (string == null) {
            string = src.getAddr();
        }
        $this$sendToCorrelationHandlerIfNeeded_u24lambda_u2453.put("src_host", string);
        Address dst = session2.getDstAddr();
        String string2 = dst.getHost();
        if (string2 == null) {
            string2 = dst.getAddr();
        }
        $this$sendToCorrelationHandlerIfNeeded_u24lambda_u2453.put("dst_host", string2);
        $this$sendToCorrelationHandlerIfNeeded_u24lambda_u2453.put("state", session2.getState());
        Object object2 = session2.getAttributes().get("caller");
        if (object2 == null) {
            object2 = session2.getCaller();
        }
        $this$sendToCorrelationHandlerIfNeeded_u24lambda_u2453.put("caller", object2);
        Object object3 = session2.getAttributes().get("callee");
        if (object3 == null) {
            object3 = session2.getCallee();
        }
        $this$sendToCorrelationHandlerIfNeeded_u24lambda_u2453.put("callee", object3);
        $this$sendToCorrelationHandlerIfNeeded_u24lambda_u2453.put("call_id", session2.getCallId());
        Object object4 = session2.getAttributes().get("x_call_id");
        if (object4 != null) {
            Object it = object4;
            boolean bl3 = false;
            $this$sendToCorrelationHandlerIfNeeded_u24lambda_u2453.put("x_call_id", it);
        }
        JsonObject correlationEvent = object;
        object = this.correlationRole;
        if (Intrinsics.areEqual(object, "aggregator")) {
            EventBus eventBus = this.vertx.eventBus();
            Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
            EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getSip() + "_call_correlation", correlationEvent, null, 4, null);
        } else if (Intrinsics.areEqual(object, "reporter")) {
            this.vertx.eventBus().send(RoutesCE.Companion.getSip() + "_call_correlation", correlationEvent);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeToDatabase(@NotNull String prefix, @NotNull SipSession session2, boolean upsert) {
        void $this$forEach$iv;
        Object it;
        long it2;
        Object object;
        void $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475;
        Unit unit;
        JsonObject $this$writeToDatabase_u24lambda_u2476_u24lambda_u2456;
        JsonObject jsonObject;
        String string;
        JsonObject jsonObject2;
        JsonObject $this$writeToDatabase_u24lambda_u2476;
        JsonObject jsonObject3;
        String collection;
        block28: {
            block32: {
                Address dst;
                Object object2;
                block31: {
                    block30: {
                        Object object3;
                        Address src;
                        block29: {
                            Intrinsics.checkNotNullParameter(prefix, "prefix");
                            Intrinsics.checkNotNullParameter(session2, "session");
                            collection = prefix + "_index_" + DateTimeFormatterUtilKt.format(this.timeSuffix, session2.getCreatedAt());
                            $this$writeToDatabase_u24lambda_u2476 = jsonObject3 = new JsonObject();
                            boolean bl = false;
                            if (!upsert) break block28;
                            $this$writeToDatabase_u24lambda_u2476.put("type", "UPDATE");
                            $this$writeToDatabase_u24lambda_u2476.put("upsert", true);
                            JsonObject jsonObject4 = jsonObject2 = new JsonObject();
                            string = "filter";
                            jsonObject = $this$writeToDatabase_u24lambda_u2476;
                            boolean bl2 = false;
                            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2456.put("call_id", session2.getCallId());
                            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2456.put("created_at", session2.getCreatedAt());
                            src = session2.getSrcAddr();
                            object3 = src.getHost();
                            if (object3 == null) break block29;
                            String it3 = object3;
                            boolean bl3 = false;
                            JsonObject jsonObject5 = $this$writeToDatabase_u24lambda_u2476_u24lambda_u2456.put("src_host", it3);
                            object3 = jsonObject5;
                            if (jsonObject5 != null) break block30;
                        }
                        object3 = $this$writeToDatabase_u24lambda_u2476_u24lambda_u2456.put("src_addr", src.getAddr());
                    }
                    if ((object2 = (dst = session2.getDstAddr()).getHost()) == null) break block31;
                    String it4 = object2;
                    boolean bl = false;
                    JsonObject jsonObject6 = $this$writeToDatabase_u24lambda_u2476_u24lambda_u2456.put("dst_host", it4);
                    object2 = jsonObject6;
                    if (jsonObject6 != null) break block32;
                }
                object2 = $this$writeToDatabase_u24lambda_u2476_u24lambda_u2456.put("dst_addr", dst.getAddr());
            }
            unit = Unit.INSTANCE;
            jsonObject.put(string, jsonObject2);
            JsonObject jsonObject7 = this.hint;
            if (jsonObject7 != null) {
                JsonObject it5 = jsonObject7;
                boolean bl = false;
                $this$writeToDatabase_u24lambda_u2476.put("hint", it5);
            }
        }
        $this$writeToDatabase_u24lambda_u2476_u24lambda_u2456 = jsonObject2 = new JsonObject();
        string = "document";
        jsonObject = $this$writeToDatabase_u24lambda_u2476;
        boolean bl = false;
        JsonObject document = $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475;
        Address src = session2.getSrcAddr();
        Address dst = session2.getDstAddr();
        if (upsert) {
            document = new JsonObject();
            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475.put("$setOnInsert", document);
        }
        JsonObject jsonObject8 = document;
        void $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2459 = jsonObject8;
        boolean bl4 = false;
        $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2459.put("created_at", session2.getCreatedAt());
        $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2459.put("src_addr", src.getAddr());
        $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2459.put("src_port", src.getPort());
        $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2459.put("dst_addr", dst.getAddr());
        $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2459.put("dst_port", dst.getPort());
        $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2459.put("call_id", session2.getCallId());
        Object object4 = session2.getAttributes().get("x_call_id");
        if (object4 != null) {
            Object it6 = object4;
            boolean bl5 = false;
            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2459.put("x_call_id", it6);
        }
        if ((object = session2.getAttributes().get("caller")) == null) {
            object = session2.getCaller();
        }
        $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2459.put("caller", object);
        Object object5 = session2.getAttributes().get("callee");
        if (object5 == null) {
            object5 = session2.getCallee();
        }
        $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2459.put("callee", object5);
        if (upsert) {
            document = new JsonObject();
            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475.put("$set", document);
        }
        JsonObject $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2474 = jsonObject8 = document;
        boolean bl6 = false;
        $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2474.put("state", session2.getState());
        Long l = session2.getTerminatedAt();
        if (l != null) {
            it2 = ((Number)l).longValue();
            boolean bl7 = false;
            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2474.put("terminated_at", it2);
        }
        String string2 = session2.getSrcAddr().getHost();
        if (string2 != null) {
            it = string2;
            boolean bl8 = false;
            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2474.put("src_host", it);
        }
        String string3 = session2.getDstAddr().getHost();
        if (string3 != null) {
            it = string3;
            boolean bl9 = false;
            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2474.put("dst_host", it);
        }
        Long l2 = session2.getDuration();
        if (l2 != null) {
            it2 = ((Number)l2).longValue();
            boolean bl10 = false;
            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2474.put("duration", it2);
        }
        Long l3 = session2.getTryingDelay();
        if (l3 != null) {
            it2 = ((Number)l3).longValue();
            boolean bl11 = false;
            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2474.put("trying_delay", it2);
        }
        Long l4 = session2.getSetupTime();
        if (l4 != null) {
            it2 = ((Number)l4).longValue();
            boolean bl12 = false;
            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2474.put("setup_time", it2);
        }
        Long l5 = session2.getEstablishTime();
        if (l5 != null) {
            it2 = ((Number)l5).longValue();
            boolean bl13 = false;
            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2474.put("establish_time", it2);
        }
        Long l6 = session2.getCancelTime();
        if (l6 != null) {
            it2 = ((Number)l6).longValue();
            boolean bl14 = false;
            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2474.put("cancel_time", it2);
        }
        Long l7 = session2.getDisconnectTime();
        if (l7 != null) {
            it2 = ((Number)l7).longValue();
            boolean bl15 = false;
            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2474.put("disconnect_time", it2);
        }
        String string4 = session2.getTerminatedBy();
        if (string4 != null) {
            it = string4;
            boolean bl16 = false;
            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2474.put("terminated_by", it);
        }
        String string5 = session2.getErrorCode();
        if (string5 != null) {
            it = string5;
            boolean bl17 = false;
            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2474.put("error_code", it);
        }
        String string6 = session2.getErrorType();
        if (string6 != null) {
            it = string6;
            boolean bl18 = false;
            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2474.put("error_type", it);
        }
        $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2474.put("transactions", session2.getTransactions());
        $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2474.put("retransmits", session2.getRetransmits());
        Object object6 = session2.getAttributes().get("debug");
        if (object6 != null) {
            it = object6;
            boolean bl19 = false;
            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2474.put("debug", it);
        }
        Map<String, Object> map2 = AttributeUtilKt.toDatabaseAttributes(session2.getAttributes(), EXCLUDED_ATTRIBUTES);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl20 = false;
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            $this$writeToDatabase_u24lambda_u2476_u24lambda_u2475_u24lambda_u2474.put(name, value);
        }
        unit = Unit.INSTANCE;
        jsonObject.put(string, jsonObject2);
        JsonObject operation = jsonObject3;
        EventBus eventBus = this.vertx.eventBus();
        Intrinsics.checkNotNullExpressionValue(eventBus, "vertx.eventBus()");
        EventBusUtilKt.localSend$default(eventBus, RoutesCE.Companion.getMongo_bulk_writer(), new Pair<CallSite, JsonObject>((CallSite)((Object)collection), operation), null, 4, null);
    }

    public static /* synthetic */ void writeToDatabase$default(SipCallHandler sipCallHandler, String string, SipSession sipSession, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeToDatabase");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        sipCallHandler.writeToDatabase(string, sipSession, bl);
    }

    public static final /* synthetic */ KLogger access$getLogger$p(SipCallHandler $this) {
        return $this.logger;
    }

    public static final /* synthetic */ void access$setHint$p(SipCallHandler $this, JsonObject jsonObject) {
        $this.hint = jsonObject;
    }

    public static final /* synthetic */ Vertx access$getVertx$p$s-529614350(SipCallHandler $this) {
        return $this.vertx;
    }

    static {
        String[] stringArray = new String[]{"caller", "callee", "x_call_id", "recording_mode", "debug"};
        EXCLUDED_ATTRIBUTES = CollectionsKt.listOf(stringArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/sip3/salto/ce/sip/SipCallHandler$Companion;", "", "()V", "ANSWERED", "", "ATTEMPTS", "CANCELED", "DISCONNECT_TIME", "DURATION", "ESTABLISHED", "ESTABLISH_TIME", "EXCLUDED_ATTRIBUTES", "", "getEXCLUDED_ATTRIBUTES", "()Ljava/util/List;", "FAILED", "PREFIX", "REDIRECTED", "RETRANSMITS", "SETUP_TIME", "TRANSACTIONS", "TRYING_DELAY", "UNAUTHORIZED", "UNKNOWN", "sip3-salto-ce"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getEXCLUDED_ATTRIBUTES() {
            return EXCLUDED_ATTRIBUTES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020[J\u000e\u0010\\\u001a\u00020Y2\u0006\u0010Z\u001a\u00020[J\u000e\u0010]\u001a\u00020Y2\u0006\u0010Z\u001a\u00020[R\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u001d\u0010\u0006\"\u0004\b\u001e\u0010\bR\u001a\u0010\u001f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001e\u0010$\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b%\u0010\u0006\"\u0004\b&\u0010\bR\u001a\u0010'\u001a\u00020(X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001e\u0010-\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b.\u0010\u0006\"\u0004\b/\u0010\bR\u001c\u00100\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0013\"\u0004\b2\u0010\u0015R\u001c\u00103\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0013\"\u0004\b5\u0010\u0015R\u001e\u00106\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b7\u0010\u0006\"\u0004\b8\u0010\bR\u001b\u00109\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b:\u0010\u0013R\u001a\u0010=\u001a\u00020>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001e\u0010C\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\bD\u0010\u0006\"\u0004\bE\u0010\bR\u001a\u0010F\u001a\u00020(X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010*\"\u0004\bH\u0010,R\u001a\u0010I\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010\u0013\"\u0004\bK\u0010\u0015R\u001e\u0010L\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\bM\u0010\u0006\"\u0004\bN\u0010\bR\u001c\u0010O\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010\u0013\"\u0004\bQ\u0010\u0015R\u001a\u0010R\u001a\u00020>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010@\"\u0004\bT\u0010BR\u001e\u0010U\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\bV\u0010\u0006\"\u0004\bW\u0010\b\u00a8\u0006^"}, d2={"Lio/sip3/salto/ce/sip/SipCallHandler$SipSession;", "", "(Lio/sip3/salto/ce/sip/SipCallHandler;)V", "answeredAt", "", "getAnsweredAt", "()Ljava/lang/Long;", "setAnsweredAt", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "attributes", "", "", "getAttributes", "()Ljava/util/Map;", "setAttributes", "(Ljava/util/Map;)V", "callId", "getCallId", "()Ljava/lang/String;", "setCallId", "(Ljava/lang/String;)V", "callee", "getCallee", "setCallee", "caller", "getCaller", "setCaller", "cancelTime", "getCancelTime", "setCancelTime", "createdAt", "getCreatedAt", "()J", "setCreatedAt", "(J)V", "disconnectTime", "getDisconnectTime", "setDisconnectTime", "dstAddr", "Lio/sip3/salto/ce/domain/Address;", "getDstAddr", "()Lio/sip3/salto/ce/domain/Address;", "setDstAddr", "(Lio/sip3/salto/ce/domain/Address;)V", "duration", "getDuration", "setDuration", "errorCode", "getErrorCode", "setErrorCode", "errorType", "getErrorType", "setErrorType", "establishTime", "getEstablishTime", "setEstablishTime", "legId", "getLegId", "legId$delegate", "Lkotlin/Lazy;", "retransmits", "", "getRetransmits", "()I", "setRetransmits", "(I)V", "setupTime", "getSetupTime", "setSetupTime", "srcAddr", "getSrcAddr", "setSrcAddr", "state", "getState", "setState", "terminatedAt", "getTerminatedAt", "setTerminatedAt", "terminatedBy", "getTerminatedBy", "setTerminatedBy", "transactions", "getTransactions", "setTransactions", "tryingDelay", "getTryingDelay", "setTryingDelay", "addByeTransaction", "", "transaction", "Lio/sip3/salto/ce/sip/SipTransaction;", "addInviteTransaction", "addTransaction", "sip3-salto-ce"})
    public final class SipSession {
        @NotNull
        private String state = "unknown";
        private long createdAt;
        @Nullable
        private Long answeredAt;
        @Nullable
        private Long terminatedAt;
        public Address srcAddr;
        public Address dstAddr;
        public String callId;
        public String callee;
        public String caller;
        @Nullable
        private Long duration;
        @Nullable
        private Long tryingDelay;
        @Nullable
        private Long setupTime;
        @Nullable
        private Long establishTime;
        @Nullable
        private Long cancelTime;
        @Nullable
        private Long disconnectTime;
        @Nullable
        private String terminatedBy;
        @Nullable
        private String errorCode;
        @Nullable
        private String errorType;
        private int transactions;
        private int retransmits;
        @NotNull
        private Map<String, Object> attributes = new LinkedHashMap();
        @NotNull
        private final Lazy legId$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ SipSession this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.this$0.getSrcAddr().compositeKey(this.this$0.getDstAddr());
            }
        });

        @NotNull
        public final String getState() {
            return this.state;
        }

        public final void setState(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.state = string;
        }

        public final long getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(long l) {
            this.createdAt = l;
        }

        @Nullable
        public final Long getAnsweredAt() {
            return this.answeredAt;
        }

        public final void setAnsweredAt(@Nullable Long l) {
            this.answeredAt = l;
        }

        @Nullable
        public final Long getTerminatedAt() {
            return this.terminatedAt;
        }

        public final void setTerminatedAt(@Nullable Long l) {
            this.terminatedAt = l;
        }

        @NotNull
        public final Address getSrcAddr() {
            Address address = this.srcAddr;
            if (address != null) {
                return address;
            }
            Intrinsics.throwUninitializedPropertyAccessException("srcAddr");
            return null;
        }

        public final void setSrcAddr(@NotNull Address address) {
            Intrinsics.checkNotNullParameter(address, "<set-?>");
            this.srcAddr = address;
        }

        @NotNull
        public final Address getDstAddr() {
            Address address = this.dstAddr;
            if (address != null) {
                return address;
            }
            Intrinsics.throwUninitializedPropertyAccessException("dstAddr");
            return null;
        }

        public final void setDstAddr(@NotNull Address address) {
            Intrinsics.checkNotNullParameter(address, "<set-?>");
            this.dstAddr = address;
        }

        @NotNull
        public final String getCallId() {
            String string = this.callId;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException("callId");
            return null;
        }

        public final void setCallId(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.callId = string;
        }

        @NotNull
        public final String getCallee() {
            String string = this.callee;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException("callee");
            return null;
        }

        public final void setCallee(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.callee = string;
        }

        @NotNull
        public final String getCaller() {
            String string = this.caller;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException("caller");
            return null;
        }

        public final void setCaller(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.caller = string;
        }

        @Nullable
        public final Long getDuration() {
            return this.duration;
        }

        public final void setDuration(@Nullable Long l) {
            this.duration = l;
        }

        @Nullable
        public final Long getTryingDelay() {
            return this.tryingDelay;
        }

        public final void setTryingDelay(@Nullable Long l) {
            this.tryingDelay = l;
        }

        @Nullable
        public final Long getSetupTime() {
            return this.setupTime;
        }

        public final void setSetupTime(@Nullable Long l) {
            this.setupTime = l;
        }

        @Nullable
        public final Long getEstablishTime() {
            return this.establishTime;
        }

        public final void setEstablishTime(@Nullable Long l) {
            this.establishTime = l;
        }

        @Nullable
        public final Long getCancelTime() {
            return this.cancelTime;
        }

        public final void setCancelTime(@Nullable Long l) {
            this.cancelTime = l;
        }

        @Nullable
        public final Long getDisconnectTime() {
            return this.disconnectTime;
        }

        public final void setDisconnectTime(@Nullable Long l) {
            this.disconnectTime = l;
        }

        @Nullable
        public final String getTerminatedBy() {
            return this.terminatedBy;
        }

        public final void setTerminatedBy(@Nullable String string) {
            this.terminatedBy = string;
        }

        @Nullable
        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(@Nullable String string) {
            this.errorCode = string;
        }

        @Nullable
        public final String getErrorType() {
            return this.errorType;
        }

        public final void setErrorType(@Nullable String string) {
            this.errorType = string;
        }

        public final int getTransactions() {
            return this.transactions;
        }

        public final void setTransactions(int n) {
            this.transactions = n;
        }

        public final int getRetransmits() {
            return this.retransmits;
        }

        public final void setRetransmits(int n) {
            this.retransmits = n;
        }

        @NotNull
        public final Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public final void setAttributes(@NotNull Map<String, Object> map2) {
            Intrinsics.checkNotNullParameter(map2, "<set-?>");
            this.attributes = map2;
        }

        @NotNull
        public final String getLegId() {
            Lazy lazy = this.legId$delegate;
            return (String)lazy.getValue();
        }

        public final void addInviteTransaction(@NotNull SipTransaction transaction2) {
            block27: {
                Intrinsics.checkNotNullParameter(transaction2, "transaction");
                int n = this.transactions;
                this.transactions = n + 1;
                this.retransmits += transaction2.getRetransmits();
                if (this.createdAt == 0L) {
                    this.createdAt = transaction2.getCreatedAt();
                    this.setSrcAddr(transaction2.getSrcAddr());
                    this.setDstAddr(transaction2.getDstAddr());
                    this.setCallId(transaction2.getCallId());
                    this.setCallee(transaction2.getCallee());
                    this.setCaller(transaction2.getCaller());
                }
                if (Intrinsics.areEqual(this.state, SipCallHandler.ANSWERED)) break block27;
                Long l = transaction2.getTryingAt();
                if (l != null) {
                    long tryingAt = ((Number)l).longValue();
                    boolean bl = false;
                    this.tryingDelay = tryingAt - this.createdAt;
                }
                switch (transaction2.getState()) {
                    case "succeed": {
                        this.state = SipCallHandler.ANSWERED;
                        Long l2 = transaction2.getTerminatedAt();
                        if (l2 == null) {
                            l2 = transaction2.getCreatedAt();
                        }
                        this.answeredAt = l2;
                        Long l3 = transaction2.getRingingAt();
                        if (l3 != null) {
                            long ringingAt = ((Number)l3).longValue();
                            boolean bl = false;
                            this.setupTime = ringingAt - this.createdAt;
                        }
                        Long l4 = transaction2.getTerminatedAt();
                        if (l4 != null) {
                            long terminatedAt = ((Number)l4).longValue();
                            boolean bl = false;
                            this.establishTime = terminatedAt - this.createdAt;
                        }
                        break;
                    }
                    case "redirected": {
                        this.state = SipCallHandler.REDIRECTED;
                        Long l5 = transaction2.getTerminatedAt();
                        if (l5 == null) {
                            l5 = transaction2.getCreatedAt();
                        }
                        this.terminatedAt = l5;
                        break;
                    }
                    case "unauthorized": {
                        this.state = SipCallHandler.UNAUTHORIZED;
                        break;
                    }
                    case "canceled": {
                        this.state = SipCallHandler.CANCELED;
                        Long l6 = transaction2.getTerminatedAt();
                        long terminatedAt = l6 != null ? l6.longValue() : transaction2.getCreatedAt();
                        boolean bl = false;
                        this.terminatedAt = terminatedAt;
                        if (terminatedAt <= this.createdAt) break;
                        this.cancelTime = terminatedAt - this.createdAt;
                        break;
                    }
                    case "failed": {
                        this.state = SipCallHandler.FAILED;
                        Long l7 = transaction2.getTerminatedAt();
                        if (l7 == null) {
                            l7 = transaction2.getCreatedAt();
                        }
                        this.terminatedAt = l7;
                    }
                }
            }
            this.errorCode = transaction2.getErrorCode();
            this.errorType = transaction2.getErrorType();
            Map<String, Object> $this$forEach$iv = transaction2.getAttributes();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> entry = element$iv = iterator2.next();
                boolean bl = false;
                String name = entry.getKey();
                Object value = entry.getValue();
                this.attributes.put(name, value);
            }
        }

        public final void addByeTransaction(@NotNull SipTransaction transaction2) {
            Intrinsics.checkNotNullParameter(transaction2, "transaction");
            int n = this.transactions;
            this.transactions = n + 1;
            this.retransmits += transaction2.getRetransmits();
            if (this.terminatedAt == null) {
                Long l = transaction2.getTerminatedAt();
                if (l == null) {
                    l = transaction2.getCreatedAt();
                }
                Long l2 = this.terminatedAt = l;
                if (l2 != null) {
                    long it = ((Number)l2).longValue();
                    boolean bl = false;
                    this.disconnectTime = it - transaction2.getCreatedAt();
                }
                Long l3 = this.answeredAt;
                if (l3 != null) {
                    long answeredAt = ((Number)l3).longValue();
                    boolean bl = false;
                    this.duration = transaction2.getCreatedAt() - answeredAt;
                }
                this.terminatedBy = Intrinsics.areEqual(this.getCaller(), transaction2.getCaller()) ? "caller" : "callee";
            }
            this.errorCode = transaction2.getErrorCode();
            this.errorType = transaction2.getErrorType();
            Map<String, Object> $this$forEach$iv = transaction2.getAttributes();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> entry = element$iv = iterator2.next();
                boolean bl = false;
                String name = entry.getKey();
                Object value = entry.getValue();
                this.attributes.put(name, value);
            }
        }

        public final void addTransaction(@NotNull SipTransaction transaction2) {
            Intrinsics.checkNotNullParameter(transaction2, "transaction");
            int n = this.transactions;
            this.transactions = n + 1;
            this.retransmits += transaction2.getRetransmits();
            Map<String, Object> $this$forEach$iv = transaction2.getAttributes();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Object>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Object> element$iv;
                Map.Entry<String, Object> entry = element$iv = iterator2.next();
                boolean bl = false;
                String name = entry.getKey();
                Object value = entry.getValue();
                this.attributes.put(name, value);
            }
        }
    }
}

