/*
 * Decompiled with CFR 0.152.
 */
package io.sip3.salto.ce.management.component;

import io.sip3.salto.ce.management.component.ComponentRegistry;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.kotlin.ext.mongo.UpdateOptionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00150\u0014J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0004J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\u000e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/sip3/salto/ce/management/component/ComponentRegistry;", "", "()V", "COLLECTION", "", "cleanupTimeout", "", "client", "Lio/vertx/ext/mongo/MongoClient;", "config", "Lio/vertx/core/json/JsonObject;", "expirationDelay", "logger", "Lmu/KLogger;", "vertx", "Lio/vertx/core/Vertx;", "getInstance", "init", "", "list", "Lio/vertx/core/Future;", "", "remove", "deploymentId", "removeExpired", "save", "component", "sip3-salto-ce"})
public final class ComponentRegistry {
    @NotNull
    public static final ComponentRegistry INSTANCE = new ComponentRegistry();
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(logger.1.INSTANCE);
    @NotNull
    private static final String COLLECTION = "components";
    private static long expirationDelay = 30000L;
    private static long cleanupTimeout = 300000L;
    @Nullable
    private static Vertx vertx;
    private static JsonObject config;
    private static MongoClient client;

    private ComponentRegistry() {
    }

    @NotNull
    public final synchronized ComponentRegistry getInstance(@NotNull Vertx vertx, @NotNull JsonObject config2) {
        Intrinsics.checkNotNullParameter(vertx, "vertx");
        Intrinsics.checkNotNullParameter(config2, "config");
        if (ComponentRegistry.vertx == null) {
            ComponentRegistry.vertx = vertx;
            config = config2;
            this.init();
        }
        return this;
    }

    private final void init() {
        JsonObject jsonObject;
        JsonObject jsonObject2 = config;
        if (jsonObject2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            jsonObject2 = null;
        }
        JsonObject jsonObject3 = jsonObject2.getJsonObject("management");
        if (jsonObject3 != null) {
            long it;
            Long l;
            JsonObject components = jsonObject3;
            boolean bl = false;
            Long l2 = l = components.getLong("expiration_delay");
            if (l2 != null) {
                Intrinsics.checkNotNullExpressionValue(l2, "getLong(\"expiration_delay\")");
                it = ((Number)l).longValue();
                boolean bl2 = false;
                expirationDelay = it;
            }
            Long l3 = l = components.getLong("cleanup_timeout");
            if (l3 != null) {
                Intrinsics.checkNotNullExpressionValue(l3, "getLong(\"cleanup_timeout\")");
                it = ((Number)l).longValue();
                boolean bl3 = false;
                cleanupTimeout = it;
            }
        }
        if ((jsonObject = config) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("config");
            jsonObject = null;
        }
        JsonObject it = jsonObject.getJsonObject("mongo");
        boolean bl = false;
        Vertx vertx = ComponentRegistry.vertx;
        Intrinsics.checkNotNull(vertx);
        JsonObject jsonObject4 = it.getJsonObject("management");
        if (jsonObject4 == null) {
            jsonObject4 = it;
        }
        Intrinsics.checkNotNullExpressionValue(jsonObject4, "it.getJsonObject(\"management\") ?: it");
        client = io.sip3.commons.mongo.MongoClient.INSTANCE.createShared(vertx, jsonObject4);
        Vertx vertx2 = ComponentRegistry.vertx;
        Intrinsics.checkNotNull(vertx2);
        vertx2.setPeriodic(expirationDelay, ComponentRegistry::init$lambda$4);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeExpired() {
        void $this$removeExpired_u24lambda_u246_u24lambda_u245;
        JsonObject jsonObject;
        JsonObject jsonObject2;
        JsonObject $this$removeExpired_u24lambda_u246 = jsonObject2 = new JsonObject();
        boolean bl = false;
        JsonObject jsonObject3 = jsonObject = new JsonObject();
        String string = "updated_at";
        JsonObject jsonObject4 = $this$removeExpired_u24lambda_u246;
        boolean bl2 = false;
        $this$removeExpired_u24lambda_u246_u24lambda_u245.put("$lt", System.currentTimeMillis() - cleanupTimeout);
        Unit unit = Unit.INSTANCE;
        jsonObject4.put(string, jsonObject);
        JsonObject query = jsonObject2;
        MongoClient mongoClient = client;
        if (mongoClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException("client");
            mongoClient = null;
        }
        mongoClient.removeDocuments(COLLECTION, query).onFailure(ComponentRegistry::removeExpired$lambda$7).onSuccess(ComponentRegistry::removeExpired$lambda$10);
    }

    @NotNull
    public final Future<List<JsonObject>> list() {
        MongoClient mongoClient = client;
        if (mongoClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException("client");
            mongoClient = null;
        }
        Future<List<JsonObject>> future = mongoClient.find(COLLECTION, new JsonObject());
        Intrinsics.checkNotNullExpressionValue(future, "client.find(COLLECTION, JsonObject())");
        return future;
    }

    public final void save(@NotNull JsonObject component2) {
        JsonObject jsonObject;
        Intrinsics.checkNotNullParameter(component2, "component");
        JsonObject $this$save_u24lambda_u2411 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$save_u24lambda_u2411.put("deployment_id", component2.getString("deployment_id"));
        JsonObject query = jsonObject;
        MongoClient mongoClient = client;
        if (mongoClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException("client");
            mongoClient = null;
        }
        mongoClient.replaceDocumentsWithOptions(COLLECTION, query, component2, UpdateOptionsKt.updateOptionsOf$default(null, null, null, null, null, null, true, null, 191, null)).onFailure(ComponentRegistry::save$lambda$12);
    }

    public final void remove(@NotNull String deploymentId) {
        JsonObject jsonObject;
        Intrinsics.checkNotNullParameter(deploymentId, "deploymentId");
        JsonObject $this$remove_u24lambda_u2413 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$remove_u24lambda_u2413.put("deployment_id", deploymentId);
        JsonObject query = jsonObject;
        MongoClient mongoClient = client;
        if (mongoClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException("client");
            mongoClient = null;
        }
        mongoClient.removeDocument(COLLECTION, query).onFailure(ComponentRegistry::remove$lambda$14);
    }

    private static final void init$lambda$4(Long it) {
        INSTANCE.removeExpired();
    }

    private static final void removeExpired$lambda$7(Throwable it) {
        logger.error(it, (Function0<? extends Object>)removeExpired.1.1.INSTANCE);
    }

    private static final void removeExpired$lambda$10(MongoClientDeleteResult result2) {
        block1: {
            Object object = result2;
            if (object == null) break block1;
            Long l = ((MongoClientDeleteResult)object).getRemovedCount();
            long it = ((Number)l).longValue();
            boolean bl = false;
            object = it > 0L ? l : null;
            if (object != null) {
                long removedCount = ((Number)object).longValue();
                boolean bl2 = false;
                logger.info((Function0<? extends Object>)new Function0<Object>(removedCount){
                    final /* synthetic */ long $removedCount;
                    {
                        this.$removedCount = $removedCount;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Removed expired components: " + this.$removedCount;
                    }
                });
            }
        }
    }

    private static final void save$lambda$12(Throwable it) {
        logger.error(it, (Function0<? extends Object>)save.1.1.INSTANCE);
    }

    private static final void remove$lambda$14(Throwable it) {
        logger.error(it, (Function0<? extends Object>)remove.1.1.INSTANCE);
    }
}

