/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.InnerProducer;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.core.publisher.SourceProducer;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

final class FluxRange
extends Flux<Integer>
implements Fuseable,
SourceProducer<Integer> {
    final long start;
    final long end;

    FluxRange(int start2, int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException("count >= required but it was " + count2);
        }
        long e = (long)start2 + (long)count2;
        if (e - 1L > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("start + count must be less than Integer.MAX_VALUE + 1");
        }
        this.start = start2;
        this.end = e;
    }

    @Override
    public void subscribe(CoreSubscriber<? super Integer> actual) {
        long st = this.start;
        long en = this.end;
        if (st == en) {
            Operators.complete(actual);
            return;
        }
        if (st + 1L == en) {
            actual.onSubscribe(Operators.scalarSubscription(actual, (int)st));
            return;
        }
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            actual.onSubscribe(new RangeSubscriptionConditional((Fuseable.ConditionalSubscriber)actual, st, en));
            return;
        }
        actual.onSubscribe(new RangeSubscription(actual, st, en));
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }

    static final class RangeSubscriptionConditional
    implements InnerProducer<Integer>,
    Fuseable.SynchronousSubscription<Integer> {
        final Fuseable.ConditionalSubscriber<? super Integer> actual;
        final long end;
        volatile boolean cancelled;
        long index;
        volatile long requested;
        static final AtomicLongFieldUpdater<RangeSubscriptionConditional> REQUESTED = AtomicLongFieldUpdater.newUpdater(RangeSubscriptionConditional.class, "requested");

        RangeSubscriptionConditional(Fuseable.ConditionalSubscriber<? super Integer> actual, long start2, long end) {
            this.actual = actual;
            this.index = start2;
            this.end = end;
        }

        @Override
        public CoreSubscriber<? super Integer> actual() {
            return this.actual;
        }

        @Override
        public void request(long n) {
            if (Operators.validate(n) && Operators.addCap(REQUESTED, this, n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastPath();
                } else {
                    this.slowPath(n);
                }
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }

        void fastPath() {
            long e = this.end;
            Fuseable.ConditionalSubscriber<? super Integer> a = this.actual;
            for (long i2 = this.index; i2 != e; ++i2) {
                if (this.cancelled) {
                    return;
                }
                a.tryOnNext((Integer)((int)i2));
            }
            if (this.cancelled) {
                return;
            }
            a.onComplete();
        }

        void slowPath(long n) {
            Fuseable.ConditionalSubscriber<? super Integer> a = this.actual;
            long f = this.end;
            long e = 0L;
            long i2 = this.index;
            while (!this.cancelled) {
                while (e != n && i2 != f) {
                    boolean b = a.tryOnNext((Integer)((int)i2));
                    if (this.cancelled) {
                        return;
                    }
                    if (b) {
                        ++e;
                    }
                    ++i2;
                }
                if (this.cancelled) {
                    return;
                }
                if (i2 == f) {
                    a.onComplete();
                    return;
                }
                n = this.requested;
                if (n != e) continue;
                this.index = i2;
                n = REQUESTED.addAndGet(this, -e);
                if (n == 0L) {
                    return;
                }
                e = 0L;
            }
            return;
        }

        @Override
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.CANCELLED) {
                return this.cancelled;
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.requested;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.isEmpty();
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return InnerProducer.super.scanUnsafe(key);
        }

        @Override
        @Nullable
        public Integer poll() {
            long i2 = this.index;
            if (i2 == this.end) {
                return null;
            }
            this.index = i2 + 1L;
            return (int)i2;
        }

        @Override
        public boolean isEmpty() {
            return this.index == this.end;
        }

        @Override
        public void clear() {
            this.index = this.end;
        }

        @Override
        public int size() {
            return (int)(this.end - this.index);
        }
    }

    static final class RangeSubscription
    implements InnerProducer<Integer>,
    Fuseable.SynchronousSubscription<Integer> {
        final CoreSubscriber<? super Integer> actual;
        final long end;
        volatile boolean cancelled;
        long index;
        volatile long requested;
        static final AtomicLongFieldUpdater<RangeSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(RangeSubscription.class, "requested");

        RangeSubscription(CoreSubscriber<? super Integer> actual, long start2, long end) {
            this.actual = actual;
            this.index = start2;
            this.end = end;
        }

        @Override
        public CoreSubscriber<? super Integer> actual() {
            return this.actual;
        }

        @Override
        public void request(long n) {
            if (Operators.validate(n) && Operators.addCap(REQUESTED, this, n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastPath();
                } else {
                    this.slowPath(n);
                }
            }
        }

        @Override
        public void cancel() {
            this.cancelled = true;
        }

        void fastPath() {
            long e = this.end;
            CoreSubscriber<? super Integer> a = this.actual;
            for (long i2 = this.index; i2 != e; ++i2) {
                if (this.cancelled) {
                    return;
                }
                a.onNext((Integer)((int)i2));
            }
            if (this.cancelled) {
                return;
            }
            a.onComplete();
        }

        void slowPath(long n) {
            CoreSubscriber<? super Integer> a = this.actual;
            long f = this.end;
            long e = 0L;
            long i2 = this.index;
            while (!this.cancelled) {
                while (e != n && i2 != f) {
                    a.onNext((Integer)((int)i2));
                    if (this.cancelled) {
                        return;
                    }
                    ++e;
                    ++i2;
                }
                if (this.cancelled) {
                    return;
                }
                if (i2 == f) {
                    a.onComplete();
                    return;
                }
                n = this.requested;
                if (n != e) continue;
                this.index = i2;
                n = REQUESTED.addAndGet(this, -e);
                if (n == 0L) {
                    return;
                }
                e = 0L;
            }
            return;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.CANCELLED) {
                return this.cancelled;
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return this.requested;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.isEmpty();
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return InnerProducer.super.scanUnsafe(key);
        }

        @Override
        @Nullable
        public Integer poll() {
            long i2 = this.index;
            if (i2 == this.end) {
                return null;
            }
            this.index = i2 + 1L;
            return (int)i2;
        }

        @Override
        public boolean isEmpty() {
            return this.index == this.end;
        }

        @Override
        public void clear() {
            this.index = this.end;
        }

        @Override
        public int size() {
            return (int)(this.end - this.index);
        }
    }
}

