/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.CommonLogger;
import gov.nist.core.NamingThreadFactory;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.MDCScheduledTHExecutor;
import gov.nist.javax.sip.ThreadAffinityIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadAffinityExecutor
implements ScheduledExecutorService {
    private static StackLogger logger = CommonLogger.getLogger(ThreadAffinityExecutor.class);
    private final List<MDCScheduledTHExecutor> executors;
    private final AtomicInteger nextThread = new AtomicInteger(0);

    public ThreadAffinityExecutor(int corePoolSize) {
        this.executors = new ArrayList<MDCScheduledTHExecutor>();
        NamingThreadFactory namingThreadFactory = new NamingThreadFactory("AffinityJAIN");
        for (int i2 = 0; i2 < corePoolSize; ++i2) {
            this.executors.add(new MDCScheduledTHExecutor(1, namingThreadFactory));
        }
        this.schedulePurgeTaskIfNeeded();
    }

    private synchronized int retrieveNextThread() {
        int nThread = this.nextThread.incrementAndGet();
        if (nThread >= this.executors.size()) {
            nThread = 0;
            this.nextThread.set(0);
        }
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("Next thread id=" + nThread);
        }
        return nThread;
    }

    private int calculateAffinityThread(Runnable runnable2) {
        int affThreadIndex = 0;
        if (runnable2 instanceof ThreadAffinityIdentifier) {
            ThreadAffinityIdentifier tTask = (ThreadAffinityIdentifier)((Object)runnable2);
            Object tHash = tTask.getThreadHash();
            if (tHash != null) {
                affThreadIndex = Math.abs(tHash.hashCode() % this.executors.size());
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("Runnable assigned to thread (" + tHash + "," + affThreadIndex + ")");
                }
            } else {
                affThreadIndex = this.retrieveNextThread();
            }
        } else {
            affThreadIndex = this.retrieveNextThread();
        }
        return affThreadIndex;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command2, long delay, TimeUnit unit) {
        int affThread = this.calculateAffinityThread(command2);
        return this.executors.get(affThread).schedule(command2, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command2, long initialDelay, long period, TimeUnit unit) {
        int affThread = this.calculateAffinityThread(command2);
        return this.executors.get(affThread).scheduleAtFixedRate(command2, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command2, long initialDelay, long delay, TimeUnit unit) {
        int affThread = this.calculateAffinityThread(command2);
        return this.executors.get(affThread).scheduleWithFixedDelay(command2, initialDelay, delay, unit);
    }

    @Override
    public void shutdown() {
        for (ScheduledExecutorService scheduledExecutorService : this.executors) {
            scheduledExecutorService.shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isShutdown() {
        return this.executors.get(0).isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executors.get(0).isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout2, TimeUnit unit) throws InterruptedException {
        return this.executors.get(0).awaitTermination(timeout2, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result2) {
        int affThread = this.calculateAffinityThread(task);
        return this.executors.get(affThread).submit(task, result2);
    }

    @Override
    public Future<?> submit(Runnable task) {
        int affThread = this.calculateAffinityThread(task);
        return this.executors.get(affThread).submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout2, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout2, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void execute(Runnable command2) {
        int affThread = this.calculateAffinityThread(command2);
        this.executors.get(affThread).execute(command2);
    }

    private void schedulePurgeTaskIfNeeded() {
    }
}

