/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.micrometer.transform;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Gauge;
import com.newrelic.telemetry.metrics.Metric;
import com.newrelic.telemetry.metrics.Summary;
import com.newrelic.telemetry.micrometer.transform.AttributesMaker;
import com.newrelic.telemetry.micrometer.util.TimeTracker;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DistributionSummaryTransformer {
    private final AttributesMaker attributesMaker;
    private final TimeTracker timeTracker;

    public DistributionSummaryTransformer(TimeTracker timeTracker, AttributesMaker attributesMaker) {
        this.attributesMaker = attributesMaker;
        this.timeTracker = timeTracker;
    }

    public Collection<Metric> transform(DistributionSummary distributionSummary) {
        long now = this.timeTracker.getCurrentTime();
        HistogramSnapshot snapshot = distributionSummary.takeSnapshot();
        Stream<Metric> summaryMetrics = this.buildSummaryMetric(distributionSummary, now, snapshot);
        Stream<Metric> percentileMetrics = this.buildPercentiles(distributionSummary, now, snapshot);
        return Stream.concat(summaryMetrics, percentileMetrics).collect(Collectors.toList());
    }

    private Stream<Metric> buildSummaryMetric(DistributionSummary distributionSummary, long now, HistogramSnapshot snapshot) {
        Attributes attributes = this.attributesMaker.make(distributionSummary.getId(), "distributionSummary");
        String name = distributionSummary.getId().getName();
        return Stream.of(new Summary(name + ".summary", (int)snapshot.count(), snapshot.total(), Double.NaN, snapshot.max(), this.timeTracker.getPreviousTime(), now, attributes));
    }

    private Stream<Metric> buildPercentiles(DistributionSummary distributionSummary, long now, HistogramSnapshot snapshot) {
        return Arrays.stream(snapshot.percentileValues()).map(valueAtPercentile -> new Gauge(distributionSummary.getId().getName() + ".percentiles", valueAtPercentile.value(), now, new Attributes().put("percentile", valueAtPercentile.percentile() * 100.0)));
    }
}

