/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry;

import com.newrelic.telemetry.BaseConfig;
import com.newrelic.telemetry.SenderConfiguration;
import com.newrelic.telemetry.http.HttpPoster;
import com.newrelic.telemetry.logs.LogBatchSender;
import java.util.function.Supplier;

public interface LogBatchSenderFactory {
    default public LogBatchSender createBatchSender(String apiKey) {
        SenderConfiguration.SenderConfigurationBuilder configuration = LogBatchSender.configurationBuilder().apiKey(apiKey).httpPoster(this.getPoster());
        return LogBatchSender.create(configuration.build());
    }

    default public SenderConfiguration.SenderConfigurationBuilder configureWith(BaseConfig config2) {
        return this.configureWith(config2.getApiKey()).auditLoggingEnabled(config2.isAuditLoggingEnabled()).secondaryUserAgent(config2.getSecondaryUserAgent()).httpPoster(this.getPoster());
    }

    default public SenderConfiguration.SenderConfigurationBuilder configureWith(String apiKey) {
        return LogBatchSender.configurationBuilder().apiKey(apiKey).httpPoster(this.getPoster());
    }

    public HttpPoster getPoster();

    public static LogBatchSenderFactory fromHttpImplementation(Supplier<HttpPoster> creator) {
        return creator::get;
    }
}

