/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoSocketException;
import com.mongodb.ReadPreference;
import com.mongodb.RequestContext;
import com.mongodb.ServerAddress;
import com.mongodb.ServerApi;
import com.mongodb.ServerCursor;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.QueryResult;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.operation.AggregateResponseBatchCursor;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.CursorHelper;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.QueryHelper;
import com.mongodb.internal.operation.ServerVersionHelper;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.FieldNameValidator;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

class QueryBatchCursor<T>
implements AggregateResponseBatchCursor<T> {
    private static final Logger LOGGER = Loggers.getLogger("operation");
    private static final FieldNameValidator NO_OP_FIELD_NAME_VALIDATOR = new NoOpFieldNameValidator();
    private static final String CURSOR = "cursor";
    private static final String POST_BATCH_RESUME_TOKEN = "postBatchResumeToken";
    private static final String OPERATION_TIME = "operationTime";
    private static final String MESSAGE_IF_CLOSED_AS_CURSOR = "Cursor has been closed";
    private static final String MESSAGE_IF_CLOSED_AS_ITERATOR = "Iterator has been closed";
    private final MongoNamespace namespace;
    @Nullable
    private final ServerApi serverApi;
    private final ServerAddress serverAddress;
    private final int limit;
    private final Decoder<T> decoder;
    private final long maxTimeMS;
    private int batchSize;
    private final BsonValue comment;
    private List<T> nextBatch;
    private int count;
    private BsonDocument postBatchResumeToken;
    private BsonTimestamp operationTime;
    private final boolean firstBatchEmpty;
    private int maxWireVersion = 0;
    private final ResourceManager resourceManager;

    QueryBatchCursor(QueryResult<T> firstQueryResult, int limit, int batchSize, Decoder<T> decoder) {
        this(firstQueryResult, limit, batchSize, decoder, null, null);
    }

    QueryBatchCursor(QueryResult<T> firstQueryResult, int limit, int batchSize, Decoder<T> decoder, BsonValue comment, ConnectionSource connectionSource) {
        this(firstQueryResult, limit, batchSize, 0L, decoder, comment, connectionSource, null, null);
    }

    QueryBatchCursor(QueryResult<T> firstQueryResult, int limit, int batchSize, long maxTimeMS, Decoder<T> decoder, BsonValue comment, ConnectionSource connectionSource, Connection connection) {
        this(firstQueryResult, limit, batchSize, maxTimeMS, decoder, comment, connectionSource, connection, null);
    }

    QueryBatchCursor(QueryResult<T> firstQueryResult, int limit, int batchSize, long maxTimeMS, Decoder<T> decoder, BsonValue comment, ConnectionSource connectionSource, Connection connection, BsonDocument result2) {
        ServerCursor serverCursor;
        Assertions.isTrueArgument("maxTimeMS >= 0", maxTimeMS >= 0L);
        this.maxTimeMS = maxTimeMS;
        this.namespace = firstQueryResult.getNamespace();
        this.serverApi = connectionSource == null ? null : connectionSource.getServerApi();
        this.serverAddress = firstQueryResult.getAddress();
        this.limit = limit;
        this.comment = comment;
        this.batchSize = batchSize;
        this.decoder = Assertions.notNull("decoder", decoder);
        if (result2 != null) {
            this.operationTime = result2.getTimestamp(OPERATION_TIME, null);
            this.postBatchResumeToken = this.getPostBatchResumeTokenFromResponse(result2);
        }
        if ((serverCursor = this.initFromQueryResult(firstQueryResult)) != null) {
            Assertions.notNull("connectionSource", connectionSource);
        }
        this.firstBatchEmpty = firstQueryResult.getResults().isEmpty();
        Connection connectionToPin = null;
        boolean releaseServerAndResources = false;
        if (connection != null) {
            this.maxWireVersion = connection.getDescription().getMaxWireVersion();
            if (this.limitReached()) {
                releaseServerAndResources = true;
            } else {
                Assertions.assertNotNull(connectionSource);
                if (connectionSource.getServerDescription().getType() == ServerType.LOAD_BALANCER) {
                    connectionToPin = connection;
                }
            }
        }
        this.resourceManager = new ResourceManager(connectionSource, connectionToPin, serverCursor);
        if (releaseServerAndResources) {
            this.resourceManager.releaseServerAndClientResources(Assertions.assertNotNull(connection));
        }
    }

    @Override
    public boolean hasNext() {
        return Assertions.assertNotNull(this.resourceManager.execute(MESSAGE_IF_CLOSED_AS_CURSOR, this::doHasNext));
    }

    private boolean doHasNext() {
        if (this.nextBatch != null) {
            return true;
        }
        if (this.limitReached()) {
            return false;
        }
        while (this.resourceManager.serverCursor() != null) {
            this.getMore();
            if (!this.resourceManager.operable()) {
                throw new IllegalStateException(MESSAGE_IF_CLOSED_AS_CURSOR);
            }
            if (this.nextBatch == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<T> next() {
        return Assertions.assertNotNull(this.resourceManager.execute(MESSAGE_IF_CLOSED_AS_ITERATOR, this::doNext));
    }

    @Override
    public int available() {
        return !this.resourceManager.operable() || this.nextBatch == null ? 0 : this.nextBatch.size();
    }

    private List<T> doNext() {
        if (!this.doHasNext()) {
            throw new NoSuchElementException();
        }
        List<T> retVal = this.nextBatch;
        this.nextBatch = null;
        return retVal;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public void close() {
        this.resourceManager.close();
    }

    @Override
    public List<T> tryNext() {
        return this.resourceManager.execute(MESSAGE_IF_CLOSED_AS_CURSOR, () -> {
            if (!this.tryHasNext()) {
                return null;
            }
            return this.doNext();
        });
    }

    private boolean tryHasNext() {
        if (this.nextBatch != null) {
            return true;
        }
        if (this.limitReached()) {
            return false;
        }
        if (this.resourceManager.serverCursor() != null) {
            this.getMore();
        }
        return this.nextBatch != null;
    }

    @Override
    @Nullable
    public ServerCursor getServerCursor() {
        if (!this.resourceManager.operable()) {
            throw new IllegalStateException(MESSAGE_IF_CLOSED_AS_ITERATOR);
        }
        return this.resourceManager.serverCursor();
    }

    @Override
    public ServerAddress getServerAddress() {
        if (!this.resourceManager.operable()) {
            throw new IllegalStateException(MESSAGE_IF_CLOSED_AS_ITERATOR);
        }
        return this.serverAddress;
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.postBatchResumeToken;
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.operationTime;
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.firstBatchEmpty;
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    private void getMore() {
        ServerCursor serverCursor = Assertions.assertNotNull(this.resourceManager.serverCursor());
        this.resourceManager.executeWithConnection(connection -> {
            ServerCursor nextServerCursor;
            try {
                nextServerCursor = this.initFromCommandResult(connection.command(this.namespace.getDatabaseName(), this.asGetMoreCommandDocument(serverCursor.getId(), connection.getDescription()), NO_OP_FIELD_NAME_VALIDATOR, ReadPreference.primary(), CommandResultDocumentCodec.create(this.decoder, "nextBatch"), this.resourceManager.sessionContext(), this.serverApi, this.resourceManager.requestContext()));
            }
            catch (MongoCommandException e) {
                throw QueryHelper.translateCommandException(e, serverCursor);
            }
            this.resourceManager.setServerCursor(nextServerCursor);
            if (this.limitReached()) {
                this.resourceManager.releaseServerAndClientResources((Connection)connection);
            }
        });
    }

    private BsonDocument asGetMoreCommandDocument(long cursorId, ConnectionDescription connectionDescription) {
        BsonDocument document = new BsonDocument("getMore", new BsonInt64(cursorId)).append("collection", new BsonString(this.namespace.getCollectionName()));
        int batchSizeForGetMoreCommand = Math.abs(CursorHelper.getNumberToReturn(this.limit, this.batchSize, this.count));
        if (batchSizeForGetMoreCommand != 0) {
            document.append("batchSize", new BsonInt32(batchSizeForGetMoreCommand));
        }
        if (this.maxTimeMS != 0L) {
            document.append("maxTimeMS", new BsonInt64(this.maxTimeMS));
        }
        if (ServerVersionHelper.serverIsAtLeastVersionFourDotFour(connectionDescription)) {
            DocumentHelper.putIfNotNull(document, "comment", this.comment);
        }
        return document;
    }

    @Nullable
    private ServerCursor initFromQueryResult(QueryResult<T> queryResult) {
        this.nextBatch = queryResult.getResults().isEmpty() ? null : queryResult.getResults();
        this.count += queryResult.getResults().size();
        LOGGER.debug(String.format("Received batch of %d documents with cursorId %d from server %s", queryResult.getResults().size(), queryResult.getCursorId(), queryResult.getAddress()));
        return queryResult.getCursor();
    }

    @Nullable
    private ServerCursor initFromCommandResult(BsonDocument getMoreCommandResultDocument) {
        QueryResult queryResult = OperationHelper.getMoreCursorDocumentToQueryResult(getMoreCommandResultDocument.getDocument(CURSOR), this.serverAddress);
        this.postBatchResumeToken = this.getPostBatchResumeTokenFromResponse(getMoreCommandResultDocument);
        this.operationTime = getMoreCommandResultDocument.getTimestamp(OPERATION_TIME, null);
        return this.initFromQueryResult(queryResult);
    }

    private boolean limitReached() {
        return Math.abs(this.limit) != 0 && this.count >= Math.abs(this.limit);
    }

    private BsonDocument getPostBatchResumeTokenFromResponse(BsonDocument result2) {
        BsonDocument cursor = result2.getDocument(CURSOR, null);
        if (cursor != null) {
            return cursor.getDocument(POST_BATCH_RESUME_TOKEN, null);
        }
        return null;
    }

    @ThreadSafe
    private final class ResourceManager {
        private final Lock lock = new StampedLock().asWriteLock();
        private volatile State state = State.IDLE;
        @Nullable
        private volatile ConnectionSource connectionSource;
        @Nullable
        private volatile Connection pinnedConnection;
        @Nullable
        private volatile ServerCursor serverCursor;
        private volatile boolean skipReleasingServerResourcesOnClose;

        ResourceManager(@Nullable ConnectionSource connectionSource, @Nullable Connection connectionToPin, ServerCursor serverCursor) {
            if (serverCursor != null) {
                this.connectionSource = Assertions.assertNotNull(connectionSource).retain();
                if (connectionToPin != null) {
                    this.pinnedConnection = connectionToPin.retain();
                    connectionToPin.markAsPinned(Connection.PinningMode.CURSOR);
                }
            }
            this.skipReleasingServerResourcesOnClose = false;
            this.serverCursor = serverCursor;
        }

        boolean operable() {
            return this.state.operable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        <R> R execute(String exceptionMessageIfClosed, Supplier<R> operation) throws IllegalStateException {
            if (!this.tryStartOperation()) {
                throw new IllegalStateException(exceptionMessageIfClosed);
            }
            try {
                R r = operation.get();
                return r;
            }
            finally {
                this.endOperation();
            }
        }

        private boolean tryStartOperation() throws IllegalStateException {
            this.lock.lock();
            try {
                State localState = this.state;
                if (!localState.operable()) {
                    boolean bl = false;
                    return bl;
                }
                if (localState == State.IDLE) {
                    this.state = State.OPERATION_IN_PROGRESS;
                    boolean bl = true;
                    return bl;
                }
                if (localState == State.OPERATION_IN_PROGRESS) {
                    throw new IllegalStateException("Another operation is currently in progress, concurrent operations are not supported");
                }
                throw Assertions.fail(this.state.toString());
            }
            finally {
                this.lock.unlock();
            }
        }

        private void endOperation() {
            boolean doClose = false;
            this.lock.lock();
            try {
                State localState = this.state;
                if (localState == State.OPERATION_IN_PROGRESS) {
                    this.state = State.IDLE;
                } else if (localState == State.CLOSE_PENDING) {
                    this.state = State.CLOSED;
                    doClose = true;
                } else {
                    Assertions.fail(localState.toString());
                }
            }
            finally {
                this.lock.unlock();
            }
            if (doClose) {
                this.doClose();
            }
        }

        void close() {
            boolean doClose = false;
            this.lock.lock();
            try {
                State localState = this.state;
                if (localState == State.OPERATION_IN_PROGRESS) {
                    this.state = State.CLOSE_PENDING;
                } else if (localState != State.CLOSED) {
                    this.state = State.CLOSED;
                    doClose = true;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (doClose) {
                this.doClose();
            }
        }

        private void doClose() {
            block8: {
                try {
                    if (this.skipReleasingServerResourcesOnClose) {
                        this.serverCursor = null;
                        break block8;
                    }
                    if (this.serverCursor == null) break block8;
                    Connection connection = this.connection();
                    try {
                        this.releaseServerResources(connection);
                    }
                    finally {
                        connection.release();
                    }
                }
                catch (MongoException mongoException) {
                }
                finally {
                    this.serverCursor = null;
                    this.releaseClientResources();
                }
            }
        }

        void onCorruptedConnection(Connection corruptedConnection) {
            Assertions.assertTrue(this.state.inProgress());
            Connection localPinnedConnection = this.pinnedConnection;
            if (localPinnedConnection != null) {
                Assertions.assertTrue(corruptedConnection == localPinnedConnection);
                this.skipReleasingServerResourcesOnClose = true;
            }
        }

        void executeWithConnection(Consumer<Connection> action) {
            Connection connection = this.connection();
            try {
                action.accept(connection);
            }
            catch (MongoSocketException e) {
                try {
                    this.onCorruptedConnection(connection);
                }
                catch (Exception suppressed) {
                    e.addSuppressed(suppressed);
                }
                throw e;
            }
            finally {
                connection.release();
            }
        }

        private Connection connection() {
            Assertions.assertTrue(this.state != State.IDLE);
            if (this.pinnedConnection == null) {
                return Assertions.assertNotNull(this.connectionSource).getConnection();
            }
            return Assertions.assertNotNull(this.pinnedConnection).retain();
        }

        @Nullable
        ServerCursor serverCursor() {
            return this.serverCursor;
        }

        void setServerCursor(@Nullable ServerCursor serverCursor) {
            Assertions.assertTrue(this.state.inProgress());
            Assertions.assertNotNull(this.serverCursor);
            Assertions.assertNotNull(this.connectionSource);
            this.serverCursor = serverCursor;
            if (serverCursor == null) {
                this.releaseClientResources();
            }
        }

        @Nullable
        SessionContext sessionContext() {
            return Assertions.assertNotNull(this.connectionSource).getSessionContext();
        }

        RequestContext requestContext() {
            return Assertions.assertNotNull(this.connectionSource).getRequestContext();
        }

        void releaseServerAndClientResources(Connection connection) {
            try {
                this.releaseServerResources(Assertions.assertNotNull(connection));
            }
            finally {
                this.releaseClientResources();
            }
        }

        private void releaseServerResources(Connection connection) {
            try {
                ServerCursor localServerCursor = this.serverCursor;
                if (localServerCursor != null) {
                    this.killServerCursor(QueryBatchCursor.this.namespace, localServerCursor, this.sessionContext(), this.requestContext(), QueryBatchCursor.this.serverApi, Assertions.assertNotNull(connection));
                }
            }
            finally {
                this.serverCursor = null;
            }
        }

        private void killServerCursor(MongoNamespace namespace, ServerCursor serverCursor, @Nullable SessionContext sessionContext, RequestContext requestContext, @Nullable ServerApi serverApi, Connection connection) {
            connection.command(namespace.getDatabaseName(), this.asKillCursorsCommandDocument(namespace, serverCursor), NO_OP_FIELD_NAME_VALIDATOR, ReadPreference.primary(), new BsonDocumentCodec(), sessionContext, serverApi, requestContext);
        }

        private BsonDocument asKillCursorsCommandDocument(MongoNamespace namespace, ServerCursor serverCursor) {
            return new BsonDocument("killCursors", new BsonString(namespace.getCollectionName())).append("cursors", new BsonArray(Collections.singletonList(new BsonInt64(serverCursor.getId()))));
        }

        private void releaseClientResources() {
            Connection localPinnedConnection;
            Assertions.assertNull(this.serverCursor);
            ConnectionSource localConnectionSource = this.connectionSource;
            if (localConnectionSource != null) {
                localConnectionSource.release();
                this.connectionSource = null;
            }
            if ((localPinnedConnection = this.pinnedConnection) != null) {
                localPinnedConnection.release();
                this.pinnedConnection = null;
            }
        }
    }

    private static enum State {
        IDLE(true, false),
        OPERATION_IN_PROGRESS(true, true),
        CLOSE_PENDING(false, true),
        CLOSED(false, false);

        private final boolean operable;
        private final boolean inProgress;

        private State(boolean operable, boolean inProgress) {
            this.operable = operable;
            this.inProgress = inProgress;
        }

        boolean operable() {
            return this.operable;
        }

        boolean inProgress() {
            return this.inProgress;
        }
    }
}

