/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoCompressor;
import com.mongodb.internal.connection.Compressor;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

class ZlibCompressor
extends Compressor {
    private final int level;

    ZlibCompressor(MongoCompressor mongoCompressor) {
        this.level = mongoCompressor.getPropertyNonNull("LEVEL", -1);
    }

    @Override
    public String getName() {
        return "zlib";
    }

    @Override
    public byte getId() {
        return 2;
    }

    @Override
    InputStream getInputStream(InputStream source2) {
        return new InflaterInputStream(source2);
    }

    @Override
    OutputStream getOutputStream(OutputStream source2) {
        return new DeflaterOutputStream(source2, new Deflater(this.level));
    }
}

