/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.IntStream;
import org.apache.groovy.util.Maps;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;

public class WideningCategories {
    private static final Map<ClassNode, Integer> NUMBER_TYPES_PRECEDENCE = Maps.of(ClassHelper.double_TYPE, 0, ClassHelper.float_TYPE, 1, ClassHelper.long_TYPE, 2, ClassHelper.int_TYPE, 3, ClassHelper.short_TYPE, 4, ClassHelper.byte_TYPE, 5);

    public static boolean isInt(ClassNode type) {
        return ClassHelper.isPrimitiveInt(type);
    }

    public static boolean isFloat(ClassNode type) {
        return ClassHelper.isPrimitiveFloat(type);
    }

    public static boolean isDouble(ClassNode type) {
        return ClassHelper.isPrimitiveDouble(type);
    }

    public static boolean isIntCategory(ClassNode type) {
        return ClassHelper.isPrimitiveInt(type) || ClassHelper.isPrimitiveByte(type) || ClassHelper.isPrimitiveChar(type) || ClassHelper.isPrimitiveShort(type);
    }

    public static boolean isLongCategory(ClassNode type) {
        return ClassHelper.isPrimitiveLong(type) || WideningCategories.isIntCategory(type);
    }

    public static boolean isBigIntCategory(ClassNode type) {
        return ClassHelper.isBigIntegerType(type) || WideningCategories.isLongCategory(type);
    }

    public static boolean isBigDecCategory(ClassNode type) {
        return ClassHelper.isBigDecimalType(type) || WideningCategories.isBigIntCategory(type);
    }

    public static boolean isDoubleCategory(ClassNode type) {
        return ClassHelper.isPrimitiveFloat(type) || ClassHelper.isPrimitiveDouble(type) || WideningCategories.isBigDecCategory(type);
    }

    public static boolean isFloatingCategory(ClassNode type) {
        return ClassHelper.isPrimitiveFloat(type) || ClassHelper.isPrimitiveDouble(type);
    }

    public static boolean isNumberCategory(ClassNode type) {
        return WideningCategories.isBigDecCategory(type) || type.isDerivedFrom(ClassHelper.Number_TYPE);
    }

    public static ClassNode lowestUpperBound(List<ClassNode> nodes) {
        int n = nodes.size();
        if (n == 1) {
            return nodes.get(0);
        }
        if (n == 2) {
            return WideningCategories.lowestUpperBound(nodes.get(0), nodes.get(1));
        }
        return WideningCategories.lowestUpperBound(nodes.get(0), WideningCategories.lowestUpperBound(nodes.subList(1, n)));
    }

    public static ClassNode lowestUpperBound(ClassNode a, ClassNode b) {
        ClassNode lub = WideningCategories.lowestUpperBound(a, b, null, null);
        if (lub == null || !lub.isUsingGenerics() || lub.isGenericsPlaceHolder()) {
            return lub;
        }
        if (lub instanceof LowestUpperBoundClassNode) {
            ClassNode superClass = lub.getSuperClass();
            if (superClass.redirect().getGenericsTypes() != null) {
                superClass = WideningCategories.parameterizeLowestUpperBound(superClass, a, b, lub);
            }
            ClassNode[] interfaces = (ClassNode[])lub.getInterfaces().clone();
            int n = interfaces.length;
            for (int i2 = 0; i2 < n; ++i2) {
                ClassNode icn = interfaces[i2];
                if (icn.redirect().getGenericsTypes() == null) continue;
                interfaces[i2] = WideningCategories.parameterizeLowestUpperBound(icn, a, b, lub);
            }
            return new LowestUpperBoundClassNode(((LowestUpperBoundClassNode)lub).name, superClass, interfaces);
        }
        return WideningCategories.parameterizeLowestUpperBound(lub, a, b, lub);
    }

    private static ClassNode parameterizeLowestUpperBound(ClassNode lub, ClassNode a, ClassNode b, ClassNode fallback) {
        GenericsType[] bgt;
        if (a.toString(false).equals(b.toString(false))) {
            return lub;
        }
        ClassNode holderForA = WideningCategories.findGenericsTypeHolderForClass(a, lub);
        ClassNode holderForB = WideningCategories.findGenericsTypeHolderForClass(b, lub);
        GenericsType[] agt = holderForA == null ? null : holderForA.getGenericsTypes();
        GenericsType[] genericsTypeArray = bgt = holderForB == null ? null : holderForB.getGenericsTypes();
        if (agt == null || bgt == null || agt.length != bgt.length) {
            return lub;
        }
        int n = agt.length;
        GenericsType[] lubGTs = new GenericsType[n];
        for (int i2 = 0; i2 < n; ++i2) {
            ClassNode t1 = WideningCategories.upperBound(agt[i2]);
            ClassNode t2 = WideningCategories.upperBound(bgt[i2]);
            ClassNode basicType = WideningCategories.areEqualWithGenerics(t1, ClassHelper.isPrimitiveType(a) ? ClassHelper.getWrapper(a) : a) && WideningCategories.areEqualWithGenerics(t2, ClassHelper.isPrimitiveType(b) ? ClassHelper.getWrapper(b) : b) ? fallback : WideningCategories.lowestUpperBound(t1, t2);
            lubGTs[i2] = agt[i2].isWildcard() || bgt[i2].isWildcard() || !t1.equals(t2) ? GenericsUtils.buildWildcardType(basicType) : basicType.asGenericsType();
        }
        return GenericsUtils.makeClassSafe0(lub, lubGTs);
    }

    private static ClassNode findGenericsTypeHolderForClass(ClassNode source2, ClassNode target) {
        if (ClassHelper.isPrimitiveType(source2)) {
            source2 = ClassHelper.getWrapper(source2);
        }
        if (source2.equals(target)) {
            return source2;
        }
        if (target.isInterface() ? source2.implementsInterface(target) : source2.isDerivedFrom(target)) {
            ClassNode sc;
            do {
                if (!GenericsUtils.hasUnresolvedGenerics(sc = ClassHelper.getNextSuperClass(source2, target))) continue;
                sc = GenericsUtils.correctToGenericsSpecRecurse(GenericsUtils.createGenericsSpec(source2), sc);
            } while (!(source2 = sc).equals(target));
            return sc;
        }
        return null;
    }

    private static ClassNode upperBound(GenericsType gt) {
        ClassNode[] ub;
        if ((gt.isPlaceholder() || gt.isWildcard()) && (ub = gt.getUpperBounds()) != null) {
            return ub[0];
        }
        return gt.getType();
    }

    private static ClassNode lowestUpperBound(ClassNode a, ClassNode b, Set<ClassNode> interfacesImplementedByA, Set<ClassNode> interfacesImplementedByB) {
        if (a == null || b == null) {
            return null;
        }
        if (a.isArray() && b.isArray()) {
            return WideningCategories.lowestUpperBound(a.getComponentType(), b.getComponentType(), interfacesImplementedByA, interfacesImplementedByB).makeArray();
        }
        if (ClassHelper.isObjectType(a) || ClassHelper.isObjectType(b)) {
            GenericsType[] gta = a.getGenericsTypes();
            GenericsType[] gtb = b.getGenericsTypes();
            if (gta != null && gtb != null && gta.length == 1 && gtb.length == 1 && gta[0].getName().equals(gtb[0].getName())) {
                return a;
            }
            return ClassHelper.OBJECT_TYPE;
        }
        if (ClassHelper.isPrimitiveVoid(a) || ClassHelper.isPrimitiveVoid(b)) {
            if (!b.equals(a)) {
                return ClassHelper.OBJECT_TYPE;
            }
            return ClassHelper.VOID_TYPE;
        }
        boolean aIsPrimitive = ClassHelper.isPrimitiveType(a);
        boolean bIsPrimitive = ClassHelper.isPrimitiveType(b);
        if (aIsPrimitive || bIsPrimitive) {
            ClassNode wb;
            if (a.equals(b)) {
                return a;
            }
            Integer pa = NUMBER_TYPES_PRECEDENCE.get(aIsPrimitive ? a : ClassHelper.getUnwrapper(a));
            Integer pb = NUMBER_TYPES_PRECEDENCE.get(bIsPrimitive ? b : ClassHelper.getUnwrapper(b));
            ClassNode wa = aIsPrimitive ? ClassHelper.getWrapper(a) : a;
            ClassNode classNode = wb = bIsPrimitive ? ClassHelper.getWrapper(b) : b;
            if (pa != null && pb != null) {
                if (pa.compareTo(pb) <= 0) {
                    return bIsPrimitive ? a : wa;
                }
                return aIsPrimitive ? b : wb;
            }
            return WideningCategories.lowestUpperBound(wa, wb, null, null);
        }
        boolean aIsInterface = a.isInterface();
        boolean bIsInterface = b.isInterface();
        if (aIsInterface && bIsInterface) {
            if (a.equals(b) || b.implementsInterface(a)) {
                return a;
            }
            if (a.implementsInterface(b)) {
                return b;
            }
            interfacesImplementedByA = GeneralUtils.getInterfacesAndSuperInterfaces(a);
            List<ClassNode> common = WideningCategories.keepLowestCommonInterfaces(interfacesImplementedByA, interfacesImplementedByB = GeneralUtils.getInterfacesAndSuperInterfaces(b));
            if (common.size() == 1) {
                return (ClassNode)common.iterator().next();
            }
            if (common.size() > 1) {
                return WideningCategories.buildTypeWithInterfaces(a, b, common);
            }
            return ClassHelper.OBJECT_TYPE;
        }
        if (bIsInterface) {
            return WideningCategories.lowestUpperBound(b, a, null, null);
        }
        if (aIsInterface) {
            LinkedList<ClassNode> matchingInterfaces = new LinkedList<ClassNode>();
            WideningCategories.extractMostSpecificImplementedInterfaces(b, a, matchingInterfaces);
            if (matchingInterfaces.isEmpty()) {
                return ClassHelper.OBJECT_TYPE;
            }
            if (matchingInterfaces.size() == 1) {
                return (ClassNode)matchingInterfaces.get(0);
            }
            return WideningCategories.buildTypeWithInterfaces(a, b, matchingInterfaces);
        }
        if (a.equals(b)) {
            return WideningCategories.buildTypeWithInterfaces(a, b, WideningCategories.keepLowestCommonInterfaces(interfacesImplementedByA, interfacesImplementedByB));
        }
        if (a.isDerivedFrom(b) || b.isDerivedFrom(a)) {
            return WideningCategories.buildTypeWithInterfaces(a, b, WideningCategories.keepLowestCommonInterfaces(interfacesImplementedByA, interfacesImplementedByB));
        }
        ClassNode sa = a.getUnresolvedSuperClass();
        ClassNode sb = b.getUnresolvedSuperClass();
        if (interfacesImplementedByA == null) {
            interfacesImplementedByA = GeneralUtils.getInterfacesAndSuperInterfaces(a);
        }
        if (interfacesImplementedByB == null) {
            interfacesImplementedByB = GeneralUtils.getInterfacesAndSuperInterfaces(b);
        }
        if (sa == null || sb == null) {
            return WideningCategories.buildTypeWithInterfaces(ClassHelper.OBJECT_TYPE, ClassHelper.OBJECT_TYPE, WideningCategories.keepLowestCommonInterfaces(interfacesImplementedByA, interfacesImplementedByB));
        }
        if (sa.isDerivedFrom(sb) || sb.isDerivedFrom(sa)) {
            return WideningCategories.buildTypeWithInterfaces(sa, sb, WideningCategories.keepLowestCommonInterfaces(interfacesImplementedByA, interfacesImplementedByB));
        }
        return WideningCategories.lowestUpperBound(sa, sb, interfacesImplementedByA, interfacesImplementedByB);
    }

    private static List<ClassNode> keepLowestCommonInterfaces(Set<ClassNode> fromA, Set<ClassNode> fromB) {
        if (fromA == null || fromB == null) {
            return Collections.emptyList();
        }
        HashSet<ClassNode> common = new HashSet<ClassNode>(fromA);
        common.retainAll(fromB);
        ArrayList<ClassNode> result2 = new ArrayList<ClassNode>(common.size());
        for (ClassNode classNode : common) {
            WideningCategories.addMostSpecificInterface(classNode, result2);
        }
        return result2;
    }

    private static void addMostSpecificInterface(ClassNode interfaceNode, List<ClassNode> nodes) {
        if (nodes.isEmpty()) {
            nodes.add(interfaceNode);
        }
        int n = nodes.size();
        for (int i2 = 0; i2 < n; ++i2) {
            ClassNode node = nodes.get(i2);
            if (node.equals(interfaceNode) || node.implementsInterface(interfaceNode)) {
                return;
            }
            if (!interfaceNode.implementsInterface(node)) continue;
            nodes.set(i2, interfaceNode);
            return;
        }
        nodes.add(interfaceNode);
    }

    private static void extractMostSpecificImplementedInterfaces(ClassNode type, ClassNode inode, List<ClassNode> result2) {
        if (type.implementsInterface(inode)) {
            result2.add(inode);
        } else {
            ClassNode[] interfaces;
            for (ClassNode interfaceNode : interfaces = inode.getInterfaces()) {
                if (!type.implementsInterface(interfaceNode)) continue;
                result2.add(interfaceNode);
            }
            if (result2.isEmpty() && interfaces.length > 0) {
                for (ClassNode interfaceNode : interfaces) {
                    WideningCategories.extractMostSpecificImplementedInterfaces(type, interfaceNode, result2);
                }
            }
        }
    }

    private static ClassNode buildTypeWithInterfaces(ClassNode baseType1, ClassNode baseType2, Collection<ClassNode> interfaces) {
        ClassNode superClass;
        String name;
        if (interfaces.isEmpty()) {
            if (baseType2.isDerivedFrom(baseType1)) {
                return baseType1;
            }
            if (baseType1.isDerivedFrom(baseType2)) {
                return baseType2;
            }
        }
        if (baseType1.equals(baseType2)) {
            name = "Virtual$" + baseType1.getName();
            superClass = baseType1;
        } else {
            name = "CommonAssignOf$" + baseType1.getName() + "$" + baseType2.getName();
            superClass = baseType1.isDerivedFrom(baseType2) ? baseType2 : (baseType2.isDerivedFrom(baseType1) ? baseType1 : ClassHelper.OBJECT_TYPE);
        }
        interfaces.removeIf(i2 -> superClass.equals(i2) || superClass.implementsInterface((ClassNode)i2));
        int nInterfaces = interfaces.size();
        if (nInterfaces == 0) {
            return superClass;
        }
        if (nInterfaces == 1 && ClassHelper.isObjectType(superClass)) {
            return interfaces.iterator().next();
        }
        return new LowestUpperBoundClassNode(name, superClass, interfaces.toArray(ClassNode.EMPTY_ARRAY));
    }

    private static boolean areEqualWithGenerics(ClassNode a, ClassNode b) {
        if (a == null) {
            return b == null;
        }
        if (!a.equals(b)) {
            return false;
        }
        if (a.isUsingGenerics() && !b.isUsingGenerics()) {
            return false;
        }
        GenericsType[] gta = a.getGenericsTypes();
        GenericsType[] gtb = b.getGenericsTypes();
        if (gta == null && gtb != null) {
            return false;
        }
        if (gtb == null && gta != null) {
            return false;
        }
        if (gta != null && gtb != null) {
            if (gta.length != gtb.length) {
                return false;
            }
            int n = gta.length;
            for (int i2 = 0; i2 < n; ++i2) {
                GenericsType gta_i = gta[i2];
                GenericsType gtb_i = gtb[i2];
                ClassNode[] upperA = gta_i.getUpperBounds();
                ClassNode[] upperB = gtb_i.getUpperBounds();
                if (gta_i.isPlaceholder() == gtb_i.isPlaceholder() && gta_i.isWildcard() == gtb_i.isWildcard() && gta_i.getName().equals(gtb_i.getName()) && WideningCategories.areEqualWithGenerics(gta_i.getType(), gtb_i.getType()) && WideningCategories.areEqualWithGenerics(gta_i.getLowerBound(), gtb_i.getLowerBound()) && !(upperA == null ? upperB != null : upperB.length != upperA.length || IntStream.range(0, upperA.length).anyMatch(j -> !WideningCategories.areEqualWithGenerics(upperA[j], upperB[j])))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean implementsInterfaceOrSubclassOf(ClassNode source2, ClassNode target) {
        if (source2.isDerivedFrom(target) || source2.implementsInterface(target)) {
            return true;
        }
        if (target instanceof LowestUpperBoundClassNode) {
            LowestUpperBoundClassNode lub = (LowestUpperBoundClassNode)target;
            if (WideningCategories.implementsInterfaceOrSubclassOf(source2, lub.getSuperClass())) {
                return true;
            }
            for (ClassNode classNode : lub.getInterfaces()) {
                if (!source2.implementsInterface(classNode)) continue;
                return true;
            }
        }
        return false;
    }

    public static class LowestUpperBoundClassNode
    extends ClassNode {
        private final String name;
        private final String text;
        private final ClassNode upper;
        private final ClassNode[] interfaces;
        private final ClassNode compileTimeClassNode;

        public LowestUpperBoundClassNode(String name, ClassNode upper, ClassNode ... interfaces) {
            super(name, 17, upper, interfaces, null);
            this.name = name;
            this.upper = upper;
            this.interfaces = interfaces;
            Arrays.sort(interfaces, (cn1, cn2) -> {
                String n1 = cn1 instanceof LowestUpperBoundClassNode ? ((LowestUpperBoundClassNode)cn1).name : cn1.getName();
                String n2 = cn2 instanceof LowestUpperBoundClassNode ? ((LowestUpperBoundClassNode)cn2).name : cn2.getName();
                return n1.compareTo(n2);
            });
            this.compileTimeClassNode = ClassHelper.isObjectType(upper) && interfaces.length > 0 ? interfaces[0] : upper;
            StringJoiner sj = new StringJoiner(" or ", "(", ")");
            if (!ClassHelper.isObjectType(upper)) {
                sj.add(upper.getText());
            }
            for (ClassNode i2 : interfaces) {
                sj.add(i2.getText());
            }
            this.text = sj.toString();
            boolean usesGenerics = upper.isUsingGenerics();
            ArrayList<GenericsType[]> genericsTypesList = new ArrayList<GenericsType[]>();
            genericsTypesList.add(upper.getGenericsTypes());
            for (ClassNode anInterface : interfaces) {
                usesGenerics |= anInterface.isUsingGenerics();
                genericsTypesList.add(anInterface.getGenericsTypes());
            }
            this.setUsingGenerics(usesGenerics);
            if (usesGenerics) {
                ArrayList flatList = new ArrayList();
                for (GenericsType[] gts : genericsTypesList) {
                    if (gts == null) continue;
                    Collections.addAll(flatList, gts);
                }
                this.setGenericsTypes(flatList.toArray(GenericsType.EMPTY_ARRAY));
            }
        }

        public String getLubName() {
            return this.name;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public String getName() {
            return this.compileTimeClassNode.getName();
        }

        @Override
        public Class getTypeClass() {
            return this.compileTimeClassNode.getTypeClass();
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            result2 = 31 * result2 + (this.name != null ? this.name.hashCode() : 0);
            return result2;
        }

        @Override
        public String toString(boolean x) {
            return this.text;
        }

        @Override
        public GenericsType asGenericsType() {
            ClassNode[] ubs;
            if (ClassHelper.isObjectType(this.upper)) {
                ubs = this.interfaces;
            } else {
                ubs = new ClassNode[this.interfaces.length + 1];
                ubs[0] = this.upper;
                System.arraycopy(this.interfaces, 0, ubs, 1, this.interfaces.length);
            }
            GenericsType gt = new GenericsType(ClassHelper.makeWithoutCaching("?"), ubs, null);
            gt.setWildcard(true);
            return gt;
        }

        @Override
        public ClassNode getPlainNodeReference() {
            ClassNode[] faces = (ClassNode[])this.interfaces.clone();
            for (int i2 = 0; i2 < this.interfaces.length; ++i2) {
                faces[i2] = this.interfaces[i2].getPlainNodeReference();
            }
            return new LowestUpperBoundClassNode(this.name, this.upper.getPlainNodeReference(), faces);
        }
    }
}

