/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.impl.ThrowableFormatOptions;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="ThrowablePatternConverter", category="Converter")
@ConverterKeys(value={"ex", "throwable", "exception"})
public class ThrowablePatternConverter
extends LogEventPatternConverter {
    protected final List<PatternFormatter> formatters;
    private String rawOption;
    protected final ThrowableFormatOptions options;

    protected ThrowablePatternConverter(String name, String style, String[] options, Configuration config2) {
        super(name, style);
        this.options = ThrowableFormatOptions.newInstance(options);
        if (options != null && options.length > 0) {
            this.rawOption = options[0];
        }
        if (this.options.getSuffix() != null) {
            PatternParser parser2 = PatternLayout.createPatternParser(config2);
            List<PatternFormatter> parsedFormatters = parser2.parse(this.options.getSuffix());
            boolean hasThrowableFormatter = false;
            for (PatternFormatter formatter : parsedFormatters) {
                if (!formatter.handlesThrowable()) continue;
                hasThrowableFormatter = true;
            }
            if (!hasThrowableFormatter) {
                this.formatters = parsedFormatters;
            } else {
                ArrayList<PatternFormatter> formatters = new ArrayList<PatternFormatter>();
                for (PatternFormatter formatter : parsedFormatters) {
                    if (formatter.handlesThrowable()) continue;
                    formatters.add(formatter);
                }
                this.formatters = formatters;
            }
        } else {
            this.formatters = Collections.emptyList();
        }
    }

    public static ThrowablePatternConverter newInstance(Configuration config2, String[] options) {
        return new ThrowablePatternConverter("Throwable", "throwable", options, config2);
    }

    @Override
    public void format(LogEvent event, StringBuilder buffer) {
        Throwable t = event.getThrown();
        if (this.isSubShortOption()) {
            this.formatSubShortOption(t, this.getSuffix(event), buffer);
        } else if (t != null && this.options.anyLines()) {
            this.formatOption(t, this.getSuffix(event), buffer);
        }
    }

    private boolean isSubShortOption() {
        return "short.message".equalsIgnoreCase(this.rawOption) || "short.localizedMessage".equalsIgnoreCase(this.rawOption) || "short.fileName".equalsIgnoreCase(this.rawOption) || "short.lineNumber".equalsIgnoreCase(this.rawOption) || "short.methodName".equalsIgnoreCase(this.rawOption) || "short.className".equalsIgnoreCase(this.rawOption);
    }

    private void formatSubShortOption(Throwable t, String suffix, StringBuilder buffer) {
        StackTraceElement[] trace;
        StackTraceElement throwingMethod = null;
        if (t != null && (trace = t.getStackTrace()) != null && trace.length > 0) {
            throwingMethod = trace[0];
        }
        if (t != null && throwingMethod != null) {
            String toAppend = "";
            if ("short.className".equalsIgnoreCase(this.rawOption)) {
                toAppend = throwingMethod.getClassName();
            } else if ("short.methodName".equalsIgnoreCase(this.rawOption)) {
                toAppend = throwingMethod.getMethodName();
            } else if ("short.lineNumber".equalsIgnoreCase(this.rawOption)) {
                toAppend = String.valueOf(throwingMethod.getLineNumber());
            } else if ("short.message".equalsIgnoreCase(this.rawOption)) {
                toAppend = t.getMessage();
            } else if ("short.localizedMessage".equalsIgnoreCase(this.rawOption)) {
                toAppend = t.getLocalizedMessage();
            } else if ("short.fileName".equalsIgnoreCase(this.rawOption)) {
                toAppend = throwingMethod.getFileName();
            }
            int len = buffer.length();
            if (len > 0 && !Character.isWhitespace(buffer.charAt(len - 1))) {
                buffer.append(' ');
            }
            buffer.append(toAppend);
            if (Strings.isNotBlank(suffix)) {
                buffer.append(' ');
                buffer.append(suffix);
            }
        }
    }

    private void formatOption(Throwable throwable, String suffix, StringBuilder buffer) {
        StringWriter w = new StringWriter();
        throwable.printStackTrace(new PrintWriter(w));
        int len = buffer.length();
        if (len > 0 && !Character.isWhitespace(buffer.charAt(len - 1))) {
            buffer.append(' ');
        }
        if (!this.options.allLines() || !Strings.LINE_SEPARATOR.equals(this.options.getSeparator()) || Strings.isNotBlank(suffix)) {
            StringBuilder sb = new StringBuilder();
            String[] array = w.toString().split(Strings.LINE_SEPARATOR);
            int limit = this.options.minLines(array.length) - 1;
            boolean suffixNotBlank = Strings.isNotBlank(suffix);
            for (int i2 = 0; i2 <= limit; ++i2) {
                sb.append(array[i2]);
                if (suffixNotBlank) {
                    sb.append(' ');
                    sb.append(suffix);
                }
                if (i2 >= limit) continue;
                sb.append(this.options.getSeparator());
            }
            buffer.append(sb.toString());
        } else {
            buffer.append(w.toString());
        }
    }

    @Override
    public boolean handlesThrowable() {
        return true;
    }

    protected String getSuffix(LogEvent event) {
        StringBuilder toAppendTo = new StringBuilder();
        int size = this.formatters.size();
        for (int i2 = 0; i2 < size; ++i2) {
            this.formatters.get(i2).format(event, toAppendTo);
        }
        return toAppendTo.toString();
    }
}

