/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.OrderComparator;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.composite.CompositeConfiguration;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.util.FileUtils;
import org.apache.logging.log4j.core.util.NetUtils;
import org.apache.logging.log4j.core.util.ReflectionUtil;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Strings;

public abstract class ConfigurationFactory
extends ConfigurationBuilderFactory {
    public static final String CONFIGURATION_FACTORY_PROPERTY = "log4j.configurationFactory";
    public static final String CONFIGURATION_FILE_PROPERTY = "log4j.configurationFile";
    public static final String CATEGORY = "ConfigurationFactory";
    protected static final Logger LOGGER = StatusLogger.getLogger();
    protected static final String TEST_PREFIX = "log4j2-test";
    protected static final String DEFAULT_PREFIX = "log4j2";
    private static final String CLASS_LOADER_SCHEME = "classloader";
    private static final String CLASS_PATH_SCHEME = "classpath";
    private static volatile List<ConfigurationFactory> factories = null;
    private static ConfigurationFactory configFactory = new Factory();
    protected final StrSubstitutor substitutor = new StrSubstitutor(new Interpolator());
    private static final Lock LOCK = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationFactory getInstance() {
        if (factories == null) {
            LOCK.lock();
            try {
                if (factories == null) {
                    ArrayList<ConfigurationFactory> list = new ArrayList<ConfigurationFactory>();
                    String factoryClass = PropertiesUtil.getProperties().getStringProperty(CONFIGURATION_FACTORY_PROPERTY);
                    if (factoryClass != null) {
                        ConfigurationFactory.addFactory(list, factoryClass);
                    }
                    PluginManager manager = new PluginManager(CATEGORY);
                    manager.collectPlugins();
                    Map<String, PluginType<?>> plugins = manager.getPlugins();
                    ArrayList<Class<ConfigurationFactory>> ordered = new ArrayList<Class<ConfigurationFactory>>(plugins.size());
                    for (PluginType<?> pluginType : plugins.values()) {
                        try {
                            ordered.add(pluginType.getPluginClass().asSubclass(ConfigurationFactory.class));
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Unable to add class {}", (Object)pluginType.getPluginClass(), (Object)ex);
                        }
                    }
                    Collections.sort(ordered, OrderComparator.getInstance());
                    for (Class clazz : ordered) {
                        ConfigurationFactory.addFactory(list, clazz);
                    }
                    factories = Collections.unmodifiableList(list);
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        LOGGER.debug("Using configurationFactory {}", (Object)configFactory);
        return configFactory;
    }

    private static void addFactory(Collection<ConfigurationFactory> list, String factoryClass) {
        try {
            ConfigurationFactory.addFactory(list, LoaderUtil.loadClass(factoryClass).asSubclass(ConfigurationFactory.class));
        }
        catch (Exception ex) {
            LOGGER.error("Unable to load class {}", (Object)factoryClass, (Object)ex);
        }
    }

    private static void addFactory(Collection<ConfigurationFactory> list, Class<? extends ConfigurationFactory> factoryClass) {
        try {
            list.add(ReflectionUtil.instantiate(factoryClass));
        }
        catch (Exception ex) {
            LOGGER.error("Unable to create instance of {}", (Object)factoryClass.getName(), (Object)ex);
        }
    }

    public static void setConfigurationFactory(ConfigurationFactory factory2) {
        configFactory = factory2;
    }

    public static void resetConfigurationFactory() {
        configFactory = new Factory();
    }

    public static void removeConfigurationFactory(ConfigurationFactory factory2) {
        if (configFactory == factory2) {
            configFactory = new Factory();
        }
    }

    protected abstract String[] getSupportedTypes();

    protected boolean isActive() {
        return true;
    }

    public abstract Configuration getConfiguration(LoggerContext var1, ConfigurationSource var2);

    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
        ConfigurationSource source2;
        if (!this.isActive()) {
            return null;
        }
        if (configLocation != null && (source2 = ConfigurationSource.fromUri(configLocation)) != null) {
            return this.getConfiguration(loggerContext, source2);
        }
        return null;
    }

    public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation, ClassLoader loader) {
        Configuration configuration;
        String path;
        ConfigurationSource source2;
        if (!this.isActive()) {
            return null;
        }
        if (loader == null) {
            return this.getConfiguration(loggerContext, name, configLocation);
        }
        if (ConfigurationFactory.isClassLoaderUri(configLocation) && (source2 = ConfigurationSource.fromResource(path = ConfigurationFactory.extractClassLoaderUriPath(configLocation), loader)) != null && (configuration = this.getConfiguration(loggerContext, source2)) != null) {
            return configuration;
        }
        return this.getConfiguration(loggerContext, name, configLocation);
    }

    static boolean isClassLoaderUri(URI uri) {
        if (uri == null) {
            return false;
        }
        String scheme = uri.getScheme();
        return scheme == null || scheme.equals(CLASS_LOADER_SCHEME) || scheme.equals(CLASS_PATH_SCHEME);
    }

    static String extractClassLoaderUriPath(URI uri) {
        return uri.getScheme() == null ? uri.getPath() : uri.getSchemeSpecificPart();
    }

    protected ConfigurationSource getInputFromString(String config2, ClassLoader loader) {
        try {
            URL url = new URL(config2);
            return new ConfigurationSource(url.openStream(), FileUtils.fileFromUri(url.toURI()));
        }
        catch (Exception ex) {
            ConfigurationSource source2 = ConfigurationSource.fromResource(config2, loader);
            if (source2 == null) {
                try {
                    File file = new File(config2);
                    return new ConfigurationSource((InputStream)new FileInputStream(file), file);
                }
                catch (FileNotFoundException fnfe) {
                    LOGGER.catching(Level.DEBUG, fnfe);
                }
            }
            return source2;
        }
    }

    static List<ConfigurationFactory> getFactories() {
        return factories;
    }

    private static class Factory
    extends ConfigurationFactory {
        private static final String ALL_TYPES = "*";

        private Factory() {
        }

        @Override
        public Configuration getConfiguration(LoggerContext loggerContext, String name, URI configLocation) {
            Configuration config2;
            String configLocationStr;
            if (configLocation == null) {
                configLocationStr = this.substitutor.replace(PropertiesUtil.getProperties().getStringProperty(ConfigurationFactory.CONFIGURATION_FILE_PROPERTY));
                if (configLocationStr != null) {
                    String[] sources = configLocationStr.split(",");
                    if (sources.length > 1) {
                        ArrayList<AbstractConfiguration> configs = new ArrayList<AbstractConfiguration>();
                        for (String sourceLocation : sources) {
                            Configuration config3 = this.getConfiguration(loggerContext, sourceLocation.trim());
                            if (config3 == null || !(config3 instanceof AbstractConfiguration)) {
                                LOGGER.error("Failed to created configuration at {}", (Object)sourceLocation);
                                return null;
                            }
                            configs.add((AbstractConfiguration)config3);
                        }
                        return new CompositeConfiguration(configs);
                    }
                    return this.getConfiguration(loggerContext, configLocationStr);
                }
                for (ConfigurationFactory factory2 : Factory.getFactories()) {
                    String[] types = factory2.getSupportedTypes();
                    if (types == null) continue;
                    for (String type : types) {
                        Configuration config4;
                        if (!type.equals(ALL_TYPES) || (config4 = factory2.getConfiguration(loggerContext, name, configLocation)) == null) continue;
                        return config4;
                    }
                }
            } else {
                configLocationStr = configLocation.toString();
                for (ConfigurationFactory factory3 : Factory.getFactories()) {
                    String[] types = factory3.getSupportedTypes();
                    if (types == null) continue;
                    for (String type : types) {
                        Configuration config5;
                        if (!type.equals(ALL_TYPES) && !configLocationStr.endsWith(type) || (config5 = factory3.getConfiguration(loggerContext, name, configLocation)) == null) continue;
                        return config5;
                    }
                }
            }
            if ((config2 = this.getConfiguration(loggerContext, true, name)) == null && (config2 = this.getConfiguration(loggerContext, true, null)) == null && (config2 = this.getConfiguration(loggerContext, false, name)) == null) {
                config2 = this.getConfiguration(loggerContext, false, null);
            }
            if (config2 != null) {
                return config2;
            }
            LOGGER.error("No log4j2 configuration file found. Using default configuration: logging only errors to the console. Set system property 'log4j2.debug' to show Log4j2 internal initialization logging.");
            return new DefaultConfiguration();
        }

        private Configuration getConfiguration(LoggerContext loggerContext, String configLocationStr) {
            ConfigurationSource source2 = null;
            try {
                source2 = ConfigurationSource.fromUri(NetUtils.toURI(configLocationStr));
            }
            catch (Exception ex) {
                LOGGER.catching(Level.DEBUG, ex);
            }
            if (source2 == null) {
                ClassLoader loader = LoaderUtil.getThreadContextClassLoader();
                source2 = this.getInputFromString(configLocationStr, loader);
            }
            if (source2 != null) {
                for (ConfigurationFactory factory2 : Factory.getFactories()) {
                    String[] types = factory2.getSupportedTypes();
                    if (types == null) continue;
                    for (String type : types) {
                        Configuration config2;
                        if (!type.equals(ALL_TYPES) && !configLocationStr.endsWith(type) || (config2 = factory2.getConfiguration(loggerContext, source2)) == null) continue;
                        return config2;
                    }
                }
            }
            return null;
        }

        private Configuration getConfiguration(LoggerContext loggerContext, boolean isTest, String name) {
            boolean named = Strings.isNotEmpty(name);
            ClassLoader loader = LoaderUtil.getThreadContextClassLoader();
            for (ConfigurationFactory factory2 : Factory.getFactories()) {
                String prefix = isTest ? ConfigurationFactory.TEST_PREFIX : ConfigurationFactory.DEFAULT_PREFIX;
                String[] types = factory2.getSupportedTypes();
                if (types == null) continue;
                for (String suffix : types) {
                    String configName;
                    ConfigurationSource source2;
                    if (suffix.equals(ALL_TYPES) || (source2 = ConfigurationSource.fromResource(configName = named ? prefix + name + suffix : prefix + suffix, loader)) == null) continue;
                    if (!factory2.isActive()) {
                        LOGGER.warn("Found configuration file {} for inactive ConfigurationFactory {}", (Object)configName, (Object)factory2.getClass().getName());
                    }
                    return factory2.getConfiguration(loggerContext, source2);
                }
            }
            return null;
        }

        @Override
        public String[] getSupportedTypes() {
            return null;
        }

        @Override
        public Configuration getConfiguration(LoggerContext loggerContext, ConfigurationSource source2) {
            if (source2 != null) {
                String config2 = source2.getLocation();
                for (ConfigurationFactory factory2 : Factory.getFactories()) {
                    String[] types = factory2.getSupportedTypes();
                    if (types == null) continue;
                    for (String type : types) {
                        if (!type.equals(ALL_TYPES) && (config2 == null || !config2.endsWith(type))) continue;
                        Configuration c = factory2.getConfiguration(loggerContext, source2);
                        if (c != null) {
                            LOGGER.debug("Loaded configuration from {}", (Object)source2);
                            return c;
                        }
                        LOGGER.error("Cannot determine the ConfigurationFactory to use for {}", (Object)config2);
                        return null;
                    }
                }
            }
            LOGGER.error("Cannot process configuration, input source is null");
            return null;
        }
    }
}

