/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.spi.ConfigProcessor;
import io.vertx.config.spi.utils.JsonObjectHelper;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesConfigProcessor
implements ConfigProcessor {
    @Override
    public String name() {
        return "properties";
    }

    @Override
    public Future<JsonObject> process(Vertx vertx, JsonObject configuration, Buffer input) {
        boolean hierarchicalData = configuration.getBoolean("hierarchical", false);
        boolean rawData = configuration.getBoolean("raw-data", false);
        return vertx.executeBlocking(future -> {
            byte[] bytes = input.getBytes();
            try (ByteArrayInputStream stream2 = new ByteArrayInputStream(bytes);){
                JsonObject parsed = PropertiesConfigProcessor.readAsJson(stream2, rawData, hierarchicalData);
                future.complete(parsed);
            }
            catch (Exception e) {
                future.fail(e);
            }
        });
    }

    private static JsonObject readAsJson(InputStream stream2, boolean rawData, boolean hierarchical) throws IOException {
        Properties properties = new Properties();
        properties.load(stream2);
        return JsonObjectHelper.from(properties, rawData, hierarchical);
    }
}

