/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.DistinctPublisher;
import com.mongodb.reactivestreams.client.internal.BatchCursorPublisher;
import com.mongodb.reactivestreams.client.internal.MongoOperationPublisher;
import java.util.concurrent.TimeUnit;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

final class DistinctPublisherImpl<T>
extends BatchCursorPublisher<T>
implements DistinctPublisher<T> {
    private final String fieldName;
    private Bson filter;
    private long maxTimeMS;
    private Collation collation;
    private BsonValue comment;

    DistinctPublisherImpl(@Nullable ClientSession clientSession, MongoOperationPublisher<T> mongoOperationPublisher, String fieldName, Bson filter2) {
        super(clientSession, mongoOperationPublisher);
        this.fieldName = Assertions.notNull("fieldName", fieldName);
        this.filter = Assertions.notNull("filter", filter2);
    }

    @Override
    public DistinctPublisher<T> filter(@Nullable Bson filter2) {
        this.filter = filter2;
        return this;
    }

    @Override
    public DistinctPublisher<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public DistinctPublisher<T> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public DistinctPublisher<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public DistinctPublisher<T> comment(@Nullable String comment) {
        this.comment = comment != null ? new BsonString(comment) : null;
        return this;
    }

    @Override
    public DistinctPublisher<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    AsyncReadOperation<AsyncBatchCursor<T>> asAsyncReadOperation(int initialBatchSize) {
        return this.getOperations().distinct(this.fieldName, this.filter, this.getDocumentClass(), this.maxTimeMS, this.collation, this.comment);
    }
}

