/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.media.scheduler;

import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.restcomm.media.scheduler.Clock;
import org.restcomm.media.scheduler.Scheduler;
import org.restcomm.media.scheduler.WallClock;

public class ServiceScheduler
implements Scheduler {
    private static final Logger LOGGER = LogManager.getLogger(ServiceScheduler.class);
    public static final int POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private volatile boolean started = false;
    private final Clock wallClock;
    private ScheduledExecutorService executor;
    private final ThreadFactory threadFactory = new ThreadFactory(){
        private AtomicInteger index = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "service-scheduler-" + this.index.incrementAndGet());
        }
    };

    public ServiceScheduler(Clock wallClock) {
        this.wallClock = new WallClock();
    }

    public ServiceScheduler() {
        this(new WallClock());
    }

    @Override
    public Clock getWallClock() {
        return this.wallClock;
    }

    @Override
    public Future<?> submit(Runnable task) throws RejectedExecutionException {
        if (!this.started) {
            throw new RejectedExecutionException("Scheduler is not running.");
        }
        return this.executor.submit(task);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) throws RejectedExecutionException {
        if (!this.started) {
            throw new RejectedExecutionException("Scheduler is not running.");
        }
        return this.executor.schedule(task, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long period, TimeUnit unit) throws IllegalArgumentException, RejectedExecutionException {
        if (!this.started) {
            throw new RejectedExecutionException("Scheduler is not running.");
        }
        return this.executor.scheduleWithFixedDelay(task, initialDelay, period, unit);
    }

    @Override
    public void start() {
        if (!this.started) {
            this.started = true;
            this.executor = Executors.newScheduledThreadPool(POOL_SIZE, this.threadFactory);
            ((ScheduledThreadPoolExecutor)this.executor).setRemoveOnCancelPolicy(true);
            ((ScheduledThreadPoolExecutor)this.executor).prestartAllCoreThreads();
            LOGGER.info("Started scheduler!");
        }
    }

    @Override
    public void stop() {
        if (this.started) {
            this.started = false;
            this.executor.shutdownNow();
            LOGGER.info("Stopped scheduler!");
        }
    }

    @Override
    public boolean awaitTermination(long timeout2, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout2, unit);
    }
}

