/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.callsite;

import groovy.lang.GroovyInterceptable;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.stream.IntStream;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GroovyCategorySupport;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.callsite.AbstractCallSite;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.MetaClassConstructorSite;
import org.codehaus.groovy.runtime.callsite.NullCallSite;
import org.codehaus.groovy.runtime.callsite.PerInstancePojoMetaClassSite;
import org.codehaus.groovy.runtime.callsite.PogoInterceptableSite;
import org.codehaus.groovy.runtime.callsite.PogoMetaClassSite;
import org.codehaus.groovy.runtime.callsite.PojoMetaClassSite;
import org.codehaus.groovy.runtime.callsite.StaticMetaClassSite;

public final class CallSiteArray {
    public static final Object[] NOPARAM = new Object[0];
    public final CallSite[] array;
    public final Class owner;

    public CallSiteArray(Class owner, String[] names) {
        this.owner = owner;
        this.array = (CallSite[])IntStream.range(0, names.length).mapToObj(i2 -> new AbstractCallSite(this, i2, names[i2])).toArray(CallSite[]::new);
    }

    public static Object defaultCall(CallSite callSite, Object receiver2, Object[] args2) throws Throwable {
        return CallSiteArray.createCallSite(callSite, receiver2, args2).call(receiver2, args2);
    }

    public static Object defaultCallCurrent(CallSite callSite, GroovyObject receiver2, Object[] args2) throws Throwable {
        return CallSiteArray.createCallCurrentSite(callSite, receiver2, args2, callSite.getArray().owner).callCurrent(receiver2, args2);
    }

    public static Object defaultCallStatic(CallSite callSite, Class receiver2, Object[] args2) throws Throwable {
        return CallSiteArray.createCallStaticSite(callSite, receiver2, args2).callStatic(receiver2, args2);
    }

    public static Object defaultCallConstructor(CallSite callSite, Object receiver2, Object[] args2) throws Throwable {
        return CallSiteArray.createCallConstructorSite(callSite, (Class)receiver2, args2).callConstructor(receiver2, args2);
    }

    private static CallSite createCallStaticSite(CallSite callSite, Class receiver2, Object[] args2) {
        CallSiteArray.doPrivileged(() -> {
            try {
                Class.forName(receiver2.getName(), true, receiver2.getClassLoader());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        });
        MetaClass metaClass = InvokerHelper.getMetaClass(receiver2);
        CallSite site = metaClass instanceof MetaClassImpl ? ((MetaClassImpl)metaClass).createStaticSite(callSite, args2) : new StaticMetaClassSite(callSite, metaClass);
        CallSiteArray.replaceCallSite(callSite, site);
        return site;
    }

    private static void doPrivileged(PrivilegedAction<Void> action) {
        AccessController.doPrivileged(action);
    }

    private static CallSite createCallConstructorSite(CallSite callSite, Class receiver2, Object[] args2) {
        MetaClass metaClass = InvokerHelper.getMetaClass(receiver2);
        CallSite site = metaClass instanceof MetaClassImpl ? ((MetaClassImpl)metaClass).createConstructorSite(callSite, args2) : new MetaClassConstructorSite(callSite, metaClass);
        CallSiteArray.replaceCallSite(callSite, site);
        return site;
    }

    private static CallSite createCallCurrentSite(CallSite callSite, GroovyObject receiver2, Object[] args2, Class sender) {
        CallSite site;
        if (receiver2 instanceof GroovyInterceptable) {
            site = new PogoInterceptableSite(callSite);
        } else {
            MetaClass metaClass = receiver2.getMetaClass();
            Class theClass = metaClass.getTheClass();
            site = receiver2.getClass() != theClass && !theClass.isInterface() ? new PogoInterceptableSite(callSite) : (metaClass instanceof MetaClassImpl ? ((MetaClassImpl)metaClass).createPogoCallCurrentSite(callSite, sender, args2) : new PogoMetaClassSite(callSite, metaClass));
        }
        CallSiteArray.replaceCallSite(callSite, site);
        return site;
    }

    private static CallSite createPojoSite(CallSite callSite, Object receiver2, Object[] args2) {
        Class<?> klazz = receiver2.getClass();
        MetaClass metaClass = InvokerHelper.getMetaClass(receiver2);
        if (!GroovyCategorySupport.hasCategoryInCurrentThread() && metaClass instanceof MetaClassImpl) {
            MetaClassImpl mci = (MetaClassImpl)metaClass;
            ClassInfo info = mci.getTheCachedClass().classInfo;
            if (info.hasPerInstanceMetaClasses()) {
                return new PerInstancePojoMetaClassSite(callSite, info);
            }
            return mci.createPojoCallSite(callSite, receiver2, args2);
        }
        ClassInfo info = ClassInfo.getClassInfo(klazz);
        if (info.hasPerInstanceMetaClasses()) {
            return new PerInstancePojoMetaClassSite(callSite, info);
        }
        return new PojoMetaClassSite(callSite, metaClass);
    }

    private static CallSite createPogoSite(CallSite callSite, Object receiver2, Object[] args2) {
        if (receiver2 instanceof GroovyInterceptable) {
            return new PogoInterceptableSite(callSite);
        }
        MetaClass metaClass = ((GroovyObject)receiver2).getMetaClass();
        if (metaClass instanceof MetaClassImpl) {
            return ((MetaClassImpl)metaClass).createPogoCallSite(callSite, args2);
        }
        return new PogoMetaClassSite(callSite, metaClass);
    }

    private static CallSite createCallSite(CallSite callSite, Object receiver2, Object[] args2) {
        if (receiver2 == null) {
            return new NullCallSite(callSite);
        }
        CallSite site = receiver2 instanceof Class ? CallSiteArray.createCallStaticSite(callSite, (Class)receiver2, args2) : (receiver2 instanceof GroovyObject ? CallSiteArray.createPogoSite(callSite, receiver2, args2) : CallSiteArray.createPojoSite(callSite, receiver2, args2));
        CallSiteArray.replaceCallSite(callSite, site);
        return site;
    }

    private static void replaceCallSite(CallSite oldSite, CallSite newSite) {
        oldSite.getArray().array[oldSite.getIndex()] = newSite;
    }
}

