/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;

@DataObject
public class MongoClientUpdateResult {
    public static final long DEFAULT_DOCMATCHED = 0L;
    public static final long DEFAULT_DOCMODIFIED = 0L;
    public static final String DOC_MATCHED = "doc_matched";
    public static final String UPSERTED_ID = "upserted_id";
    public static final String DOC_MODIFIED = "doc_modified";
    public static final String ID_FIELD = "_id";
    private long docMatched;
    private JsonObject docUpsertedId;
    private long docModified;

    public MongoClientUpdateResult() {
        this.docMatched = 0L;
        this.docModified = 0L;
    }

    public MongoClientUpdateResult(long docMatched, JsonObject docUpsertedId, long docModified) {
        this.docMatched = docMatched;
        this.docUpsertedId = docUpsertedId;
        this.docModified = docModified;
    }

    public MongoClientUpdateResult(MongoClientUpdateResult mongoClientUpdateResultCopy) {
        this.docMatched = mongoClientUpdateResultCopy.getDocMatched();
        this.docUpsertedId = mongoClientUpdateResultCopy.getDocUpsertedId();
        this.docModified = mongoClientUpdateResultCopy.getDocModified();
    }

    public MongoClientUpdateResult(JsonObject mongoClientUpdateResultJson) {
        this.docMatched = mongoClientUpdateResultJson.getLong(DOC_MATCHED, 0L);
        this.docUpsertedId = mongoClientUpdateResultJson.getJsonObject(UPSERTED_ID, null);
        this.docModified = mongoClientUpdateResultJson.getLong(DOC_MODIFIED, 0L);
    }

    public JsonObject toJson() {
        JsonObject mongoClientUpdateResultJson = new JsonObject();
        if (this.docMatched != 0L) {
            mongoClientUpdateResultJson.put(DOC_MATCHED, this.docMatched);
        }
        if (this.docUpsertedId != null) {
            mongoClientUpdateResultJson.put(UPSERTED_ID, this.docUpsertedId);
        }
        if (this.docModified != 0L) {
            mongoClientUpdateResultJson.put(DOC_MODIFIED, this.docModified);
        }
        return mongoClientUpdateResultJson;
    }

    public long getDocMatched() {
        return this.docMatched;
    }

    public JsonObject getDocUpsertedId() {
        return this.docUpsertedId;
    }

    public long getDocModified() {
        return this.docModified;
    }

    public boolean equals(Object obj) {
        MongoClientUpdateResult mongoClientUpdateResult;
        if (this == obj) {
            return true;
        }
        return obj instanceof MongoClientUpdateResult && this.docMatched == (mongoClientUpdateResult = (MongoClientUpdateResult)obj).getDocMatched() && this.docUpsertedId.equals(mongoClientUpdateResult.getDocUpsertedId()) && this.docModified == mongoClientUpdateResult.docModified;
    }

    public int hashCode() {
        int result2 = 23;
        result2 = 31 * result2 + (int)(this.docMatched ^ this.docMatched >>> 32);
        result2 = 31 * result2 + (this.docUpsertedId != null ? this.docUpsertedId.hashCode() : 0);
        result2 = 31 * result2 + (int)(this.docModified ^ this.docModified >>> 32);
        return result2;
    }
}

